/*
 *  $Header: npc_vfsops.c,v 1.2 89/04/07 12:38:35 root Exp $
 */
#include "param.h"	    /* needed for vfs.h */
#include "errno.h"
#include "user.h"	    /* has implied time.h for vnode.h */
#include "vfs.h"
#include "../netinet/in.h"  /* needed for mount.h */
#define	NPCargs
#undef	NFSSAVE
#ifdef NFS
#define NFSSAVE
#endif
#undef NFS
#include "mount.h"	    /* needed for npcfs.h */
#ifdef NFSSAVE
#define NFS
#endif
#undef	NPCargs
#include "kernel.h"
#include "vnode.h"	    /* needed for npcfs.h */
#include "socketvar.h" /* needed for npcfs.h */
#include "sendbuf.h"
#include "nbios.h"	    /* needed for npcfs.h */
#include "npcfs.h"
#include "smb.h"

int npc_mount();
int npc_unmount();
int npc_root();
int npc_statfs();
int npc_badop();	/* defined in npc_vnodeops.c */
int npc_noop();		/* defined in npc_vnodeops.c */

struct vfsops	npc_vfsops = {
    npc_mount,		/* mount */
    npc_unmount,	/* unmount */
    npc_root,		/* get root vnode */
    npc_statfs,		/* statfs */
    npc_noop,		/* sync */   /* TODO */
    npc_badop,		/* get vnode from fid */
};

int	npc_mount_count;

#ifdef DEBUG
#define	RETURN(a,b)	printf((a, b)); return(b)
#else
#define	RETURN(a,b)	return(b)
#endif DEBUG

/*
 *	npc mount vfsop
 *	Set up mount info and socket to pc
 */
int
npc_mount(np, data)
char	    *np;
caddr_t	    data;
{
    int		    error;
    struct npc_args args;
    char	    fname[NB_NAME_LEN+NB_SNAME_LEN+4];
    char	    *name = &fname[2];
    char	    *tcp;
    int		    len;
    int		    i;
    

    if(error = copyinstr(np, fname, NB_NAME_LEN+NB_SNAME_LEN+4, &len)) {
	RETURN("mount args copyinstr failed:%d\n", error);
    }
    
    if(*(short *)fname != *(short *)"/@") {
	/* remove this  and next line soon */
	printf("obsolete mount syntax for pc file system. \n");
	RETURN("npc mount name does not have /@...\n", EINVAL);
    }
    
    if(error = copyin(data, (caddr_t)&args, sizeof(args))) {
	RETURN("mount args copyin failed:%d\n", error);
    }
    /*  check for valid characters */
    if(npc_checknetname(name) < 0) {
	RETURN("mount args, bad name\n", EINVAL);
    }

    return(npc_intmount(name, &args));
}
int
npc_unmount(vfsp)
struct vfs  *vfsp;
{
    struct pcaccess  **app;
    struct pcaccess  *ap;

    for(app = &(vftomi(vfsp)->m_alist);	*app != NULL;
	app = &((*app)->pa_next)) {
	if((*app)->pa_uid == u.u_cred->cr_uid) {
	    ap = *app;
	    if(--(ap->pa_usecnt) == 0) {
		*app = ap->pa_next;
		kmem_free((caddr_t)ap, sizeof(struct pcaccess));
	    }
	    goto found;
	}
    }
#ifdef DEBUG
    printf("file system not owned by this user\n");
#endif DEBUG
    if(suser()) {
	goto kill_fs;
    } else if(vftomi(vfsp)->m_alist != NULL) {
	return(EPERM);
    }
    
found:
    if(vftomi(vfsp)->m_alist == NULL) {
	/* now there are no more references to this file system */
kill_fs:
	if(vftomi(vfsp)->m_vcnt > 1) {
	    /* someone is using file system, rootvp should be the only
	     * held vnode */
#ifdef DEBUG
	    printf("fs still has %x active vnodes\n", vftomi(vfsp)->m_vcnt);
#endif
	    if(suser()) {
		vftomi(vfsp)->m_flags |= NPCMNT_BADFS;
	    }
	    return(EBUSY);
	}

	/* releasing the rootvp will dealloc the file system */
	u.u_error = 0;
	VN_RELE(vftomi(vfsp)->m_rootvp);    /* should be final release */
	if(u.u_error) return(u.u_error);
    }
    return(0);
}
int
npc_intmount(name, args)
char		    *name;
struct npc_args	    *args;
{
#define				MAXPSWD 127
    char			passwd[MAXPSWD+1];
    int				passwdlen;
    register struct pcmountinfo	*mi;
    int				vfsneedsadded = 0;
    int				error;
    struct vfs			*vfsp;
    struct sendbuf		*sb;
    struct pcaccess		*ap;
    unsigned short		trash,bsize,err;
    unsigned char		rcls;
    
    if (args->passwd) {
	if(error = copyinstr(args->passwd, passwd, MAXPSWD, &passwdlen)) {
	    RETURN("mount args copyinstr failed:%d\n", error);
	}
	passwd[passwdlen] = '\0';
	if(passwdlen > NB_PASSWD_LEN) {
	    RETURN("password for mount is too long\n", EINVAL);
	}
    } else {
	passwd[0] = '\0';
	passwdlen = 0;
    }
    

    /*
     *	Check to see if we already have this file system
     */

    if (vfsp = npc_searchforfs(name)) {

	mi = vftomi(vfsp);

	/* do not lock it yet */
	if(mi->m_sock != NULL) {
	    while (mi->m_sock->ps_busy) {
		if(sleep((caddr_t)mi->m_sock, (PZERO+1)|PCATCH)) {
		    return(EINTR);
		}
	    }
	}

	if(mi->m_flags&NPCMNT_BADFS) {
	    return(EIO);
	}
	
	if (mi->m_passwd) {
	    if (passwdlen == 0 || strcmp(passwd, mi->m_passwd) != 0) {
		return(EINVAL);
	    }
	} else {
	    if (passwdlen != 0) {
		return(EINVAL);
	    }
	}
	goto access;

    } else {

	if ((vfsp= (struct vfs *)kmem_alloc(sizeof(struct vfs))) == NULL) {
		RETURN("failed to allocate vfs\n", ENOMEM);
	}
	vfsneedsadded = 1;
	vfsp->vfs_fsid.val[0] = npc_mount_count++;
	vfsp->vfs_fsid.val[1] = MOUNT_NPC;
	vfsp->vfs_flag = 0;
	vfsp->vfs_vnodecovered = NULL;
	vfsp->vfs_op = &npc_vfsops;
	
	if ((vfsp->vfs_data = (caddr_t)kmem_alloc(sizeof(struct pcmountinfo)))
		    == NULL) {
	    kmem_free(vfsp, sizeof(struct vfs));
	    RETURN("failed to allocate pcmountinfo\n", ENOMEM);
	}
	mi = vftomi(vfsp);
	mi->m_vcnt = 0;
	mi->m_vfsp = vfsp;
	mi->m_sock = NULL;
	mi->m_atime = time;
	mi->m_alist = NULL;
	mi->m_flags = NULL;
/*        mi->m_flags |= NPCMNT_ACTIVE; */
	mi->m_blksize = 0;  /* gets replaced on first getattr or statfs */
	bcopy(passwd, mi->m_passwd, passwdlen+1);
		
	/* npc_getvnode will increment refcount for vnode */
	if ((mi->m_rootvp = npc_getvnode(vfsp)) == NULL) {
	    kmem_free(vfsp->vfs_data, sizeof(struct pcmountinfo));
	    kmem_free(vfsp, sizeof(struct vfs));
	    RETURN("failed to allocate vnode\n", ENOMEM);
	}
	/* root vnode is not entered in the hash table */
	mi->m_rootvp->v_type = VDIR;
	mi->m_rootvp->v_flag = VROOT;
	vtopc(mi->m_rootvp)->pc_parent = NULL;
	bcopy(&args->ip_addr, &mi->m_addr, sizeof(mi->m_addr));
	npc_splitname(name, mi->m_name, mi->m_sname);
    
access:
	for(ap = mi->m_alist; ap != NULL; ap= ap->pa_next) {
	    if(ap->pa_uid == u.u_cred->cr_uid){
		break;
	    }
	}
	if(ap == NULL ) {
	    ap = (struct pcaccess *) kmem_alloc(sizeof(struct pcaccess));
	    ap->pa_next = mi->m_alist;
	    mi->m_alist = ap;
	    ap->pa_uid = u.u_cred->cr_uid;
	    ap->pa_flags = 0;
	    ap->pa_usecnt = 0;
	}
	
	if(mi->m_sock) {
	    return(0);
	}
	
	/* this will increment ps_refcnt for us */
	/* makesocket will look for an existing socket to the pc */
	/* makesocket will also lock the socket */
	if (error = npc_makesocket(mi)) {
#ifdef DEBUG
	    printf("failed to obtain socket for pc file system, errno:%d, vp:%x\n",
		   error, mi->m_rootvp);
#endif DEBUG
e1:	    error = npc_doerror(error, mi);
	    mi->m_flags |= NPCMNT_BADFS;
	    VN_RELE(mi->m_rootvp);	/* this will clean everything at end
					 * of last reference */
	    return(error);
	}
	if (error = npc_treeconnect(mi)) {
#ifdef DEBUG
	    printf("failed to treeconnect, errno:%d\n", error);
#endif DEBUG
	    /* socket is not checked in */
	    goto e1;
	}
	/* release the hold on socket set by npc_makesocket */
	CKIN_SOCK(mi->m_sock);
    }

    if(vfsneedsadded) {
	vfsp->vfs_next = rootvfs->vfs_next;
	rootvfs->vfs_next = vfsp;
    }
    
    ap->pa_usecnt++;
    if(args->no_age) {
	ap->pa_flags |= NPCMNT_NOAGE;
    }
    
    return(0);
}
/*
 *	find root of npc
 */
npc_root(vfsp, vpp)
struct vfs	*vfsp;
struct vnode	**vpp;
{
    *vpp = vftomi(vfsp)->m_rootvp;
}
/*
 *	get file system statistics
 */
npc_statfs(vfsp, sbp)
struct vfs  *vfsp;
struct statfs	*sbp;
{
    struct sendbuf  *sendbp;
    char	    rcls;
    short	    err;
    short	    units;
    short	    blocks;
    short	    bsize;
    short	    free;
    int		    error;

    CKHEALTH(vftomi(vfsp));
	
    sbp->f_type = vfsp->vfs_fsid.val[1];
    sbp->f_files = -1;
    sbp->f_ffree = -1;
    bcopy((caddr_t)&vfsp->vfs_fsid, (caddr_t)&sbp->f_fsid, sizeof(fsid_t));

    if(error = doSMB(buildSMBdskattr, HAVENOSOCK, vftomi(vfsp), HAVENOBUF,
		     &sendbp)) {
#ifdef DEBUG
	printf("npc_statfs, failed doSMB, error:%d\n", error);
#endif DEBUG
	return(npc_doerror(error, vftomi(vfsp)));
    }
    extractSMBdskattr(sendbp->buf, &rcls, &err, &units, &blocks, &bsize, &free);
    CKIN_BUF(sendbp);
    CKIN_SOCK(vftomi(vfsp)->m_sock);
    if(rcls != SUCCESS) {
#ifdef DEBUG
	printf("error in npc_statfs - rcls:%x error:%x\n", rcls, err);
#endif
	return(EIO);
    }
    
    vftomi(vfsp)->m_blksize = sbp->f_bsize = bsize;
    sbp->f_blocks = units * blocks;
    sbp->f_bfree = sbp->f_bavail = free * blocks;
    return(0);
}

npc_machid(vp)
struct vnode	*vp;
{
    return(vtopc(vftomi(vp->v_vfsp)->m_rootvp)->pc_nodeid);
}

