/*
 *  $Header: npc_unix.c,v 1.2 89/04/07 12:38:33 root Exp $
 */
#include "param.h"
#include "errno.h"
#include "user.h"	    /* has implied time.h for vnode.h */
#include "proc.h"
#include "vfs.h"
#include "../netinet/in.h"  /* needed for mount.h */
#undef NFS
#include "mount.h"	    /* needed for npcfs.h */
#include "kernel.h"
#include "vnode.h"	    /* needed for npcfs.h */
#include "socketvar.h" /* needed for npcfs.h */
#include "../wipc/wipc.h"
#include "nbios.h"
#include "npcfs.h"
#include "buf.h"
#include "file.h"

static char		machname[NB_NAME_LEN+NB_SNAME_LEN+2];
char *
npc_getmachname(id)
int	id;
{
    struct vfs		*vfsp;
    struct pcmountinfo	*mi;
    int			len;
    
    id &= ~MID_MASK;
    for (vfsp = rootvfs; vfsp != (struct vfs *)0; vfsp = vfsp->vfs_next) {
	if (vfsp->vfs_fsid.val[1] == MOUNT_NPC &&
	    vftomi(vfsp)->m_rootvp->v_count > 0 &&
	    id == vtopc(vftomi(vfsp)->m_rootvp)->pc_nodeid) {
	    mi = vftomi(vfsp);
	    len = strlen(mi->m_name);
	    bcopy(mi->m_name, machname, len);
	    machname[len] = '.';
	    strcpy(&machname[len+1], mi->m_sname);
	    return(machname);
	}
    }
    return((char *)0);
}

tvp(vp)
struct vnode	*vp;
{
    return(vp->v_vfsp->vfs_fsid.val[1] == MOUNT_NPC);
}

npc_get_nbiow_path(path)
char	*path;
{
    struct vnode    *vp = 0;
    struct buf	    *bp = 0;
    int		    resid;
    int		    i;
    char	    *cp, *ocp;
    label_t	    lqsave;

#define	    DEFNAME "/usr"
    bcopy(DEFNAME, path, sizeof(DEFNAME));
    return(0);

    lqsave = u.u_qsave;
    if (setjmp(&u.u_qsave)) {
	if(vp) VN_RELE(vp);
	if(bp) brelse(bp);
	u.u_error = EINTR;
	printf("setjmp eintr:%d\n", u.u_error);
	u.u_qsave = lqsave;
	return(-1);
    }
    if(u.u_error = vn_open("/usr/ow", UIOSEG_KERNEL, FREAD, 0, &vp)) {
	printf("open error:%d\n", u.u_error);
	u.u_qsave = lqsave;
	return(-1);
    }
    bp = geteblk(MAXPATHLEN);
    
    if( u.u_error = vn_rdwr(UIO_READ, vp, bp->b_un.b_addr, bp->b_bcount,
			0, UIOSEG_KERNEL, IO_UNIT, &resid)) {
	u.u_error = -u.u_error;
	if(vp) VN_RELE(vp);
	if(bp) brelse(bp);
	u.u_qsave = lqsave;
	printf("rdwr error:%d\n", u.u_error);
	return(-1);
    }
#ifdef DEBUG
    printf("read %d bytes from /usr/ow\n", MAXPATHLEN - resid);
#endif DEBUG
    cp = bp->b_un.b_addr;
    ocp = path;
    for(i = 0; i < MAX_NBIOWLEN && *cp != '\0' && *cp != '\n'; i++) {
	*ocp++ = *cp++;
    }
    *ocp = '\0';
    if(i == MAX_NBIOWLEN) {
#ifdef DEBUG
	printf("had to truncate nbiow\n");
#endif DEBUG
	*path = '\0';
    }

    
    VN_RELE(vp);
    brelse(bp);
    printf("at end of getpath:%s:\n", path);

    u.u_qsave = lqsave;
    return(0);
}
