/* $Header: npc_time.c,v 1.13 88/06/28 15:32:44 hutch Exp $ */

#include "param.h"
#include "mbuf.h"
#include "socket.h"
#include "uio.h"
#include "un.h"
#include "file.h"
#include "user.h"
#include "vfs.h"
#include "../netinet/in.h"  /* needed for mount.h */
#include "vnode.h"	    /* needed for npcfs.h */
#include "socketvar.h"	    /* needed for npcfs.h */
#undef NFS
#include "mount.h"	    /* needed for npcfs.h */
#include "nbios.h"
#include "npcfs.h"
#include "buf.h"

#define		NSPM	    60	    /* number of seconds per minute */
#define		NSPH	    3600    /* number of seconds per hour */
#define		NSPD	    86400   /* number of seconds per day */
#define		NSPY	    31536000  /*  number of seconds per non leapyear */
#define		NSBY	    315532800 /* number of secs in 1970-1979 */

/*----------------------------------------------------------+
|  In the following table, each month's entry contains the  |
|  number of seconds accumulated in all the previous months |
|  and no seconds from itself.  March and beyond assume a   |
|  February with 28 days, so if the year is a leapyear, and |
|  the month is greater than 2, NSPD must be added          |
+--------------------------------------------------------- */

static unsigned long	months[13] = {
	0,			    /* unused */
	0,			    /* January */
	2678400,		    /* February */
	5097600,		    /* March */
	7776000,		    /* April */
       10368000,		    /* May */
       13046400,		    /* June */
       15638400,		    /* July */
       18316800,		    /* August */
       20995200,		    /* September */
       23587200,		    /* October */
       26265600,		    /* November */
       28857600 		    /* December */
};

static unsigned long	second,	    /* count in two-second jumps */
			minute,	    /* literal minute, 0-59 */
			hour,	    /* military time: 0-23 */
			day,	    /* the day of the month */
			month,	    /* the month number, Jan = 1 */
			year;	    /* number of years since 1980: 1987 = 7 */

struct tzhead {
    unsigned char    tzh_reserved[32];
    unsigned char    tzh_timecnt[4];
    unsigned char    tzh_typecnt[4];
    unsigned char    tzh_charcnt[4];
};

#define	    TZ_MAX_TIMES    370
#define	    TZ_MAX_TYPES    10
#define	    TZ_MAX_CHARS    50

struct ttinfo {				/* time type information */
	long		tt_gmtoff;	/* GMT offset in seconds */
	int		tt_isdst;	/* used to set tm_isdst */
	int		tt_abbrind;	/* abbreviation list index */
};

struct zonestate {
	unsigned int	timecnt;
	unsigned int	typecnt;
	unsigned int	charcnt;
	time_t		ats[TZ_MAX_TIMES];
	unsigned char	types[TZ_MAX_TIMES];
	struct ttinfo	ttis[TZ_MAX_TYPES];
	char		chars[TZ_MAX_CHARS + 1];
};

struct zonestate	zs;
int			npc_have_zoneinfo = 0;
time_t			*startp, *endp, *optp;

#define			JAN_01_80	0x12cf0870
			
/*----------------------------------------------------+
|  strip the six time values from their bitfields in  |
|  time and date.  No byte reversal done here.  No    |
|  processing of these values done here.              |
+--------------------------------------------------- */

get_fields(timefields,datefields)
unsigned short	timefields;
unsigned short	datefields;

{
    second = timefields & 0x001f;
    minute = ( timefields & 0x07e0 ) >> 5;
    hour = ( timefields & 0xf800 ) >> 11;

    day = datefields & 0x001f;
    month = ( datefields & 0x01e0 ) >> 5;
    year = ( datefields & 0xfe00 ) >> 9;
#ifdef notdef
printf("npc_time: sec %d min %d hour %d day %d mon %d year %d\n",
		second,minute,hour,day,month,year);
#endif DEBUG
}

/*---------------------------------------------------------+
|  The public routine from this module.  Given time and    |
|  date bitfields of this form:                            |
|	time -- hhhhhmmmmmmxxxxx                           |
|	date -- yyyyyyymmmmddddd                           |
|  convert to and return one unsigned long containing the  |
|  number of seconds between this local time and 1 Jan '70 |
|  at 0:00:00 expressed in Greenwich Time                  |
+-------------------------------------------------------- */

unsigned long
convert_time_and_date(timefields,datefields)
unsigned short	    timefields;
unsigned short	    datefields;

{
    unsigned long rval;
    unsigned long convert_month(), convert_year();
    int local_to_Greenwich();
#ifdef NOTDEF
printf("npc_time: timefields %x and datefields %x\n",timefields,datefields);
#endif 
    
    get_fields(timefields,datefields);
#ifdef NOTDEF
printf("npc_time: hour %d min %d sec %d\n\t    year %d month %d day %d\n",
			hour,minute,second,year,month,day);
#endif 

    rval = second * 2;
    rval += minute * NSPM;
    rval += hour * NSPH;

    rval += ( day - 1 ) * NSPD;
    rval += convert_month();
    rval += convert_year();

    rval += NSBY;		/* converting since-1980 to since-1970 */
    local_to_Greenwich(&rval);

    return rval;
}


unsigned long
convert_month()

{
    unsigned long rval;

    rval = months[month];

    if ( (month > 2) && ( (year % 4) == 0 ) ) {
	rval += NSPD;
    }

    return rval;
}


unsigned long
convert_year()

{
    unsigned long rval;

    rval = (year * NSPY) + (((year-1) / 4) + 1) * NSPD;

    return rval;
}

int
local_to_Greenwich(localtime)
unsigned long *localtime;

{
    extern struct timezone tz;
    unsigned int diff;

    if ( npc_have_zoneinfo ) {
	diff = get_GMToff(*localtime + (tz.tz_minuteswest * 60) );
	*localtime -= diff;       /* diff is negative */
    }else{
        *localtime = *localtime + ( tz.tz_minuteswest * NSPM );
    }
    return(0);
}

int Greenwich_to_local(Gtime)
unsigned long	    *Gtime;

{
    extern struct timezone tz;
    unsigned int diff;

    if ( npc_have_zoneinfo ) {
	diff = get_GMToff(*Gtime);
	*Gtime += diff;      /*  diff is negative */
    }else{
        *Gtime = *Gtime - ( tz.tz_minuteswest * NSPM );
    }
    return(0);
}

int get_GMToff(timevalue)
time_t		timevalue;

{
    time_t	*end,*zp;
    int		type;

    if ( timevalue < *optp ) {
	zp = startp;
	end = optp;
    }else{
	zp = optp + 1;
	end = endp;
    }

    for (; zp <= end; zp++ ) {
	if ( timevalue < *zp ) {
	    type = zs.types[zp-zs.ats-1];
	    break;
	}
    }
#ifdef notdef
    printf("get_GMToff: %d minutes\n", zs.ttis[type].tt_gmtoff / 60 );
#endif DEBUG
    return zs.ttis[type].tt_gmtoff;

}

int npc_fill_zoneinfo()
{
    unsigned char	*timebuf = 0;
    char		*p;
    int			i;
    struct tzhead	*tzhp;
    struct timeval	nmserv_tmo;
    int			error;
    struct vnode	*vp= 0;
    struct buf		*bp = 0;
    int			resid;
    label_t		lqsave;
#define MAX_ZISIZE	2005
    
    lqsave = u.u_qsave;
    if (setjmp(&u.u_qsave)) {
	if(vp) VN_RELE(vp);
	if(bp) brelse(bp);
	u.u_error = EINTR;
	u.u_qsave = lqsave;
	return(-1);
    }
    if(u.u_error = vn_open("/etc/zoneinfo/localtime", UIOSEG_KERNEL, FREAD,
			0, &vp)) {
#ifdef DEBUG
	printf("failed to open zoneinfo, %d\n", -error);
#endif DEBUG
	u.u_qsave = lqsave;
	return(-1);
    }
    bp = geteblk(MAX_ZISIZE);
    
    if( error = vn_rdwr(UIO_READ, vp, bp->b_un.b_addr, bp->b_bcount,
			0, UIOSEG_KERNEL, IO_UNIT, &resid)) {
	if(vp) VN_RELE(vp);
	if(bp) brelse(bp);
#ifdef DEBUG
	printf("failed to read zoneinfo, %d\n", -error);
#endif DEBUG
	u.u_error = -error;
	u.u_qsave = lqsave;
	return(-1);
    }
    timebuf = bp->b_un.b_addr;
        
    /*-------------------------------------------------------------+
    |  the next order of business is to fill in zs from the buffer.|
    |  Using code from tzset (3), fill the structure and check for |
    |  invalid values, returning error if faulty.                  |
    +------------------------------------------------------------ */

    tzhp = (struct tzhead *) timebuf;
    zs.timecnt = (int) detzcode(tzhp->tzh_timecnt);
    zs.typecnt = (int) detzcode(tzhp->tzh_typecnt);
    zs.charcnt = (int) detzcode(tzhp->tzh_charcnt);

#ifdef DEBUG
    printf("fillzoneinfo: timecnt %d typecnt %d charcnt %d\n",
				zs.timecnt,zs.typecnt,zs.charcnt);
#endif
    if ( zs.timecnt > TZ_MAX_TIMES || 
 	 zs.typecnt == 0 ||
         zs.typecnt > TZ_MAX_TYPES || 
	 zs.charcnt > TZ_MAX_CHARS) {
	if(vp) VN_RELE(vp);	    /* this closes file */
	if(bp) brelse(bp);
#ifdef DEBUG
	printf("counts are wrong for times\n");
#endif
	u.u_qsave = lqsave;
	return -1;
    }
	
    p = timebuf + sizeof ( struct tzhead );
    for (i = 0; i < zs.timecnt; ++i) {
	zs.ats[i] = detzcode(p);
	p += 4;
    }

    bcopy(p, zs.types, zs.timecnt);
    p += zs.timecnt;
	
    for (i = 0; i < zs.typecnt; ++i) {
	register struct ttinfo *	ttisp;
	ttisp = &zs.ttis[i];
	ttisp->tt_gmtoff = detzcode(p);
	p += 4;
	ttisp->tt_isdst = (unsigned char) *p++;
	ttisp->tt_abbrind = (unsigned char) *p++;
    }

    bcopy(p, zs.chars, zs.charcnt);
    p += zs.charcnt;
    zs.chars[i] = '\0';	/* ensure '\0' at end */
    if(vp) VN_RELE(vp);	    /* this closes file */
    vp = 0;
    if(bp) brelse(bp);
    bp = 0;
    
    

    /*
    ** Check that all the local time type indices are valid.
    */
    for (i = 0; i < zs.timecnt; ++i) {
        if (zs.types[i] >= zs.typecnt) {
            printf("fill_zoneinfo: types > typecnt\n");
	    u.u_qsave = lqsave;
	    return -1;
	}
    }

    /*-------------------------------------------------------------+
    |  the last order of business:  set some pointers to help us   |
    |  with get_GMToff later, most notably optp, which will point  |
    |  at the first date in zs greater than Jan 01 1980.  Most PC  |
    |  dates fall after this date so we won't always want to start |
    |  search from 1918 or whatever                                |
    +------------------------------------------------------------ */

    startp = zs.ats + 1;		/* not very first one */
    endp = zs.ats + zs.timecnt - 1;	/* very last one */

    for ( optp = startp; *optp < JAN_01_80; optp++ );

    u.u_qsave = lqsave;
    return 0;
}

    
detzcode(codep)
unsigned char		 *codep;
{
    unsigned int	result;
    int	i;

    result = 0;
    for (i = 0; i < 4; ++i)
		result = (result << 8) | (codep[i] & 0xff);
	return result;
}	     
	 
