/*
 *  $Header: npc_subr.c,v 1.2 89/04/07 12:38:31 root Exp $
 */
#include "param.h"
#include "user.h"
#include "proc.h"
#include "vfs.h"
#include "../netinet/in.h"	/* needed for mount.h */
#include "kernel.h"
#include "socketvar.h"
#define	NPCargs
#undef NFS
#include "mount.h"
#undef	NPCargs
#include "vnode.h"
#include "nbios.h"
#include "npcfs.h"
#include "mbuf.h"
#include "errno.h"
#include "socket.h"
#include "uio.h"
#include "un.h"
#include "sendbuf.h"
#include "file.h"
#include "smb.h"
#include "protosw.h"
#include "pathname.h"
struct pcnode		*pcnodefreel = NULL;
int			pcnodecnt = 0;
extern struct vnodeops	*npc_vnodeops;
int			nmservinuse;
extern char		npc_nbiow[];


int
npc_splitname(cp, mname, msname)
char	*cp;
char	*mname;
char	*msname;
{
    register int    i;
    char	    *ts = msname;
    char	    *tm = mname;
    
    
    for (i = 0;; i++) {
	if (*cp == '.') {
	    *mname = '\0';
	    break;
	}
	
	*mname++ = *cp++;
    }

    cp++;

    for (i = 0;; i++) {
	if (*cp == '\0') {
	    *msname = '\0';
	    break;
	}
	*msname++ = *cp++;
    }
    return;
}

/*
 *	get vnode from cache or from kmem
 */
struct vnode *
npc_getvnode(vfsp)
struct vfs  *vfsp;
{
    register struct pcnode  *pn;
    register struct vnode   *vp;
    
    if(pcnodefreel != NULL) {
	pn = pcnodefreel;
	pcnodefreel = pn->pc_next;
    } else {
	if(pcnodecnt > MAXPCNODE) {
	    return(NULL);
	}
	if((pn = (struct pcnode *)kmem_alloc(sizeof(struct pcnode))) == NULL) {
	    return(pn);
	}
    }
    pcnodecnt++;
    vp = &pn->pc_vnode;

    vp->v_flag = 0;
    vp->v_count = 1;
    vp->v_shlockc = vp->v_exlockc = 0;
    vp->v_vfsmountedhere = (struct vfs *) 0;
    vp->v_vfsp = vfsp;
    vftomi(vfsp)->m_vcnt++;
    vp->v_socket = 0;
    vp->v_op = &npc_vnodeops;
    vp->v_data = (caddr_t) pn;
    pn->pc_locklist = (struct pc_lock *)0;
    pn->pc_opencnt = 0;
    pn->pc_xocnt = 0;
    pn->pc_omode = 0;
    pn->pc_parent = (struct vnode *) 0;
    pn->pc_name[0] = '\0';
    pn->pc_nodeid = npc_getnodeid();

    return(vp);
}
#define	    TABSIZ  (MAXPCNODE/(sizeof(long)*NBBY))
static long	npc_idtab[TABSIZ];
npc_getnodeid()
{
    int		    i;
    long	    j;
    
    for(i = 0; i < TABSIZ; i++) {
	if(~npc_idtab[i] != 0) {
	    j = ffs(~npc_idtab[i]);
	    npc_idtab[i] ^= 1 << j-1;
	    /* return value is 1 based */
	    return(i*sizeof(long)*NBBY + j);
	}
    }
    panic("npc_getnodid");
    return(-1);	    /* make lint happy */
}

npc_relnodeid(id)
int	id;
{
    int		    whichl;
    int		    whichb;

    id--;	/* make it zero based */
    whichl = id/(sizeof(long)*NBBY);
    id -= whichl * sizeof(long) * NBBY;
    whichb = 1<<id;
    if((npc_idtab[whichl] & whichb) == 0) {
	printf("whichb.....long:%x, bit:%x\n", whichl, whichb);
#ifdef DEBUG
	panic("whichb");
#endif
    }
    npc_idtab[whichl] ^= whichb;
}

    
/*
 *	establish a socket:
 *	    look among existing sockets, there may already be one
 *	    create one otherwise
 *
 *	WARNING--- this routine sets ps_busy
 */
int
npc_makesocket(mi)
struct pcmountinfo  *mi;
{
    register struct vfs	*vfsp;
    int			error;
    struct mbuf		*m;
    struct sockaddr_in	*sa;
    int			createdsocket = 0;
    int			havesock = 0;
    struct nament	nament;
    
    /* mi->m_sock is assumed to be zero on entry */
    for(vfsp = rootvfs; vfsp != NULL; vfsp = vfsp->vfs_next) {
	struct pcmountinfo *tmi = vftomi(vfsp);
	if(vfsp->vfs_fsid.val[1] == MOUNT_NPC && tmi != mi &&
	   tmi->m_name[0] == mi->m_name[0] &&
	   strcmp(tmi->m_name, mi->m_name) == 0 &&
	   tmi->m_rootvp->v_count > 0 &&
	   (tmi->m_flags & NPCMNT_BADFS) == 0) {
	    mi->m_sock = vftomi(vfsp)->m_sock;
	    mi->m_sock->ps_refcnt++;
	    break;
	}
    }

    if(mi->m_sock == NULL) {
	if((mi->m_sock = (struct pcsock *)kmem_alloc(sizeof(struct pcsock)))
	   == NULL) {
	    return(ENOMEM);
	}
	mi->m_sock->ps_refcnt = 1;
	mi->m_sock->ps_sock = NULL;
	mi->m_sock->ps_busy = 0;
	mi->m_sock->ps_minfo = mi;
	mi->m_sock->ps_pidp = (struct npcpid *) 0;
	mi->m_sock->ps_state = PS_CLEAR;

    }
    
    if(setjmp(&u.u_qsave)) {
#ifdef DEBUG
	    printf("longjmp, makesocket\n");
#endif DEBUG
	if(createdsocket) {
	    soclose(mi->m_sock->ps_sock);
	    mi->m_sock->ps_sock = 0;
	}
	if(havesock)CKIN_SOCK(mi->m_sock);
	return(EINTR);
    }
    
    /* get excusive use of socket because we might sleep */
    if(error = npc_ckout_sock(mi->m_sock)) {
	return(error);
    }
    havesock++;
    
    if(mi->m_sock->ps_sock == NULL) {
	struct socket	*so;
	int		s;

	if(mi->m_addr.s_addr == 0 && npc_nbiow[0]) {
	    struct sys2req	req;
	    
	    req.s2_req = S2NMQUERY;
	    req.s2_len = NB_NAME_LEN;
	    bcopy(mi->m_name,req.s2_data,req.s2_len);
#ifdef NOTDEF
	    mi->m_addr.s_addr = 0xc00f0198;
	    printf("hacking makesocket to stuff NFS4 addr in mi->m_addr\n");
#else NOTDEF
	    if(error = npc_conversnmsock(&req,(char*)&nament)) {
		CKIN_SOCK(mi->m_sock);
		return(error);
	    }
#endif NOTDEF
	    mi->m_addr.s_addr = nament.ne_inaddr.s_addr;
	}
	if(mi->m_addr.s_addr == 0) {
	    CKIN_SOCK(mi->m_sock);
	    return(ENOENT);
	}
	if(error = socreate(AF_INET, &mi->m_sock->ps_sock, SOCK_STREAM, 0)) {
	    CKIN_SOCK(mi->m_sock);
	    return(error);
	}
	createdsocket++;
	so = mi->m_sock->ps_sock;
	so->so_state |= SS_NPC;
	
	if((m = m_get(M_WAIT, MT_SONAME)) == NULL) {
	    soclose(so);
	    mi->m_sock->ps_sock = 0;
	    CKIN_SOCK(mi->m_sock);
	    return(ENOBUFS);
	}
	m->m_len = sizeof(struct sockaddr_in);
	sa = mtod(m, (struct sockaddr_in *));
	sa->sin_family = AF_INET;
	sa->sin_port = NB_OA_PORT /* SMB_TCP_PORT */ ;
	bcopy(&mi->m_addr, &sa->sin_addr, sizeof(mi->m_addr));

	if(error = soconnect(so, m)) {
	    goto bad;
	}

	s = splnet();
	while ((so->so_state & SS_ISCONNECTING) && so->so_error == 0) {
	    if(sleep((caddr_t)&so->so_timeo, (PZERO+1) | PCATCH)) {
		so->so_error = EINTR;
	    }
	}
	error = so->so_error;
	so->so_error = 0;
	splx(s);
bad:
	so->so_state &= ~SS_ISCONNECTING;
	m_freem(m);

	if(error) {
	    npc_printf(error,
		       "error in connect to remote pc: %d.%d.%d.%d, errno:%d\n",
		       sa->sin_addr.s_net,
		       sa->sin_addr.s_host,
		       sa->sin_addr.s_lh,
		       sa->sin_addr.s_impno, error);
	    CKIN_SOCK(mi->m_sock);
clean1:	    mi->m_sock->ps_sock = 0;
	    soclose(so);
	    return(error);
	}

	so->so_options |= SO_KEEPALIVE;

	/* do the session bind, it will wait for a response */
	if(error = npc_sessionbind(mi)) {
	    goto clean1;
	}
	    
	if(error = npc_negprot(mi)) {
	    goto clean1;
	}
    }

    /* session, virtul circuit, or what ever is established */
    return(0);
}


npc_addpid(pid,pmp)
int		pid;
struct pcmountinfo	*pmp;

{
    struct npcpid	    *pidp;

    pidp = pmp->m_sock->ps_pidp;
    while ( pidp != (struct npcpid *)0 ) {
	if ( pidp->pid == pid ) {
#ifdef NOTDEF
	    printf("addpid: pid %d already here\n",pid);
#endif NOTDEF
	    return;
	}
	pidp = pidp->next;
    }
#ifdef DEBUG
    printf("addpid: adding %d to list\n",pid);
#endif DEBUG
    u.u_procp->p_xflag |= PX_NPCUSE;
    pidp = (struct npcpid *)kmem_alloc(sizeof(struct npcpid));
    if ( pidp > 0 ) {
	pidp->pid = pid;
	pidp->next = pmp->m_sock->ps_pidp;
	pmp->m_sock->ps_pidp = pidp;
    }
}


npc_exit(pid)
int		pid;

{
    struct vfs		    *vfsp;
    struct npcpid	    *pidp,**pidpp;
    struct pcmountinfo	    *pmp;
    struct sendbuf	    *sb;
    int			    i;

    for ( vfsp = rootvfs; vfsp; vfsp = vfsp->vfs_next ) {
	if ( vfsp->vfs_fsid.val[1] == MOUNT_NPC ) {
	    pmp = (struct pcmountinfo *)vfsp->vfs_data;
	    if(pmp->m_rootvp->v_count <= 0) continue;
	    pidp = pmp->m_sock->ps_pidp;
	    pidpp = &(pmp->m_sock->ps_pidp);
	    while ( pidp != (struct npcpid *)0 ) {
		if ( pidp->pid == pid ) {
		    *pidpp = pidp->next;
#ifdef DEBUG
		    printf("npc_exit: pid %d exits %s\n",pid,pmp->m_name);
#endif DEBUG
		    i = doSMB1(buildSMBexit,
			       HAVENOBUF,
			       pmp,
			       HAVENOSOCK,
			       &sb,
			       pid);
		    if ( i == 0 ) {
			CKIN_BUF(sb);
			CKIN_SOCK(pmp->m_sock);
		    }
		    kmem_free(pidp,sizeof(struct npcpid));
		    break;
		} else {
		    pidpp = &(pidp->next);
		    pidp = pidp->next;
		}
	    }
	}
    }
}


/*-------------------------------------------------------------+
|  returns a value for SMBpid, for now, just 1.  Later may be- |
|  come more sophisticated, maybe actually returning the actual|
|  u.u_pid (in which case we could trash this altogether).     |
+-------------------------------------------------------------*/

pseudo_pid()
{
    return ( 1 );
}

npc_isalllower(pnp)
register struct pathname    *pnp;
{
    register char   *cp = pnp->pn_path;
    register int    i;
    
    for(i = pnp->pn_pathlen; i > 0; i--, cp++) {
	if(*cp > 'A' && *cp < 'Z') {
	    return(0);
	}
    }
    return(1);
}

npc_checkdosname(cp)
char *	cp;
{
    int dot = 0;
    int count;
    int	pcnt = 0;

    for (count = 0; *cp; cp++, count++) {
	char	c = *cp;
	if (c > 'z' || c < 'a') {
	    if(c > '9' || c < '0') {
		switch(c) {
		case '$': case '&': case '%': case '\047': case '(':
		case ')': case '-': case '@': case '_': case '^':
		case '{': case '}': case '~': case '`': case '!':
		case '#':
		    break;
		case '.':
		    if(dot) return(-1);
		    dot = 1;
		    pcnt = count;
		    count = 0;
		    break;
		default:
		    return(-1);
		}
	    }
	}
	if (dot) {
	    if (count > 3)
	        return(-1);
	}
	else {
	    if (count >= 8)
	        return(-1);
	}
    }
    return(pcnt+count);
}

npc_checknetname(cp)
char *	cp;
{
    int dot = 0;
    int count;
    int	pcnt = 0;

    for (count = 0; *cp; cp++, count++) {
	char	c = *cp;
	if (c > 'z' || c < 'a') {
	    if(c > '9' || c < '0') {
		switch(c) {
		case '$': case '&': case '%': case '\047': case '(':
		case ')': case '-': case '@': case '_': case '^':
		case '{': case '}': case '~': case '`': case '!':
		case '#':
		    break;
		case '.':
		    if(dot) return(-1);
		    dot = 1;
		    pcnt = count;
		    count = 0;
		    break;
		default:
		    return(-1);
		}
	    }
	}
	if (dot) {
	    if (count > NB_SNAME_LEN) {
	        return(-1);
	    }
	} else if (count >= NB_NAME_LEN) {
	    return(-1);
	}
    }
    if(pcnt == 0 || count <= 1) return(-1);
    
    return(pcnt+count);
}
npc_tolower(cp, len)
char	*cp;
int	len;
{
    while(len) {
	if(*cp >= 'A' && *cp <= 'Z') {
	    *cp ^= 0x20;
	}
	len--;
	cp++;
    }
}
npc_toupper(cp, len)
char	*cp;
int	len;
{
    while(len) {
	if(*cp >= 'a' && *cp <= 'z') {
	    *cp ^= 0x20;
	}
	len--;
	cp++;
    }
}

#define STUFF_UIO(us, is, base, size, space)	(is).iov_base = (base);\
					(is).iov_len = (size);\
					(us).uio_iov = &(is);\
					(us).uio_iovcnt = 1;\
					(us).uio_segflg = (space);\
					(us).uio_offset = 0;\
					(us).uio_resid = (size)

static struct timeval	nmserv_tmo = {15, 0};

npc_conversnmsock(req,nament)
struct sys2req	*req;
struct nament   *nament;
{
    struct socket	*sp;
    struct mbuf		*m;
    struct sockaddr_un	*sa;
    int			havembuf;
    struct uio		us;
    struct iovec	is;
    int			error;
    int			i, j;
    
    /* estabish socket to NMServ */

    if(error = socreate(AF_UNIX, &sp, SOCK_STREAM, 0)) {
	npc_printf(error, "could not create socket for nmserv:%d\n",
		   error);
	return(error);
    }
    
    if((m = m_get(M_WAIT, MT_SONAME)) == NULL) {    /* may sleep(P0-1) */
	npc_printf(0, "no mbufs for nameserver\n");
	soclose(sp);
	return(EIO);
    }
    m->m_len = sizeof(struct sockaddr_un);
    sa = mtod(m, (struct sockaddr_un *));
    sa->sun_family = AF_UNIX;
    bcopy(npc_nbiow, sa->sun_path, i = strlen(npc_nbiow));
    bcopy(NMS_S2UNIX_SOCK,&(sa->sun_path[i]),sizeof(NMS_S2UNIX_SOCK));
    
    /* we need exclusive use of NMServ */
    while(nmservinuse) {
#ifdef DEBUG
	printf("waiting for nmserver use\n");
#endif
	if(sleep((caddr_t)&nmservinuse, (PZERO+1) | PCATCH)) {
	    m_freem(m);
	    soclose(sp);
	    return(EINTR);
	}
    }
    nmservinuse++;

    havembuf = 1;
    if(setjmp(&u.u_qsave)) {
#ifdef DEBUG
	printf("longjmp, nmserv_convers\n");
#endif DEBUG
	if(havembuf){
	    m_freem(m);
	}
	error = EINTR;
	goto clean1;
    }
    
    error = soconnect(sp, m);
    m_freem(m);
    havembuf = 0;
    if(error) {
	goto clean1;
    }
    
    /* AF_UNIX sockets come back connected after connect */
    
    STUFF_UIO(us, is, (char*)req, sizeof(int)*2 + req->s2_len, UIO_SYSSPACE);
    
    /* send the name to the name server */
    if(error = sosend(sp, (struct mbuf *)0, &us, 0, (struct mbuf *)0)) {
	npc_printf(error,
		   "error from sosend to name server, errno:%d\n", error);
	goto clean1;
    }

    STUFF_UIO(us, is, &i, sizeof(int), UIO_SYSSPACE);
    for(j = 0;; j++) {
	if(npc_socksel(sp, FREAD, &nmserv_tmo, &error) == 0) {
	    npc_printf(u.u_error,
		       "KERNEL cannot talk to name server, err:%d\n",
		       u.u_error);
	    if(u.u_error) {
		error = u.u_error;
	    } else {
		error = EIO;
	    }
	    goto clean1;
	}
	error = soreceive(sp, (struct mbuf *)0, &us, 0, (struct mbuf **)0);
	if(error) {
	    npc_printf(error,
		       "KERNEL cannot talk to name server, read fail:%d\n",
		       error);
	    goto clean1;
	}
	if(i == 0) {
#ifdef DEBUG
	    printf("name server had no entries to report\n");
#endif
	    nament->ne_inaddr.s_addr = 0;
	    error = 0;
	    goto clean1;
	}
	if(j == 1) break;
	STUFF_UIO(us, is, nament, sizeof(struct nament), UIO_SYSSPACE);
    }

    error = 0;
clean1:
    soclose(sp);
    nmservinuse = 0;
    wakeup((caddr_t)&nmservinuse);
    return(error);
}

npc_printf(err, fmt, x1, x2, x3, x4, x5, x6)
int	    err;
char	    *fmt;
unsigned    x1;
{
#ifndef DEBUG
    if(err != EINTR) {
#endif
	printf(fmt, x1, x2, x3, x4, x5, x6);
#ifndef DEBUG
    }
#endif
}
#ifdef DEBUG
hex(adr, len)
char * 		adr;
int		 len;
{    
    int a_start,
        index = 0,
        bcount;
	
    int places = 16;
    register int i,
	     count = 0;
    	   
    unsigned char    byte,
            asc[17];
		     
       
    printf("%000006x   ", index);

    while(len) {
	bcount = len;
	len -= bcount;
	for (i = 0; i < bcount; i++) {
	    byte = adr[i];
            printf("%02x ", byte);
		
	    if ((byte > 0x1f) && (byte < 0x7f))
		asc[count] = byte;
	    else
		asc[count] = '.';
	    if (count++ > places - 2) {
		asc[places] = 0;
		printf("%s", asc);
		printf("\n%000006x   ", index+=places);
		count = 0;
	    }
	}
        adr += bcount;
    }
	a_start = places*3 - count*3;
    
        for (i = 0; i < a_start; i++)
	    printf("%c",' ');
        for (i = 0; i < count; i++)
	    printf("%c",asc[i]);
        printf("\n");
}
#endif DEBUG
