/*
 *	$Header: npc_reclock.c,v 1.7 88/06/20 13:59:50 reh Exp $
 */


#include "param.h"
#include "vfs.h"
#include "../netinet/in.h"	/* needed for mount.h */
#include "socketvar.h"
#undef NFS
#include "mount.h"
#include "errno.h"
#include "file.h"
#include "user.h"
#include "proc.h"
#include "stat.h"
#include "vnode.h"
#include "nbios.h"
#include "npcfs.h"
#include "smb.h"
#include "sendbuf.h"
#include "dir.h"
/*----------------------------------------------------------------------+
|  These routine support changes to ../npc/npc_vnodeops.c (npc_lockctl) |
|  that will maintain record of those record locks initiated from this  |
|  machine.  Main reason for this: The highest level of close() calls a |
|  routine that attempts to unlock all locks held by a process, but it  |
|  does that by using offset 0 len 0, and SMB can't deal with that.  So |
|  we  record every lock along with requesting pid, and when 0-0 comes  |
|  along for a pid, we run down the list and issue SMBunlock explicitly.|
|  Also, we can pre-screen locks against existing ones, thus saving SMB |
|  traffic when there is a collision.  These records may also be nec-   |
|  essary for interrupt recovery.                                       |
+--------------------------------------------------------------------- */
     
/*----------------------------------------------------------+
|  unlock all locks owned by the current pid.  For now, ig- |
|  nore the SMB results and strike the locklist record no   |
|  matter what.                                             |
+--------------------------------------------------------- */

int
unlock_all(vp)
struct vnode	*vp;

{
    struct pc_lock	    *lp, **lppre, *killp;
    int			    havesock = 0, havebuf = 0;
    struct sendbuf	    *sb;
    struct pcnode	    *pcp = vtopc(vp);
    struct pcmountinfo	    *pmp = vftomi(vp->v_vfsp);
    int			    error;
#ifdef DEBUG
    unsigned char	    rcls;
    unsigned short          err;
#endif DEBUG

    lp = pcp->pc_locklist;
    lppre = &(pcp->pc_locklist);

    while ( lp != (struct pc_lock *)0 ) {

	if ( lp->l_pid == u.u_procp->p_pid ) {

	    if(error = doSMB(buildSMBunlock,havesock,pmp,havebuf,&sb,
		  pcp->pc_smbfid,lp->l_len,lp->l_start, lp->l_pid )) {
		/* any locks that are left must be cleaned up later */
		/* A signal cannot stop this code during exit, during
		 * exit, all signals are blocked */
		return(error);
	    }
	    havesock = havebuf = 1;
#ifdef DEBUG
	    extractSMBunlock(sb->buf,&rcls,&err);
	    printf("unlock_all: SMBunlock rcls %d err %d on start %d len %d\n",
			rcls,err,lp->l_start,lp->l_len);
#endif DEBUG

	    *lppre = lp->l_next;
	    killp = lp;
	    kmem_free(killp,sizeof (struct pc_lock) );
	    lp = *lppre;

	} else {

	    lppre = &(lp->l_next);
	    lp = lp->l_next;
	}
    }

    if ( havesock ) {
	CKIN_VSOCK(vp);
    }
    if ( havebuf ) {
	CKIN_BUF(sb);
    }
    return 0;
}


/*--------------------------------------------------------+
|  Check the locklist to see if this pid owns a lock with |
|  the supplied byte range.  If not, error.  Otherwise,   |
|  do SMBunlock and strike it from the list.  For now, if |
|  the SMB itself fails, don't strike it from the list    |
+------------------------------------------------------- */

int
find_and_unlock(vp,ld)
struct vnode *vp;
struct flock *ld;

{
    struct pc_lock	    *lp, **lppre;
    struct sendbuf	    *sb;
    struct pcnode	    *pcp = vtopc(vp);
    struct pcmountinfo	    *pmp = vftomi(vp->v_vfsp);
    int			    error;
    unsigned char	    rcls;
    unsigned short	    err;

    lp = pcp->pc_locklist;
    lppre = &(pcp->pc_locklist);

    while ( lp != (struct pc_lock *)0 ) {

	if ( ( lp->l_pid == u.u_procp->p_pid ) &&
	     ( lp->l_start == ld->l_start ) &&
	     ( lp->l_len == ld->l_len ) ) {

	    if(error = doSMB(buildSMBunlock,HAVENOSOCK,pmp,HAVENOBUF,&sb,
			  pcp->pc_smbfid, lp->l_len,lp->l_start,lp->l_pid)) {
		return(error);
	    }
	    CKIN_VSOCK(vp);
	    extractSMBunlock(sb->buf,&rcls,&err);
#ifdef DEBUG
printf("find_and_unlock: SMBunlock rcls %d err %d on start %d len %d\n",
			rcls,err,lp->l_start,lp->l_len);
#endif DEBUG
	    CKIN_BUF(sb);
	    if ( rcls != SUCCESS ) {
		return EACCES;
	    }

	    *lppre = lp->l_next;
	    kmem_free(lp, sizeof(struct pc_lock) );
	    return 0;
	} else {

	    lppre = &(lp->l_next);
	    lp = lp->l_next;
	}
    }
    return EACCES;
}


/*---------------------------------------------------------+
|  someday.... check the supplied lock range against all   |
|  in the locklist for any overlap.  If overlap, return    |
|  error. Otherwise, return 0.                             |
+-------------------------------------------------------- */

int
lock_collision(vp,ld)
struct vnode	*vp;
struct flock	*ld;

{
    /*
    lp = pcp->pc_locklist;
    lppre = &(pcp->pc_locklist);
    while ( lp != (struct pc_lock *)0 ) {
	if collision -- ld->start inside of lp's range, or ld->len inside
	                id lp's range, or lp falls within ld's range --
            return EACCES;
	} else {
	    lppre = &(lp->l_next);
	    lp = lp->l_next;
	}
    }
    */	
    return 0;
}


/*--------------------------------------------------------+
|  create a new pc_lock and insert at the beginning of the|
|  locklist.  At some later date if necessary, follow some|
|  superior ordering scheme, and alter above routines to  |
|  do the same for performance sake.  Possible scheme:    |
|  ordered by pid, and within that, ordered by lock offset|
+------------------------------------------------------- */

add_lock(vp,ld)
struct vnode	*vp;
struct flock	*ld;

{
    struct pc_lock	*lp;
    struct pcnode	*pcp = vtopc(vp);

    lp = (struct pc_lock *) kmem_alloc( sizeof(struct pc_lock) );

    lp->l_start = ld->l_start;
    lp->l_len = ld->l_len;
    lp->l_pid = u.u_procp->p_pid;

    lp->l_next = pcp->pc_locklist;
    pcp->pc_locklist = lp;
}


/*--------------------------------------------------------------+
|  We need this routine whenever a "replacement open" sequence  |
|  occurs (npc_open and npc_close).  In between the new open    |
|  and the close of the old open, we call this.  If the file    |
|  has any record locks in effect, the old ones are disposed of |
|  and are replaced by identical locks on the new fid.  There   |
|  are some problems with this strategy, mainly that the new    |
|  lock might fail, and the owning process will have no idea    |
+--------------------------------------------------------------*/

redo_locks(vp,oldfid,newfid,havesock)
struct vnode		*vp;
int			oldfid;
int			newfid;
int			havesock;

{
    struct pc_lock	    *lp,**lppre;
    struct pcnode	    *pcp = vtopc(vp);
    struct pcmountinfo	    *pmp = vftomi(vp->v_vfsp);
    struct sendbuf	    *sb;
    int			    havebuf,error=0;
    unsigned char	    rcls;
    unsigned short	    err;

    lp = pcp->pc_locklist;
    lppre = &(pcp->pc_locklist);
    havebuf = HAVENOBUF;
    while ( lp != (struct pc_lock *)0 ) {
#ifdef DEBUG
	printf("redo_locks: about to unlock %d-%d for %d\n",
			lp->l_start,lp->l_len,lp->l_pid);
#endif DEBUG
	error = doSMB1(buildSMBunlock,havesock,pmp,havebuf,&sb,
		       lp->l_pid,oldfid,lp->l_len,lp->l_start,lp->l_pid);
	/*-----------------------------------------------------------+
	|  not sure what to do if error on unlock.  If doSMB fails,  |
	|  the sock and the buf will be free.  There is a small win- |
	|  dow of vulnerability between the unlock and the lock if   |
	|  some other machine or the home machine decides to lock    |
	|  the file.  Is this acceptable?			     |
	+---------------------------------------------------------- */
	if (error) {
	    printf("redo_locks: error in doSMBunlock %d\n",error);
	    havesock = havebuf = 0;
	}else{
	    havesock = havebuf = 1;
	}
#ifdef DEBUG
	printf("redo_locks: about to lock %d-%d for %d\n",
			lp->l_start,lp->l_len,lp->l_pid);
#endif DEBUG
	error = doSMB1(buildSMBlock,havesock,pmp,havebuf,&sb,
		       lp->l_pid,newfid,lp->l_len,lp->l_start,lp->l_pid);
	if ( error ) {
	    havesock = havebuf = 0;
	}else{
	    havesock = havebuf = 1;
	}
	/*--------------------------------------------------------+
	|  probably, if the lock fails, the record should be	  |
	|  removed from the list.				  |
	+------------------------------------------------------- */
	lppre =  &(lp->l_next);
	lp = lp->l_next;
    }
    if ( havebuf ) {
	CKIN_BUF(sb);
    }
    return error;
}
