/*
 *  $Header: npc_net.c,v 1.45 88/07/11 14:26:01 hutch Exp $
 */
#include "param.h"
#include "errno.h"
#include "user.h"	    /* has implied time.h for vnode.h */
#include "proc.h"
#include "vfs.h"
#include "../netinet/in.h"  /* needed for mount.h */
#undef NFS
#include "mount.h"	    /* needed for npcfs.h */
#include "kernel.h"
#include "vnode.h"	    /* needed for npcfs.h */
#include "socketvar.h" /* needed for npcfs.h */
#include "nbios.h"	    /* needed for npcfs.h */
#include "npcfs.h"
#include "sendbuf.h"
#include "smb.h"
#include "file.h"
#include "systm.h"

/*
 *	the socket should have already been checked out
 */
npc_sessionbind(mi)
struct pcmountinfo  *mi;
{
    struct uio		us;
    struct iovec	is;
    int			j,i;
    int			error;
    unsigned char	*cp;
    int			len;
    char		xname[NB_NAME_LEN+1];
    struct x {
	struct nb_hdr	nbh;
	char		called[NB_SESSION_NMLEN];
	char		caller[NB_SESSION_NMLEN];
    }spack;

    if(setjmp(&u.u_qsave)) {
#ifdef DEBUG
	printf("longjmp: session bind\n");
#endif DEBUG
	CKIN_SOCK(mi->m_sock);
	return (EINTR);
    
    }

    spack.nbh.length = NB_SESSION_NMLEN * 2;
    spack.nbh.type = NB_SESSION_REQ;
    spack.nbh.flags = 0;
    /*---------------------------------------+
    |  The called name                       |
    +-------------------------------------- */
    cp = xname;
    len = strlen(mi->m_name);
    bcopy(mi->m_name, cp, len);
    /* convert to upper case (and increment cp) */
    for(i = len; i > 0; i--, cp++) {
	char	c = *cp;
	if(c >= 'a' && c <= 'z') {
	    *cp ^= 0x20;
	}
    }
    /* pad all the way with spaces */
    for(i = len; i < NB_NAME_LEN; i++){
	*cp++ = ' ';
    }
    spack.called[0] = 0x20;
    i = 1;
    j = 0;
    while ( j < NB_NAME_LEN) {
	spack.called[i++] = (xname[j] >> 4) + 'A';
	spack.called[i++] = (xname[j++] & 0xf) + 'A';
    }
    spack.called[i] = 0x00;

    /*-----------------------------------+
    |  The calling name		         |
    +---------------------------------- */
    cp = xname;
    len = MIN(hostnamelen, NB_NAME_LEN);
    bcopy(hostname, cp, len);

    xname[len] = 0;
    for(i = len; i > 0; i--, cp++) {
	char	c = *cp;
	if(c >= 'a' && c <= 'z') {
	    *cp ^= 0x20;
	}
    }

    for(i = len; i < NB_NAME_LEN; i++){
	*cp++ = ' ';
    }
    xname[NB_NAME_LEN] = 0;
    spack.caller[0] = 0x20;
    i = 1;
    j = 0;
    while( j < NB_NAME_LEN ) {
	spack.caller[i++] = (xname[j] >> 4) + 'A';
	spack.caller[i++] = (xname[j++] & 0xf) + 'A';
    }
    spack.caller[i] = 0x00;


#ifdef NOTDEF
    hex((char*)&spack,sizeof(struct x));
#endif 
    /*---------------------------------------------+
    |  We have to use sosend directly.  Stuff the  |
    |  uio/iovec right here.  Must also use soreceive
    +-------------------------------------------- */
    is.iov_base = (char *)&spack;
    is.iov_len = sizeof (struct x);

    us.uio_iov = &is;
    us.uio_iovcnt = 1;
    us.uio_offset = 0;
    us.uio_fmode = 0;
    us.uio_segflg = UIOSEG_KERNEL;
    us.uio_resid = sizeof (struct x);


    if(error = sosend(mi->m_sock->ps_sock,
		      (struct mbuf *)0,
		      &us,
		      0,
		      (struct mbuf *)0)  ) {
	npc_printf(error, "npc_sessionbind: failed sosend, errno:%d\n", error);
	CKIN_SOCK(mi->m_sock);
	return(error);
    }

    is.iov_base = (char *)&spack;
    is.iov_len = sizeof (struct x);

    us.uio_iov = &is;
    us.uio_iovcnt = 1;
    us.uio_offset = 0;
    us.uio_fmode = 0;
    us.uio_segflg = UIOSEG_KERNEL;
    us.uio_resid = NB_HDR_SIZ +1;   /*  add on 1 for error_code */
    
    
    if(error = soreceive(mi->m_sock->ps_sock,
			 (struct mbuf **)0,
			 &us,
			 0,
			 (struct mbuf **)0 ) ) {
	npc_printf(error, "failed sorecv in session bind, errno:%d\n", error);
	CKIN_SOCK(mi->m_sock);
	return(error);
    }
    
    if ( spack.nbh.type != NB_SESSION_OK ) {
	npc_printf(0,"session bind failed, type:%x code:%x\n",
		   spack.nbh.type, spack.called[0]);
	CKIN_SOCK(mi->m_sock);
	return(EHOSTDOWN);
    }
    return(0);
}




char	*protostr = FILESHARE;	/* PC NETWORK PROGRAM 1.0 */
/*
 *	the socket should have already been checked out
 */
int
npc_negprot(mi)
struct pcmountinfo  *mi;
{
    struct sendbuf	*sb;
    int			i;
    int			error;
    short		err;
    unsigned char	rcls;
    unsigned short	index;
    int			havebuf = 0;

    if(setjmp(&u.u_qsave)) {
#ifdef DEBUG
	printf("longjmp, negprot\n");
#endif DEBUG
	CKIN_SOCK(mi->m_sock);
	if(havebuf){
	    CKIN_BUF(sb);
	}
	return (EINTR);
    }

    /* get a buffer to use */
    if(error =ckout_buf(&sb)) {
	CKIN_SOCK(mi->m_sock);
	return(error);
    }
    havebuf++;

    i = buildSMBnegprot(sb->buf, &protostr);
    if(error = nb_send(mi->m_sock, sb->buf, i)) {
#ifdef DEBUG
	printf("failed nb_send, errno:%d\n", error);
#endif
	CKIN_SOCK(mi->m_sock);
	CKIN_BUF(sb);
	return(error);
    }
    if(error = nb_recv(mi->m_sock, sb)) {
	CKIN_SOCK(mi->m_sock);
	CKIN_BUF(sb);
	return(error);
    }
    
    extractSMBnegprot(sb->buf, &rcls, &err, &index);
    CKIN_BUF(sb);
    if(rcls != SUCCESS  ||  index != 0  ) {
	npc_printf(0, "error in SMBnegprot, errclass:%x errcode:%x index:%x\n",
	       rcls, err, index);
	CKIN_SOCK(mi->m_sock);
	return(ECONNREFUSED); 
    }
    return(0);
}


char *
put_word(cp, data)
char	*cp;
int	data;
{
    *cp++ = (data>>8) & 0x0ff;
    *cp++ = data & 0x0ff;
    return(cp);
}
char *
get_word(cp, data)
char	*cp;
int	*data;
{
    int	temp;
    temp = *cp++ & 0x0ff;
    temp |= (*cp++ << 8) & 0x0ff00;
    *data = temp;
    return(cp);
}
/*
 *	the socket should have already been checked out
 */
int
npc_treeconnect(mi)
struct pcmountinfo  *mi;
{
    struct sendbuf	*sb;
    int			i;
    int			error;
    unsigned short	err;
    unsigned char	rcls;
    char		fullname[27];
    int			havebuf = 0;
    int			passwd[NB_PASSWD_LEN+1];

    if(setjmp(&u.u_qsave)) {
#ifdef DEBUG
	printf("longjmp, treeconnect\n");
#endif DEBUG
	CKIN_SOCK(mi->m_sock);
	if(havebuf){
	    CKIN_BUF(sb);
	}
	return (EINTR);
    }

    /* get a buffer to use */
    if(error = ckout_buf(&sb)) {
	CKIN_SOCK(mi->m_sock);
	return(error);
    }
    havebuf++;
    
    fullname[0] = fullname[1] = 0x5c;
    bcopy(mi->m_name,&fullname[2],NB_NAME_LEN);
    strcat(fullname,"\\");
    strcat(fullname,mi->m_sname);
    npc_toupper(fullname, strlen(fullname));
#ifdef NOTDEF
printf("npc_treeconnect: fullname ==%s==\n",fullname);
#endif NOTDEF
    strcpy(passwd, mi->m_passwd);
    npc_toupper(passwd, strlen(passwd));
    i = buildSMBtcon(sb->buf, fullname, passwd, "A:");
    if(error = nb_send(mi->m_sock, sb->buf, i)) {
	npc_printf(error, "npc_treeconnect: failed nb_send, errno:%d\n", error);
	CKIN_SOCK(mi->m_sock);
	CKIN_BUF(sb);
	return(error);
    }
    if(error = nb_recv(mi->m_sock, sb)) {
	CKIN_SOCK(mi->m_sock);
	CKIN_BUF(sb);
	return(error);
    }

    extractSMBtcon(sb->buf, &rcls, &err, &(mi->m_tid), &(mi->m_maxpkt) );
#ifdef NOTDEF
    printf("treeconnect: maxpacket: %d\n",(unsigned short)(mi->m_maxpkt));
#endif NOTDEF
    CKIN_BUF(sb);
    if(rcls != SUCCESS) {
#ifdef DEBIG
	printf("error in SMBtcon, errclass:%x errcode:%x tid:%x mpkt:%x\n",
	       rcls, err, mi->m_tid, mi->m_maxpkt);
#endif
	CKIN_SOCK(mi->m_sock);
	return(ECONNREFUSED); 
    }
    return(0);
}
int
npc_treedisconnect(mi)
struct pcmountinfo  *mi;
{
    struct sendbuf	*sb;
    int			error;
    short		err;
    unsigned char	rcls;

    if(mi->m_flags & NPCMNT_BADFS) {
	CKIN_SOCK(mi->m_sock);
	return(EIO);
    }
    if(error = doSMB(buildSMBtdis, HAVESOCK, mi, HAVENOBUF, &sb)) {
	/* the socket has now been freed */
#ifdef DEBUG
	printf("npc_treedisconnect: failed doSMB, errno:%d\n", error);
#endif
	return(error);
    }

    extractSMBtdis(sb->buf, &rcls, &err);
    CKIN_BUF(sb);
    if(rcls != SUCCESS) {
	npc_printf(0, "error in SMBtdis, errclass:%x errcode:%x\n", rcls, err);
	CKIN_SOCK(mi->m_sock);
	return(EIO); 
    }
    return(0);
}

int
nb_send(psock,buf,count)
struct pcsock 	*psock;
char		*buf;
unsigned short	count;

{
    struct uio	    auio;
    struct iovec    iv[2];
    struct nb_hdr   nbh;
    
    nbh.type = NB_SESSION_MSG;
    nbh.length = count;
    nbh.flags = 0;

    iv[0].iov_base = (char *)&nbh;
    iv[1].iov_base = buf;
    iv[0].iov_len = NB_HDR_SIZ;
    iv[1].iov_len = SENDBUFSIZ;

    auio.uio_iov = iv;
    auio.uio_iovcnt = 2;
    auio.uio_offset = 0;
    auio.uio_fmode = 0;
    auio.uio_segflg = UIOSEG_KERNEL;
    auio.uio_resid = count + NB_HDR_SIZ;

    psock->ps_smbcmd = buf[SMB_COM];
    psock->ps_smbtid = GET_SMBWORD(buf+SMB_TID);
    psock->ps_smbpid = GET_SMBWORD(buf+SMB_PID);
    if ( buf[SMB_COM] == SMBlock ) {
	psock->ps_smbfid = GET_SMBWORD(buf+SMB_VWV);
	psock->ps_lockcnt = GET_SMBDOUBLE(buf+SMB_VWV+2);
	psock->ps_lockoff = GET_SMBDOUBLE(buf+SMB_VWV+6);
    }

    return sosend(psock->ps_sock,(struct mbuf *)0,&auio,0,(struct mbuf *)0 );
}


static struct timeval  nb_tmo = {90, 0};

int
nb_recv(psock,sb)
struct pcsock		*psock;
struct sendbuf		*sb;
{
    struct uio	    auio;
    struct iovec    aiov;
    struct nb_hdr   *nbhp=(struct nb_hdr *)sb->buf;
    int		    resid,count;
    int		    need_rcls=0,need_fid=0;
    int		    err;

    psock->ps_state = PS_RECV;
    psock->ps_needed = 0;
    psock->ps_received = 0;
    
try_again:
    aiov.iov_base = sb->buf;
    aiov.iov_len = SENDBUFSIZ;
    auio.uio_iov = &aiov;
    auio.uio_iovcnt = 1;
    auio.uio_fmode = auio.uio_offset = 0;
    auio.uio_segflg = UIOSEG_KERNEL;
    auio.uio_resid = NB_HDR_SIZ;
    
    while ( auio.uio_resid ) {
    	count = npc_socksel(psock->ps_sock, FREAD, &nb_tmo, &err);
    	if( !count && ! err ) {
	    npc_printf(u.u_error,
		       "nb_recv: unsatisfactory socksel1, u.u_error:%d\n",
		       u.u_error);
	    if(u.u_error) {
		err = u.u_error;
	    } else {
		err = ETIMEDOUT;
	    }
	    return err;
    	}
	resid = auio.uio_resid;
    	err = soreceive(psock->ps_sock,
		    	(struct mbuf **)0,
		    	&auio,
		    	0,
		    	(struct mbuf **)0  );
    	if ( err ) {
	    npc_printf(err, "nb_recv: error from soreceive (header) %d\n",
		       err);
            return(err);
    	} else if ( resid == auio.uio_resid ) {
#ifdef DEBUG
	    printf("nb_recv: sorecieve (hdr) no resid change\n");
#endif DEBUG
	    return ETIMEDOUT;
	}

	
    }

    if ( nbhp->type == NB_KEEPALIVE ) {  /* not expected, but you never know */
	goto try_again;
    }

    aiov.iov_base = sb->buf;    /* write over the nbh if data coming */
    aiov.iov_len = SENDBUFSIZ;  /* ditto */
    psock->ps_needed = auio.uio_resid = nbhp->length;

    switch(psock->ps_smbcmd) {
        case SMBlock:
	    need_fid = 0;
	    need_rcls = 1;
	    break;
	case SMBmknew:
	case SMBcreate:
	case SMBopen:
	    need_fid = need_rcls = 1;
    }
    
    while ( auio.uio_resid ) {
	
	count = npc_socksel(psock->ps_sock, FREAD, &nb_tmo, &err);
	if ( !count && !err ) {
	    npc_printf(u.u_error,
		       "nb_recv: unsatisfactory socksel, u.u_error:%d\n",
		       u.u_error);
	    if(u.u_error) {
		err = u.u_error;
	    } else {
		err = ETIMEDOUT;
	    }
	    return err;
	}
	resid = auio.uio_resid;
        err = soreceive(psock->ps_sock,
			(struct mbuf **)0,
			&auio,
			0,
			(struct mbuf **)0 );
	if ( err ) {
	    npc_printf(err, "nb_recv: error from soreceive (loop) %d\n",err);
	    return err;
	} else if ( resid == auio.uio_resid ) {
#ifdef DEBUG
	    printf("nb_recv: soreceive (data) no change in resid\n");
#endif DEBUG
	    return ETIMEDOUT;
	}
	    

	psock->ps_received = psock->ps_needed - auio.uio_resid;

	if ( need_rcls ) {
	    if ( psock->ps_received > SMB_RCLS ) {
		psock->ps_smbrcls = sb->buf[SMB_RCLS];
		need_rcls = 0;
	    }
	}
	if ( need_fid ) {
	    if ( psock->ps_received > SMB_VWV ) {
		psock->ps_smbfid = GET_SMBWORD(sb->buf+SMB_VWV);
		need_fid = 0;
	    }
	}
    }

    psock->ps_state = PS_CLEAR;
    return 0;
}


    
/*
 *	This is real dangerous code.
 *	If any sees a better way let me know,
 *	I need to implement a timeout on a socket read operation from
 *	within the kernel.
 *	This is a pseudo _select routine, is mimics the select in
 *	sys_generic.c, but works on sockets only, not file descriptors.
 *	****** !!!!!! WATCH OUT !!!!!! **************
 */
extern int unselect();
extern int  nselcoll;
/*
 *	returns 1 if the socket is ready for the operation(which),
 *	0 if timeout.
 */
npc_socksel(so, which, atv, err)
struct socket	*so;
int		which;
struct timeval	*atv;
int		*err;			    /* if non zero then error on so */
{
    int		    cnt = 0;
    int		    ncoll;
    int		    s;
    struct timeval  tm;
    label_t	    lqsave;

    u.u_error = 0;
    *err = 0;
#ifdef notdef
    return(1);
#endif

    if(atv) {
	bcopy(atv, &tm, sizeof(struct timeval));
#ifdef notdef
	itimerfix(&tm);
#endif
	s = splhigh(); timevaladd(&tm, &time); splx(s);
    }
    if(u.u_error) {
	goto done;
    }
    
retry:
    /* DANGER */
    ncoll = nselcoll;			    /* not sure what this is for */
    u.u_procp->p_flag |= SSEL;
    
    cnt = sosoo_select(so, FREAD);	    /* look for readable */
    *err = sosoo_select(so, 0);		    /* look for errors */

    if(u.u_error || cnt || *err) {
	goto done;
    }

    s = splhigh();

    /* would use timercmp, but it does not handle >= right */
    if(atv && (time.tv_sec > tm.tv_sec ||
	      time.tv_sec == tm.tv_sec && time.tv_usec >= tm.tv_usec)) {
	splx(s);
	npc_printf(0, "sel: timeout cnt:%d err:%d\n", cnt, *err);
	goto done;
    }
    
    /* DANGER */
    if((u.u_procp->p_flag & SSEL) == 0 || nselcoll != ncoll) {
	u.u_procp->p_flag &= ~SSEL;
	splx(s);
	goto retry;
    }
    u.u_procp->p_flag &= ~SSEL;

    lqsave = u.u_qsave;
    if(setjmp(&u.u_qsave)) {
#ifdef DEBUG
	printf("longjmp, npc_select\n");
#endif DEBUG
	if (atv) untimeout(unselect, (caddr_t)u.u_procp);
	u.u_error = EINTR;
	splx(s);
	return(cnt);
    }
    if(atv) {
	timeout(unselect, (caddr_t)u.u_procp, hzto(&tm));
    }
    
    sleep((caddr_t)&selwait, PZERO+1);
    
    if(atv) {
	untimeout(unselect, (caddr_t)u.u_procp);
    }
    u.u_qsave = lqsave;
    splx(s);
    goto retry;

done:
    return(cnt);
}



checkin_sock(mso)
struct pcsock	*mso;
{
    mso->ps_busy = 0;
    wakeup((caddr_t)mso);
}


npc_ckout_sock(psock)
struct pcsock	*psock;
{
    int			count,err=0;
    struct uio		auio;
    struct iovec	aiov;
    struct sendbuf	*sb;
    struct nb_hdr	*nbhp;
    int			resid,correction;
    int			havebuf = 0,need_rcls=0,need_fid=0;
    label_t		lqsave;

    CKHEALTH(psock->ps_minfo);

#ifdef DEBUG
    if(psock->ps_busy) {
	printf("had to sleep for socket\n");
    }
#endif DEBUG
    while (psock->ps_busy) {
	if(sleep((caddr_t)psock, (PZERO+1) | PCATCH)) {
	    return(EINTR);
	}
    }
    psock->ps_busy++;
    psock->ps_minfo->m_time = time.tv_sec;

    /*------------------------------------------------------+
    |  engage in cleanup behavior if ps_state requires.     |
    |  first go th a sequence nearly identical to nb_recv.  |
    |  Then the particular SMB being cleaned up may require |
    |  an SMB to undo it                                    |
    +----------------------------------------------------- */

    lqsave = u.u_qsave;
    if ( setjmp(&u.u_qsave) ) {
#ifdef DEBUG
	printf("npc_ckout_sock: setjmp\n");
#endif
	psock->ps_busy = 0;
	wakeup((caddr_t)psock);
	if ( havebuf ) {
	    CKIN_BUF(sb);
	}
	u.u_qsave = lqsave;
	return EINTR;
    }

    if ( psock->ps_state == PS_RECV ) {
#ifdef DEBUG
	printf("ckout_sock: stat is PS_RECV\n");
#endif DEBUG

	if ( err = ckout_buf(&sb) ) {
	    goto out;
	} else {
	    havebuf++;
	}

	nbhp = (struct nb_hdr *)sb->buf;
try_again:
	aiov.iov_base = sb->buf;
	aiov.iov_len = SENDBUFSIZ;
	auio.uio_iov = &aiov;
	auio.uio_iovcnt = 1;
	auio.uio_fmode = auio.uio_offset = 0;
	auio.uio_segflg = UIOSEG_KERNEL;

	if ( psock->ps_needed == 0 ) {
#ifdef NOTDEF
	    printf("ckout_sock: ps_needed is 0, so look for hdr\n");
#endif 
	    auio.uio_resid = NB_HDR_SIZ;

	    while ( auio.uio_resid ) {
	        count = npc_socksel(psock->ps_sock,FREAD,&nb_tmo,&err);
#ifdef NOTDEF
		printf("ckout_sock: socksel (hdr) cnt %d err %d\n",count,err);
#endif
	        if ( !count && !err ) {
		    if(u.u_error) {
			err = u.u_error;
		    } else {
			err = ETIMEDOUT;
		    }
		    goto out;
	        }
		/* will regard soreceive return of 0 but no change in
			uio_resid as reason to abort loop */
		resid = auio.uio_resid;
	        err = soreceive(psock->ps_sock,
			        (struct mbuf **) 0,
			        &auio,
			        0,
			        (struct mbuf **) 0 );
#ifdef NOTDEF
		printf("ckout_sock: soreceive (hdr) returns %d\n",err);
#endif 
	        if ( err ) {
		    goto out;
	        }
		if ( resid == auio.uio_resid ) {
#ifdef DEBUG	    
		    printf("ckout_sock: sorecv (hdr) returns 0, but no data\n");
#endif DEBUG
		    err = ETIMEDOUT;
		    goto out;
		}
	    }

	    if ( nbhp->type == NB_KEEPALIVE ) {
#ifdef DEBUG
		printf("ckout_sock: nbh type is keepalive\n");
#endif DEBUG
		goto try_again;
	    }

	    psock->ps_needed = nbhp->length;
#ifdef NOTDEF
	    printf("ckout_sock: hdr says len is %d\n",psock->ps_needed);
#endif DEBUG
            psock->ps_received = 0;
	    aiov.iov_base = sb->buf;
	    aiov.iov_len = SENDBUFSIZ;
	}

	auio.uio_resid = psock->ps_needed - psock->ps_received;
	correction = psock->ps_received;

	switch ( psock->ps_smbcmd ) {
	    case SMBlock:
		need_fid = 0;
		need_rcls = 1;
		break;
	    case SMBmknew:
	    case SMBcreate:
	    case SMBopen:
		need_fid = 1;
		need_rcls = 1;
	}

	while ( auio.uio_resid ) {
	    count = npc_socksel(psock->ps_sock,FREAD,&nb_tmo,&err);
#ifdef NOTDEF
	    printf("ckout sock: socksel (data) cnt %d err %d\n",count,err);
#endif 
	    if ( !count && !err ) {
		if(u.u_error) {
		    err = u.u_error;
		} else {
		    err = ETIMEDOUT;
		}
		goto out;
	    }

	    resid = auio.uio_resid;
	    err = soreceive ( psock->ps_sock,
			      (struct mbuf **) 0,
			      &auio,
			      0,
			      (struct mbuf **) 0 );
#ifdef NOTDEF
	    printf("ckout sock: sorecv (data) returns %d\n",err);
#endif 
	    if ( err ) {
		goto out;
	    }
	    if ( resid == auio.uio_resid ) {
		err = ETIMEDOUT;
#ifdef DEBUG
		printf("ckout_sock: soreceive (data) no resid change\n");
#endif DEBUG
		goto out;
	    }

	    psock->ps_received = psock->ps_needed - auio.uio_resid;

	    if ( need_rcls ) {
		if ( psock->ps_received > SMB_RCLS ) {
		    psock->ps_smbrcls = sb->buf[SMB_RCLS-correction];
		    need_rcls = 0;
		}
	    }
	    if ( need_fid ) {
		if ( psock->ps_received > SMB_VWV )  {
		    psock->ps_smbfid = sb->buf[SMB_VWV-correction];
		    need_fid = 0;
		}
	    }
	}

	if ( psock->ps_smbrcls == 0 ) {
	    /* we need to answer the broken call with some kind of undo */
 	    switch ( psock->ps_smbcmd ) {

	        case SMBmknew:
	        case SMBcreate:
	        case SMBopen:
		    err = cleanup_SMBopen(psock,sb);
		    break;
	        case SMBlock:
		    err = cleanup_SMBlock(psock,sb);
		    break;
	        default:
		    break;
	    }
	}

	if ( err == 0 ) {
	    psock->ps_state = PS_CLEAR;
	}
    }
out:
    if ( err ) {
	psock->ps_busy = 0;
	wakeup((caddr_t)psock);
    }
    if ( havebuf ) {
	CKIN_BUF(sb);
    }
    u.u_qsave = lqsave;
    return err;

}


int cleanup_SMBopen(psock,sb)
struct pcsock	    *psock;
struct sendbuf	    *sb;

{
    unsigned char	rcls;
    unsigned short	fid;
    int			i,err;
    time_t		timex;

    timex = time.tv_sec;
    Greenwich_to_local(&time);
    i = buildSMBclose(sb->buf,
		      psock->ps_smbtid,
		      psock->ps_smbpid,
		      psock->ps_smbfid,
		      timex);
    err = nb_send(psock,sb->buf,i);
    if ( err ) {
	return err;
    }
    err = nb_recv(psock,sb);
    return err;
}
	

int cleanup_SMBlock(psock,sb)
struct pcsock	    *psock;
struct sendbuf	    *sb;
{
    unsigned char	rcls;
    int			i,err;

    i = buildSMBunlock(sb->buf,
		       psock->ps_smbtid,
		       psock->ps_smbpid,
		       psock->ps_smbfid,
		       psock->ps_lockcnt,
		       psock->ps_lockoff,
		       psock->ps_smbpid);   /* should go away */
    err = nb_send(psock,sb->buf,i);
    if ( err ) {
	return err;
    }
    err = nb_recv(psock,sb);
    return err;
}
