/*
 *  $Header: npc_fs.c,v 1.2 89/04/07 12:38:29 root Exp $
 */

#include "param.h"
#include "errno.h"
#include "user.h"		/* has implied time.h for vnode.h */
#include "vfs.h"
#include "../netinet/in.h"	/* needed for mount.h */
#include "vnode.h"		/* needed for npcfs.h */
#include "socketvar.h"		/* needed for npcfs.h */
#define	NPCargs
#undef NFS
#include "mount.h"
#undef	NPCargs
#include "nbios.h"	    /* needed for npcfs.h */
#include "npcfs.h"
#include "proc.h"		/* for u.u_procp stuff */
#include "../machine/board.h"	/* for context stuff */
#include "kernel.h"		/* for hz */

int	npc_cust_inited = 0;
int	npc_zoneinfo_failed = 0;
void	npc_cust_tmo();
#define	NPC_CUST_TMO1	20	/* 20 seconds */
#define	NPC_CUST_TMO2	2*60	/* 2 minutes */

extern int  npc_have_zoneinfo;
extern struct timeval	time;	    /* system clock */
char	npc_nbiow[MAX_NBIOWLEN+1];

/* DEBUG */
int prhash_debug = 0;
int pragedbg = 0;
/*
 *  This routine will look for an existing file system with
 *  the name stored at cp and a type of MOUNT_NPC.  If the file system is
 *  found, it will return the root vnode for that file system, else zero
 */
struct vnode *
npc_filesystem(cp)
char	*cp;
{
    register struct vfs	    *vfsp;

    if(npc_checknetname(cp) <=0) {
	return((struct vnode *)0);
    }
    vfsp = npc_searchforfs(cp);
    if(vfsp != NULL) {
	vftomi(vfsp)->m_atime = time;
    } else {
	return((struct vnode *) 0);
    }
    VN_HOLD(vftomi(vfsp)->m_rootvp);
    return(vftomi(vfsp)->m_rootvp);
}
struct vfs  *
npc_searchforfs(cp)
char	*cp;
{
    char		mname[NB_NAME_LEN+1];
    char		msname[NB_SNAME_LEN+1];
    struct vfs		*vfsp;
    struct pcmountinfo	*mi;

    npc_splitname(cp, mname, msname);

    for (vfsp = rootvfs; vfsp != (struct vfs *)0; vfsp = vfsp->vfs_next) {
	mi = vftomi(vfsp);
	if (vfsp->vfs_fsid.val[1] == MOUNT_NPC &&
	    mi->m_name[0] == mname[0] &&
	    (mi->m_flags & NPCMNT_BADFS) == 0 &&
/*	    mi->m_flags & NPCMNT_ACTIVE && */
	    mi->m_rootvp->v_count > 0 &&
	    strcmp(mname, mi->m_name) == 0 &&
	    strcmp(msname, mi->m_sname) == 0) {
	    return(vfsp);
	}
    }
    return((struct vfs *) 0);
}

/*
 *	just as in mount, return a vnode for the root of the file system
 *	    get an ip address form the name server
 *	    assume age and not passwd
 */
struct vnode *
npc_implicit_mount(cp)
char	*cp;
{
    struct npc_args	    args;
    int			    error;
    char		    *tcp;

    u.u_error = 0;
    
    /*  check for valid characters */
    for(tcp = cp; *tcp; tcp++) {
	if(*tcp <= 0x20 || *tcp >= 0x7e || *tcp == '*') {
	    return(NULL);
	}
    }

    args.ip_addr.s_addr = 0;
    args.no_age = 0;
    args.passwd = NULL;
    if(u.u_error = npc_intmount(cp, &args)) { /* will do its own setjmp */
	return((struct vnode *)0);
    }
    
#ifdef DEBUG		/* sanity check */
    /* npc_intmount just added a file system, it better be this one */
    {
	char		    mname[NB_NAME_LEN+1];
	char		    sname[NB_SNAME_LEN+1];
	npc_splitname(cp, mname, sname);
	if(strcmp(vftomi(rootvfs->vfs_next)->m_name, mname) != 0 ||
	   strcmp(vftomi(rootvfs->vfs_next)->m_sname, sname) != 0) {
	    panic("implicit mount failure");
	}
    }
#endif

    VN_HOLD( vftomi(rootvfs->vfs_next)->m_rootvp  );
    return ( vftomi(rootvfs->vfs_next)->m_rootvp  );
}

npc_doerror(error, mi)
int		    error;
struct pcmountinfo  *mi;
{
    struct vfs		*vfsp;
    struct pcmountinfo	*lmi;

    u.u_error = 0;
    
#ifdef DEBUG
    if(error > 100 || error < 0) {
	printf("weird error:%d\n",error);
    }
#endif
    switch (error) {
    case EPIPE:
    case ESPIPE:
    case ENETRESET:
    case ECONNABORTED:
    case ECONNRESET:
    case ETIMEDOUT:
#ifdef DEBUG
	printf("big error:%d\n", error);
#endif
	for (vfsp = rootvfs; vfsp != (struct vfs *)0; vfsp = vfsp->vfs_next) {
	    if (vfsp->vfs_fsid.val[1] == MOUNT_NPC) {
		if((lmi=vftomi(vfsp))->m_sock == mi->m_sock) {
		    lmi->m_flags |= NPCMNT_BADFS;
		}
	    }
	}
restart:
	for (vfsp = rootvfs; vfsp != (struct vfs *)0; vfsp = vfsp->vfs_next) {
	    if (vfsp->vfs_fsid.val[1] == MOUNT_NPC) {
		lmi = vftomi(vfsp);
		if((lmi->m_flags & NPCMNT_BADFS) &&
		   lmi->m_vcnt == 1 &&
		   lmi->m_rootvp->v_count == 1) {
		    VN_RELE(lmi->m_rootvp);
		    if(u.u_error) {
			printf("npc_fs: failed during cleanup\n");
			return(error);
		    }
		    goto restart;
		}
	    }
	}
    }
    return(error);
}

int npc_custodian;

npc_init_custodian()
{
    struct vfs	    *vfsp;
    long	    ctime;
    int		    noage;
    struct pcaccess *ap;
    int	i;
    

    if(npc_cust_inited++) return;
    
    if(newproc(0)) {
	spl0();
	u.u_procp->p_flag |= SLOAD|SSYS;
	u.u_procp->p_pgrp = u.u_procp->p_pid;
	setctx(u.u_procp->p_context = CTX_SYS);
	strcpy(u.u_comm, "NPC custodian");
	
	while (1) {
restart:
	    if(sleep((caddr_t)&npc_custodian, (PZERO-1) | PCATCH)) {
		npcdosig();
#ifdef DEBUG
		printf("got signal on sleep in custodian\n");
#endif
		continue;
	    }

	    if(npc_nbiow[0] == '\0') {
		if(npc_get_nbiow_path(npc_nbiow)) {
#ifdef DEBUG
		    printf("non zero response from getnbiow\n");
#endif DEBUG
		    if(u.u_error) {
			npcdosig();
			continue;
		    }
		}
	    }
	    
	    if(!npc_have_zoneinfo) {
#ifndef NOTDEF
		if(npc_fill_zoneinfo()) {
		    if(u.u_error) {
			npcdosig();
			continue;
		    }
		    npc_zoneinfo_failed++;
		} else {
		    npc_have_zoneinfo++;
		}
#else
		npc_zoneinfo_failed++;
#endif
	    }
	    
	    ctime = time.tv_sec;
start:	    for (vfsp = rootvfs; vfsp != (struct vfs *)0;
		 vfsp = vfsp->vfs_next) {
		if (vfsp->vfs_fsid.val[1] == MOUNT_NPC) {
		    struct pcmountinfo	*mi = vftomi(vfsp);

		    for(noage = 0, ap = mi->m_alist; ap != NULL;
			ap = ap->pa_next) {
			if(ap->pa_flags & NPCMNT_NOAGE) {
			    noage++;
			    break;
			}
		    }
		    if(pragedbg) {
		    printf("m:%s s:%s age:%x bfs:%x tl:%x vcnt:%x v_count:%x\n",
			   mi->m_name, mi->m_sname, noage,
			   mi->m_flags & NPCMNT_BADFS, ctime - mi->m_time,
			   mi->m_vcnt, mi->m_rootvp->v_count);
		    }
		    if(noage) continue;
		    
		    if(ctime - mi->m_time >
		       (mi->m_passwd[0]? AGE_TIME_PW : AGE_TIME_NPW) ||
		       mi->m_flags & NPCMNT_BADFS) {
			if(mi->m_rootvp->v_count == 1 &&
			   mi->m_vcnt <= 1) {
			   /* time to shutdown this file system */
			   u.u_error = 0;
			   VN_RELE(mi->m_rootvp);/* this will delete the fs */
			   if(u.u_error) {
			       printf("error in NPC_VFS shutdown, %d\n",
				      u.u_error);
			       goto restart;
			   }
			   goto start;		 /* vfs links are changed */
			}
			else if(pragedbg){
			    printf("%s %s %s, vcnt:%d, count:%d\n",
				   "Could not delete",
				   (mi->m_flags & NPCMNT_BADFS)?"bad":"aged",
				   "file system",
				   mi->m_vcnt, mi->m_rootvp->v_count);
			    if(prhash_debug)npc_printhash();
			}
		    }
		}
	    }
	}
    }

    timeout(npc_cust_tmo, 0,
	    ((npc_have_zoneinfo)? NPC_CUST_TMO2: NPC_CUST_TMO1) * hz);
}
void
npc_cust_tmo()
{
    wakeup((caddr_t)&npc_custodian);
    timeout(npc_cust_tmo, 0,
	    ((npc_have_zoneinfo)? NPC_CUST_TMO2: NPC_CUST_TMO1) * hz);
}

npcdosig()
{
    if(u.u_procp->p_cursig || ISSIG(u.u_procp)) {
	printf("NPC custodian: %d signal\n", u.u_procp->p_cursig);
	u.u_procp->p_cursig = 0;
	u.u_procp->p_pri = u.u_procp->p_usrpri;
    }
}

