/*
 *  $Header: npc_dircache.c,v 1.2 88/08/29 06:29:24 mark Locked $
 */
#include "param.h"
#include "errno.h"
#include "user.h"	    /* has implied time.h for vnode.h */
#include "proc.h"
#include "vfs.h"
#include "../netinet/in.h"  /* needed for mount.h */
#undef NFS
#include "mount.h"	    /* needed for npcfs.h */
#include "kernel.h"
#include "vnode.h"	    /* needed for npcfs.h */
#include "socketvar.h" /* needed for npcfs.h */
#include "nbios.h"	    /* needed for npcfs.h */
#include "npcfs.h"
#include "sendbuf.h"
#include "smb.h"
#include "pathname.h"

struct dirent {
    struct vnode    *d_parent;
    struct vnode    *d_vp;
    char	    d_name[DOSNMDEC];
    short	    d_pid;
};
#define	NDIRENT	    MIN(sizeof(unsigned long) * 8,\
			(1024-sizeof(unsigned long)-sizeof(struct dirstore *))\
			/ sizeof(struct dirent))
struct dirstor {
    struct dirstor  *ds_next;
    unsigned long   ds_inuse;
    struct dirent   ds_dirent[NDIRENT];
};
static struct dirstor	*ds;

/*
 *	remove all entries for this process
 */
struct dirstor *
npc_dirclean(recurs)
struct dirstor	*recurs;    /* non-zero if this is a recursion */
{
    struct dirent   *dp;
    int		    i;
    unsigned int    j;
    
    /* cleanup the store */
    if(!recurs) {
	if(!ds) {
	    return((struct dirstor *)0);
	}
	recurs = ds;
    }
    for(i = 0, j = 1; i < NDIRENT; i++, j<<=1) {
	if(j & recurs->ds_inuse) {
	    dp = &recurs->ds_dirent[i];
	    if(dp->d_pid == u.u_procp->p_pid) {
		VN_RELE(dp->d_parent);
		VN_RELE(dp->d_vp);
		recurs->ds_inuse ^= j;
	    }
	}
    }
    if(recurs->ds_next) {
	recurs->ds_next = npc_dirclean(recurs->ds_next);
    }
    if(recurs->ds_inuse) {
	return(recurs);
    } else {
	struct dirstor *temp;
	if(recurs == ds) {
	    ds = NULL;
	    temp = 0;
	} else {
	    temp = recurs->ds_next;
	}
	kmem_free(recurs, sizeof(struct dirstor));
	return(temp);
    }
}
npc_direnter(dvp, vp)
struct vnode	*dvp;
struct vnode	*vp;
{
    struct dirstor  *dsp;
    struct dirstor  **dspp;
    struct dirent   *dp;
    unsigned long   j;
    int		    i;

    /* find next available slot */
    dspp = &ds;
    for(dsp = ds; dsp != NULL && ~dsp->ds_inuse==0; dsp = dsp->ds_next) {
	dspp = &dsp->ds_next;
    }
    if(dsp == NULL) {
	*dspp = dsp = (struct dirstor *)kmem_alloc(sizeof(struct dirstor));
	dsp->ds_inuse = 0;
	dsp->ds_next = NULL;
    }
    for(j = 1, dp = dsp->ds_dirent, i = 0;
	((j & dsp->ds_inuse) != 0) && i < NDIRENT;
	j<<=1, dp++, i++);

    dsp->ds_inuse |= j;
    VN_HOLD(dvp);
    dp->d_parent = dvp;
    VN_HOLD(vp);
    dp->d_vp = vp;
    dp->d_pid = u.u_procp->p_pid;
    strcpy(dp->d_name, vtopc(vp)->pc_name);
}
/*
 *	returns vnode but does not put a hold on it
 */
struct vnode *
npc_dirlookup(dvp, name)
struct vnode	*dvp;
char		*name;
{
    unsigned long   j;
    int		    i;
    struct dirent   *dp;
    struct dirstor  *dsp;

    for(dsp = ds; dsp != NULL; dsp = dsp->ds_next) {
	for(i = 0, dp = dsp->ds_dirent, j = 1; i < NDIRENT; i++, dp++, j<<=1) {
	    if((j & dsp->ds_inuse) && dp->d_parent == dvp &&
	       dp->d_pid == u.u_procp->p_pid &&
	       strcmp(dp->d_name, name) == 0) {
		return(dp->d_vp);
	    }
	}
    }
    return((struct vnode * ) 0);
}
npc_pathtocache(dvp, pnp)
struct vnode	*dvp;
struct pathname *pnp;
{
    char		*path;
    char		*cp;
    struct pathname	*tpnp;
    unsigned short	err;
    unsigned char	rcls;
    unsigned short	count;
    struct vfs		*vfsp = dvp->v_vfsp;
    int			isdir;
    struct vnode	*vp;
    char		component[DOSNMDEC];
    int			error;
    int			len;
    struct sendbuf	*sb;
    char		*dir;
    int			force_add = 0;
    struct pathname	cleanedp;

    CKHEALTH(vftomi(vfsp));
    
    tpnp = pn_dup(pnp);

    /* construct a clean path with no ".." in it */
    /*  tpnp starts with leading slashes removed */
    cp = path = (char *)kmem_alloc(MAXPATHLEN);

    pn_skipslash(tpnp);
next:
    *cp++ = 0x5c;
    if(error = pn_getcomponent(tpnp, cp)) {
	tpnp->pn_buf = 0; pn_dfree(tpnp);
	kmem_free(path, MAXPATHLEN);
	goto out;
    }

    if(strcmp(cp, "..") == 0) {
	cp -= 2;	    /* move pointer to before last slash */
	while(cp > path && *cp != 0x5c) {
	    cp--;
	}
	if(cp < path) {
	    tpnp->pn_buf = 0; pn_dfree(tpnp);
	    kmem_free(path, MAXPATHLEN);
	    goto gout;
	}
	goto skip;
    } else if ((*cp == '\0') || (strcmp(cp, ".") == 0)) {
	cp--;
	goto skip;
    }

    if((len = npc_checkdosname(cp)) < 0) {
	tpnp->pn_buf = 0; pn_dfree(tpnp);
	kmem_free(path, MAXPATHLEN);
	error = ENAMETOOLONG;
	goto out;
    }
    cp += len;

skip:
    if(pn_pathleft(tpnp) != 0) {
	pn_skipslash(tpnp);
	goto next;
    }

    tpnp->pn_buf = 0; pn_dfree(tpnp);

    if((int)cp <= (int)path+1) {
	/* nothing really to do */
	kmem_free(path, MAXPATHLEN);
	goto gout;
    }
    *cp = '\0';
    if(error = doSMB(buildSMBsearch, HAVENOSOCK, vftomi(vfsp), HAVENOBUF, &sb,
		     1, FA_DIR, path, 0, 0)) {
#ifdef DEBUG
	printf("pathtocache: doSMB, error: %d\n", error);
#endif
	kmem_free(path, MAXPATHLEN);
	goto out;
    }
    extractSMBsearch(sb->buf, &rcls, &err, &count, &dir);
    isdir = dir[DIR_INFO_ATTR] & FA_DIR;
    if(rcls != SUCCESS || count != 1) {
	do {
	    cp--;
	} while ((*cp != 0x5c) && (cp > (path+1)));
	*cp = '\0';

	if ( strcmp(path,"\\") == 0 ) {
#ifdef DEBUG
	    printf("pathtocache: path is \"\\\" so no chkpath\n");
#endif DEBUG
	    isdir = 1;
	    goto after_ckpath;
	}

#ifdef DEBUG
	printf("pathtocache: SMBsearch rcls:%d cnt:%d  chkpath for dir:%s:\n", 
				rcls, count, path);
#endif DEBUG
	if(error = doSMB(buildSMBchkpath, HAVESOCK, vftomi(vfsp), HAVEBUF,
			 &sb, path)) {
#ifdef DEBUG
	    printf("pathtocache: doSMB2, error:%d\n", error);
#endif
	    kmem_free(path, MAXPATHLEN);
	    goto out;
	}
	extractSMBchkpath(sb->buf, &rcls, &err);
	if(rcls != SUCCESS) {
#ifdef DEBUG
	    printf("error in pathtocache2 - rcls:%d err:%d\n", rcls, err);
#endif
	    CKIN_BUF(sb);
	    CKIN_SOCK(vftomi(vfsp)->m_sock);
	    kmem_free(path, MAXPATHLEN);
	    error = ENOENT;
	    goto out;
	}
	isdir = 1;  /* if chkpath succeeded then must be directory */
    }

after_ckpath:

    CKIN_BUF(sb);
    CKIN_SOCK(vftomi(vfsp)->m_sock);
    
    /* convert back to slashes for pn_getcomponent */
    for(cp = path; *cp; cp++) {
	if(*cp == 0x5c) {
	    *cp = '/';
	}
    }
    tpnp = &cleanedp;
    tpnp->pn_path = tpnp->pn_buf = path;
    tpnp->pn_pathlen = (int)cp - (int)path;
    
#ifdef NOTDEF
    pn_printf(tpnp);
    printf(" will be entered in cache\n");
#endif

    pn_skipslash(tpnp);

next1:
    pn_getcomponent(tpnp, component);
    
    if(strcmp(component, "..") == 0) {
	if((dvp->v_flag & VROOT) == 0) {
	    vp = vtopc(dvp)->pc_parent;
	} else {
	    vp = dvp;
	}
	goto skip1;
    } else if ((component[0] == 0) || (strcmp(component, ".") == 0)) {
	vp = dvp;
	goto skip1;
    }

    if(!force_add) {
	/* npc_dirlookup does not hold vnode */
	if((vp = (struct vnode *)npc_dirlookup(dvp, component)) == NULL) {
	    force_add++;
	    goto getv;
	}
    } else {
getv:
	/* npc_findv does not hold vnode */
	if((vp = npc_findv(dvp, component)) == NULL) {	/* look in hash */
	    if((vp = npc_getvnode(vfsp)) == NULL ) {
		kmem_free(path, MAXPATHLEN);
		error = ENOBUFS;
		goto out;
	    }
	    if(pn_pathleft(tpnp) != 0) {
		vp->v_type = VDIR;
	    }
	    bcopy(component, vtopc(vp)->pc_name, strlen(component)+1);
	    vtopc(vp)->pc_parent = dvp;
	    VN_HOLD(dvp);
	    npc_enterinhash(vp);
	} else {
	    /* do a hold for findv */
	    /* release will be done after direnter */
	    VN_HOLD(vp);
	}
	npc_direnter(dvp, vp);
	VN_RELE(vp);
    }

skip1:
    if(pn_pathleft(tpnp) != 0) {
	pn_skipslash(tpnp);
	dvp = vp;
	goto next1;
    }

    vp->v_type = isdir ? VDIR : VREG;

    kmem_free(path, MAXPATHLEN);
gout:
    return(0);
out:
    return(npc_doerror(error, vftomi(vfsp)));
}


#define	    PCHTABSIZ	32
#define	    PCHASH(parent, c)	((((int)(parent)>>1) ^ (c)) & (PCHTABSIZ-1))
static struct pcnode	*pchtab[PCHTABSIZ];

npc_enterinhash(vp)
struct vnode	*vp;
{
    struct pcnode   *pcp = vtopc(vp);
    int	index = PCHASH(pcp->pc_parent, pcp->pc_name[0]);

    /* elements in hash list are not held (by VN_HOLD) */
    pcp->pc_next = pchtab[index];
    pchtab[index] = pcp;
}
/*
 *	returns vnode but does not put a hold on it
 */
struct vnode *
npc_findv(dvp, nm)
struct vnode	*dvp;	    /* parent vnode for desired vnode */
char		*nm;	    /* vnode name */
{
    struct pcnode   *tpcp;
    
    for(tpcp = pchtab[PCHASH(dvp, *nm)]; tpcp != NULL; tpcp = tpcp->pc_next) {
	if(tpcp->pc_parent == dvp && *nm == tpcp->pc_name[0] &&
	   strcmp(nm, tpcp->pc_name) == 0) {
	    return(&tpcp->pc_vnode);
	}
    }
    return((struct vnode *)0);
}
npc_printhash()
{
    int	i;
    struct pcnode   *tpcp;
    for(i = 0; i < PCHTABSIZ; i++) {
	for(tpcp = pchtab[i]; tpcp != NULL; tpcp = tpcp->pc_next) {
	    printf("node:%s: count:%d\n", tpcp->pc_name, tpcp->pc_vnode.v_count);

	}
    }
}

npc_removefromhash(vp)
struct vnode *vp;
{
    int	index = PCHASH(vtopc(vp)->pc_parent, vtopc(vp)->pc_name[0]);
    struct pcnode   *pcp;
    struct pcnode   **pcpp;

    /* do not do a release on removed element, since it was never held */
    for(pcpp = &pchtab[index], pcp = pchtab[index];
	pcp != NULL; pcpp = &pcp->pc_next, pcp = pcp->pc_next) {
	if(vp == &pcp->pc_vnode) {
	    *pcpp = pcp->pc_next;
	    return;
	}
    }
    printf("tried to remove non-existent pcnode from hash table\n");
    return;
}


struct vnode *
npc_findpccomp(dvp, nm)
struct vnode	*dvp;
char		*nm;
{
    struct sendbuf	*sb;
    int			error;
    unsigned short	err;
    unsigned char	rcls;
    char		*path;
    char		*cp;
    unsigned short	count;
    char		*dir;
    int			isdir;
    struct vnode	*vp;

    u.u_error = 0;
    
    path = (char *)kmem_alloc(MAXPATHLEN);
    cp = npc_buildpath(dvp, path);
    *cp++ = 0x05c;
    strcpy(cp, nm);
#ifdef DEBUG
    printf("findpccomp: path %s\n",path);
#endif DEBUG

    if(error = doSMB(buildSMBsearch, HAVENOSOCK,vftomi(dvp->v_vfsp),
		     HAVENOBUF, &sb, 1, FA_DIR, path, 0, 0)) {
#ifdef DEBUG
	printf("findpccomp, doSMB, error: %d\n", error);
#endif
	kmem_free(path, MAXPATHLEN);
	u.u_error = error;
	return((struct vnode *)0);
    }
    kmem_free(path, MAXPATHLEN);
    extractSMBsearch(sb->buf, &rcls, &err, &count, &dir);
    isdir = dir[DIR_INFO_ATTR] & FA_DIR;
#ifdef DEBUG
    printf("findpccomp: attr %02x\n",dir[DIR_INFO_ATTR]);
#endif DEBUG
    CKIN_BUF(sb);
    CKIN_SOCK(vftomi(dvp->v_vfsp)->m_sock);
    if(rcls != SUCCESS || count != 1) { 
#ifdef DEBUG
	printf("error in findpccomp - rcls:%x err:%x count:%x\n",
	       rcls, err, count);
#endif
	return((struct vnode *)0);
    }

    /* remember, findv does not hold the vnode */
    if((vp = npc_findv(dvp, nm)) == NULL) {
	if((vp = npc_getvnode(dvp->v_vfsp)) == NULL) {
	    printf("error in findpccomp - no vnodes left\n");
	    return((struct vnode *)0);
	}
	vp->v_type = isdir ? VDIR : VREG;
	vtopc(vp)->pc_parent = dvp;
	VN_HOLD(dvp);
	strcpy(vtopc(vp)->pc_name, nm);
	npc_enterinhash(vp);
    } else {
	VN_HOLD(vp);
    }
    return(vp);
}

char *
npc_buildpath(vp, cp)
struct vnode	*vp;
char		*cp;
{

    if((vp->v_flag & VROOT)  == 0) {
	char    *comp = vtopc(vp)->pc_name;
	int	    len = strlen(comp);
	
	cp = npc_buildpath(vtopc(vp)->pc_parent, cp);
	*cp++ = 0x5c;			/* back slash */
	bcopy(comp, cp, len+1);		/* get the null, might get clobbered */
	cp += len;
    }else{
	/*--------------------------------------------------------+
	|  these lines will get walked over unless this routine   |
	|  doesn't recurse, and the caller has nothing to add to  |
	|  the path string					  |
	+--------------------------------------------------------*/
	*cp = 0x5c;
	*(cp+1) = '\0';
    }
    return(cp);
}
