/*
 *  $Header: npc_SMBout.c,v 1.2 89/04/07 12:37:39 root Exp $
 */
#include "param.h"
#include "errno.h"
#include "user.h"	    /* has implied time.h for vnode.h */
#include "proc.h"
#include "../netinet/in.h"  /* needed for mount.h */
#undef NFS
#include "mount.h"	    /* needed for npcfs.h */
#include "vnode.h"	    /* needed for npcfs.h */
#include "socketvar.h" /* needed for npcfs.h */
#include "nbios.h"	    /* needed for npcfs.h */
#include "npcfs.h"
#include "sendbuf.h"
#include "smb.h"


/*----------------------------------------------------------------+
|  These are routines to build individual SMB packets.  In each   |
|  case, the first argument, buf, is the buffer to fill out.  Each|
|  routine returns the size in bytes of the resulting packet.     |
|  these routines are not intelligent enough to do more than      |
|  package items in the buffer; arguments must therefore be pre-  |
|  cisely what will be transmitted (except that any byte swapping |
|  will be taken care of here.  The filling out of other SMB      |
|  fields not represented in the arguments will be taken care of  |
|  also.  Open question is whether or not these routines will     |
|  assume that buf already has certain things filled in, or must  |
|  do that each time.
+--------------------------------------------------------------- */
static char	*cp;
static int	i;

unsigned char	    SMBblank[MIN_SMBPKT] = {
                    0xff, 'S', 'M', 'B',
		    0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x00,
		    0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                    };

/*---------------------------------------------------------+
|  Routine for checking out a general purpose buffer for   |
|  sending and receiving SMB packets.  Its complement,     |
|  CKIN_BUF(), is a macro residing in sendbuf.h            |
+-------------------------------------------------------- */

ckout_buf(sb)
struct sendbuf	    **sb;

{
    int i;
#ifdef DEBUG
    for ( i=0; i<NSENDBUFS; i++) {
	if (sendbufs[i].flag == 0 ) goto found;
    }
    printf("had to sleep for buffer\n");
found:
#endif DEBUG
    for (;;) {
	for ( i=0; i<NSENDBUFS; i++) {
	    if (sendbufs[i].flag == 0 ) {
		sendbufs[i].flag = 1;
		*sb = &(sendbufs[i]);
		return(0);
	    }
	}
	if(sleep(sendbufs,(PZERO+1)|PCATCH)) {
	    return(EINTR);
	}
    }
}


/*--------------------------------------------------+
| the buildSMB routines.  Each returns the size of  |
|  the packet built                                 |
+------------------------------------------------- */

buildSMBtcon(buf,path,passwd,dev)
char	*buf;
char	*path;		/* shortname */
char	*passwd;	/* could be NULL */
char	*dev;		/* either "A:" or "LPT1:" */

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBtcon;
    buf[SMB_WCT] = 0;
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(path,cp,i=strlen(path)+1 );
    cp+=i;
    *cp++ = 0x04;
    bcopy(passwd,cp,i=strlen(passwd)+1 );
    cp += i;
    *cp++ = 0x04;
    bcopy(dev,cp,i=strlen(dev)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf),cp - buf - SMB_BUF(buf) );
    return ( cp - buf );
}


buildSMBtdis(buf,tid,pid)
char	*buf;
short	tid;
short	pid;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBtdis;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    PUT_SMBWORD(buf+SMB_BCC(buf),0);
    return ( MIN_SMBPKT );
}


buildSMBopen(buf,tid,pid,rwshare,attr,pathname)
char	*buf;
short	tid;
short	pid;
short	rwshare;	    /* denials, open permssions */
short	attr;		    /* rw, readonly... */
char*	pathname;	    

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBopen;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 2;
    PUT_SMBWORD(buf+SMB_VWV,rwshare);
    PUT_SMBWORD(buf+SMB_VWV+2,attr);
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(pathname,cp,i=strlen(pathname)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );
}

buildSMBcreate(buf,tid,pid,attr,time,pathname)
char	*buf;
short	tid;
short	pid;
short	attr;
int	time;
char*	pathname;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBcreate;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 3;
    PUT_SMBWORD(buf+SMB_VWV,attr);
    PUT_SMBWORD(buf+SMB_VWV+2, (time & 0xffff) );
    PUT_SMBWORD(buf+SMB_VWV+4, (time >> 16) );
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(pathname,cp,i=strlen(pathname)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );
}

buildSMBclose(buf,tid,pid,fid,time)
char	*buf;
short	tid;
short	pid;
short	fid;
int	time;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBclose;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 3;
    PUT_SMBWORD(buf+SMB_VWV,fid);
    PUT_SMBWORD(buf+SMB_VWV+2,(time & 0xffff));
    PUT_SMBWORD(buf+SMB_VWV+4,(time >> 16));
    PUT_SMBWORD(buf+SMB_BCC(buf),0);
    return ( MIN_SMBPKT + 6 );
}

buildSMBflush(buf,tid,pid,fid)
char	*buf;
short	tid;
short	pid;
short	fid;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBflush;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 1;
    PUT_SMBWORD(buf+SMB_VWV,fid);
    PUT_SMBWORD(buf+SMB_BCC(buf),0);
    return ( MIN_SMBPKT + 2 );
}

buildSMBread(buf,tid,pid,fid,count,offset,remain)
char	*buf;
short	tid;
short	pid;
short	fid;
short	count;
int	offset;
short	remain;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBread;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 5;
    PUT_SMBWORD(buf+SMB_VWV,fid);
    PUT_SMBWORD(buf+SMB_VWV+2,count);
    PUT_SMBWORD(buf+SMB_VWV+4,(offset & 0xffff));
    PUT_SMBWORD(buf+SMB_VWV+6,(offset >> 16));
    PUT_SMBWORD(buf+SMB_VWV+8,remain);
    PUT_SMBWORD(buf+SMB_BCC(buf),0);
    return ( MIN_SMBPKT + 10 );
}

buildSMBwrite(buf,tid,pid,fid,count,offset,remain,data)
char	*buf;
short	tid;
short	pid;
short	fid;
short	count;
int	offset;
short	remain;
char*	data;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBwrite;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 5;
    PUT_SMBWORD(buf+SMB_VWV,fid);
    PUT_SMBWORD(buf+SMB_VWV+2,count);
    PUT_SMBWORD(buf+SMB_VWV+4, (offset & 0xffff) );
    PUT_SMBWORD(buf+SMB_VWV+6, (offset >> 16) );
    PUT_SMBWORD(buf+SMB_VWV+8,remain);
        
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x01;
    PUT_SMBWORD(cp,count);
    cp += 2;
    if ( data ) {
        bcopy(data,cp,count+1 );
    }
    cp += count + 1;
    /* PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) ); */
    /* return( cp - buf );    */
    PUT_SMBWORD(buf+SMB_BCC(buf), count + 3);
    return( MIN_SMBPKT + 10 + 3 + count );    
}


buildSMBseek(buf,tid,pid,fid,mode,offset)
char		*buf;
short		tid;
short		pid;
short		fid;
short		mode;
int		offset;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBlseek;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 4;
    PUT_SMBWORD(buf+SMB_VWV,fid);
    PUT_SMBWORD(buf+SMB_VWV+2,mode);
    PUT_SMBWORD(buf+SMB_VWV+4, (offset & 0xffff) );
    PUT_SMBWORD(buf+SMB_VWV+6, (offset >> 16) );
    PUT_SMBWORD(buf+SMB_BCC(buf),0);
    return ( MIN_SMBPKT + 8 );
}


buildSMBmkdir(buf,tid,pid,pathname)
char	*buf;
short	tid;
short	pid;
char*	pathname;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBmkdir;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 0;
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(pathname,cp,i=strlen(pathname)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );    
}

buildSMBrmdir(buf,tid,pid,pathname)
char	*buf;
short	tid;
short	pid;
char*	pathname;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBrmdir;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 0;
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(pathname,cp,i=strlen(pathname)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );    
}

buildSMBunlink(buf,tid,pid,attr,pathname)
char	*buf;
short	tid;
short	pid;
short	attr;
char*	pathname;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBunlink;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 1;
    PUT_SMBWORD(buf+SMB_VWV,attr);
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(pathname,cp,i=strlen(pathname)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );    
}


buildSMBexit(buf,tid,pid)
char	    *buf;
short	    tid;
short	    pid;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBexit;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    PUT_SMBWORD(buf+SMB_BCC(buf),0);
    return ( MIN_SMBPKT );
}    

buildSMBlock(buf,tid,pid,fid,count,offset)
char	    *buf;
short	    tid;
short	    pid;
short	    fid;
int	    count;
int	    offset;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBlock;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 5;
    PUT_SMBWORD(buf+SMB_VWV,fid);
    PUT_SMBDOUBLE(buf+SMB_VWV+2,count);
    PUT_SMBDOUBLE(buf+SMB_VWV+6,offset);
    PUT_SMBWORD(buf+SMB_BCC(buf),0);
    return ( MIN_SMBPKT + 10 );
}


buildSMBunlock(buf,tid,dpid,fid,count,offset,pid)
char	    *buf;
short	    tid;
short	    dpid;
short	    fid;
int	    count;
int	    offset;
short	    pid;	/* it is screwy to make doSMB happy */
{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBunlock;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 5;
    PUT_SMBWORD(buf+SMB_VWV,fid);
    PUT_SMBDOUBLE(buf+SMB_VWV+2,count);
    PUT_SMBDOUBLE(buf+SMB_VWV+6,offset);
    PUT_SMBWORD(buf+SMB_BCC(buf),0);
    return ( MIN_SMBPKT + 10 );
}


buildSMBmv(buf,tid,pid,attr,old,new)
char	*buf;
short	tid;
short	pid;
short	attr;
char*	old;
char*	new;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBmv;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 1;
    PUT_SMBWORD(buf+SMB_VWV,attr);
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(old,cp,i=strlen(old)+1 );
    cp += i;
    *cp++ = 0x04;
    bcopy(new,cp,i=strlen(new)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );    
}

buildSMBgetatr(buf,tid,pid,pathname)
char	*buf;
short	tid;
short	pid;
char	*pathname;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBgetatr;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 0;
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(pathname,cp,i=strlen(pathname)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );    
}

buildSMBsetatr(buf,tid,pid,attr,time,pathname)
char	*buf;
short	tid;
short	pid;
short	attr;
int	time;
char*	pathname;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBsetatr;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 8;               /*  last 5 reserved */
    PUT_SMBWORD(buf+SMB_VWV,attr);
    PUT_SMBWORD(buf+SMB_VWV+2, (time & 0xffff) );
    PUT_SMBWORD(buf+SMB_VWV+4, (time >> 16) );
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(pathname,cp,i=strlen(pathname)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );    
}


buildSMBmknew(buf,tid,pid,attr,time,pathname)
char	*buf;
short	tid;
short	pid;
short	attr;
int	time;
char*	pathname;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBmknew;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 3;
    PUT_SMBWORD(buf+SMB_VWV,attr);
    PUT_SMBWORD(buf+SMB_VWV+2, (time & 0xffff) );
    PUT_SMBWORD(buf+SMB_VWV+4, (time >> 16) );
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(pathname,cp,i=strlen(pathname)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );    
}

buildSMBchkpath(buf,tid,pid,dirname)
char	*buf;
short	tid;
short	pid;
char*	dirname;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBchkpath;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 0;
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(dirname,cp,i=strlen(dirname)+1 );
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );    
}

buildSMBdskattr(buf,tid,pid)
char	*buf;
short	tid;
short	pid;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBdskattr;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    PUT_SMBWORD(buf+SMB_BCC(buf),0);
    return ( MIN_SMBPKT );
}

buildSMBnegprot(buf,dialects)
char	*buf;
char**	dialects;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBnegprot;
    buf[SMB_WCT] = 0;
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x02;
    bcopy(*dialects,cp,i=strlen(*dialects)+1 ); /* assume just 1 for now */
    cp += i;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );    
}

buildSMBsearch(buf,tid,pid,maxct,attr,pathname,datal,status)
char	*buf;
short	tid;
short	pid;
short	maxct;
short	attr;
char*	pathname;
short	datal;
char*	status;

{
    bcopy(SMBblank,buf,MIN_SMBPKT);
    buf[SMB_COM] = SMBsearch;
    PUT_SMBWORD(buf+SMB_TID,tid);
    PUT_SMBWORD(buf+SMB_PID,pid);
    buf[SMB_WCT] = 2;
    PUT_SMBWORD(buf+SMB_VWV,maxct);
    PUT_SMBWORD(buf+SMB_VWV+2,attr);
    cp = buf + SMB_BUF(buf);
    *cp++ = 0x04;
    bcopy(pathname,cp,i=strlen(pathname)+1 );
    cp += i;
    *cp++ = 0x05;
    PUT_SMBWORD(cp,datal);
    cp += 2;
    bcopy(status,cp,datal+1);
    cp += datal;
    PUT_SMBWORD(buf+SMB_BCC(buf), cp - buf - SMB_BUF(buf) );
    return( cp - buf );    
}


/*
 *	this routine handles error recovery for a very common set
 *	of operations.
 *	On error the socket and the buffer are freed.
 *	Otherwise this routine returns without freeing either
 *	It calls the routine below, which takes a pid arg.
 *	We now have a situation where sometimes a phony pid is
 * 	called for and sometimes the real pid.  Most everyone can
 *	continue to use doSMB, but some will want to use doSMB1
 *	directly to decide which pid to use
 */
doSMB(buildSMB, havesock, mi, havebuf, sbpp, p1, p2, p3, p4, p5)
int		    (*buildSMB)();
int		    havesock;
struct pcmountinfo  *mi;
int		    havebuf;
struct sendbuf	    **sbpp;
int		    p1, p2, p3, p4, p5;
{
    
    return doSMB1(buildSMB, 
		  havesock, 
		  mi, 
		  havebuf, 
		  sbpp, 
		  PSEUDO_PID, 
		  p1, p2, p3, p4, p5);
}

doSMB1(buildSMB, havesock, mi, havebuf, sbpp, pidx, p1, p2, p3, p4, p5)
int		    (*buildSMB)();
int		    havesock;
struct pcmountinfo  *mi;
int		    havebuf;
struct sendbuf	    **sbpp;
int		    pidx;
int		    p1, p2, p3, p4, p5;
{
    int		    error;
    struct sendbuf  *sbp;
    int		    len;


    if(setjmp(&u.u_qsave)) {
	if(havebuf) {
	    CKIN_BUF(sbp);
	}
	if(havesock) {
	    CKIN_SOCK(mi->m_sock);
	}
#ifdef DEBUG
	printf("did longjump to doSMB\n");
#endif
	return(EINTR);
    }
    
    if(!havebuf) {
	if(error = ckout_buf(sbpp)) {
	    npc_printf(error, "doSMB: error in ckout_buf %d\n",error);
	    if(havesock) CKIN_SOCK(mi->m_sock);
	    return(error);
	}
	havebuf++;
    }
    
    sbp = *sbpp;
    
    len = (*buildSMB)(sbp->buf, mi->m_tid, pidx, p1, p2, p3, p4, p5);

    if(!havesock) {
	if(error = npc_ckout_sock(mi->m_sock)) {
	    npc_printf(error, "doSMB: error in npc_ckout_sock %d\n",error);
	    CKIN_BUF(sbp);
	    return(error);
	}
	havesock++;
    }

    if(error = nb_send(mi->m_sock, sbp->buf, len)) {
	npc_printf(error, "doSMB: error in nb_send %d\n",error);
	CKIN_BUF(sbp);
	CKIN_SOCK(mi->m_sock);
	return(error);
    }

    if ( buildSMB != buildSMBexit ) {
	npc_addpid(pidx,mi);
    }

    if(error = nb_recv(mi->m_sock, sbp)) {
	npc_printf(error, "doSMB: error in nb_recv %d\n",error);
	CKIN_BUF(sbp);
	CKIN_SOCK(mi->m_sock);
    }
    
    return(error);
}
