#include "../npc/smb.h"

/*-----------------------------------------------------------+
|  Individual routines to extract items from an SMB reply.   |
|  These are called assuming the nature of the reply, so a   |
|  sanity check is required to verify that the reply is in-  |
|  deed the one anticipated.                                 |
+---------------------------------------------------------- */



extractSMBtcon(buf,rcls,err,tid,maxpkt)
char	    *buf;
char	    *rcls;
short	    *err;
short	    *tid;
short	    *maxpkt;

{
    if ( buf[SMB_COM] != SMBtcon ){
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    *maxpkt = GET_SMBWORD(buf+SMB_VWV);
    *tid = GET_SMBWORD(buf+SMB_VWV+2);
    return 0;
}



extractSMBopen(buf,rcls,err,fid,attr,time,fsize,access)
char	    *buf;
char	    *rcls;
short	    *err;
short	    *fid;
short	    *attr;
int	    *time;
int	    *fsize;
short	    *access;

{
    if ( buf[SMB_COM] != SMBopen ){
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    *fid = GET_SMBWORD(buf+SMB_VWV);
    *attr = GET_SMBWORD(buf+SMB_VWV+2);
    *time = GET_SMBDOUBLE(buf+SMB_VWV+4);
    *fsize = GET_SMBDOUBLE(buf+SMB_VWV+8);
    *access = GET_SMBWORD(buf+SMB_VWV+12);
    return 0;
}


extractSMBcreate(buf,rcls,err,fid)
char	    *buf;
char	    *rcls;
short	    *err;
short	    *fid;

{
    if ( buf[SMB_COM] != SMBcreate ){
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    *fid = GET_SMBWORD(buf+SMB_VWV);
    return 0;
}





extractSMBread(buf,rcls,err,count,datap)
char	    *buf;
char	    *rcls;
short	    *err;
short	    *count;
char	    **datap;

{
    if ( buf[SMB_COM] != SMBread ){
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    *count = GET_SMBWORD(buf+SMB_VWV);
    *datap = buf + SMB_BUF(buf) + 3;
    return 0;
}


extractSMBwrite(buf,rcls,err,count)
char	    *buf;
char	    *rcls;
short	    *err;
short	    *count;

{
    if ( buf[SMB_COM] != SMBwrite ){
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    *count = GET_SMBWORD(buf+SMB_VWV);
    return 0;
}


extractSMBseek(buf,rcls,err,offset)
char	    *buf;
char	    *rcls;
short	    *err;
int	    *offset;

{
    if ( buf[SMB_COM] != SMBlseek ) {
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf + SMB_ERR);
    *offset = GET_SMBDOUBLE(buf + SMB_VWV);
    return 0;
}
    


extractSMBgetatr(buf,rcls,err,attr,time,fsize)
char	    *buf;
char	    *rcls;
short	    *err;
short	    *attr;
int	    *time;
int	    *fsize;

{
    if ( buf[SMB_COM] != SMBgetatr ){
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    *attr = GET_SMBWORD(buf+SMB_VWV);
    *time = GET_SMBDOUBLE(buf+SMB_VWV+2);
    *fsize = GET_SMBDOUBLE(buf+SMB_VWV+6);
    return 0;
}





extractSMBmknew(buf,rcls,err,fid)
char	    *buf;
char	    *rcls;
short	    *err;
short	    *fid;

{
    if ( buf[SMB_COM] != SMBmknew ){
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    *fid = GET_SMBWORD(buf+SMB_VWV);
    return 0;
}





extractSMBdskattr(buf,rcls,err,units,blocks,bsize,free)
char	    *buf;
char	    *rcls;
short	    *err;
short	    *units;
short	    *blocks;
short	    *bsize;
short	    *free;

{
    if ( (unsigned char)(buf[SMB_COM]) != SMBdskattr ){
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    *units = GET_SMBWORD(buf+SMB_VWV);
    *blocks = GET_SMBWORD(buf+SMB_VWV+2);
    *bsize = GET_SMBWORD(buf+SMB_VWV+4);
    *free = GET_SMBWORD(buf+SMB_VWV+6);
    return 0;
}


extractSMBnegprot(buf,rcls,err,index)
char	    *buf;
char	    *rcls;
short	    *err;
short	    *index;

{
    if ( buf[SMB_COM] != SMBnegprot ){
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    *index = GET_SMBWORD(buf+SMB_VWV);
    return 0;
}


extractSMBsearch(buf,rcls,err,count,entries)
char	    *buf;
char	    *rcls;
short	    *err;
short	    *count;
char	    **entries;

{
    if ( (unsigned char)(buf[SMB_COM]) != SMBsearch ){
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    *count = GET_SMBWORD(buf+SMB_VWV);
    *entries = buf+SMB_BUF(buf)+3;
    return 0;
}


extractSMB(buf,rcls,err,com)
char		    *buf;
unsigned char	    *rcls;
unsigned short	    *err;
unsigned char	    com;

{
    if ( buf[SMB_COM] != com ){
#ifdef DEBUG
        printf("extractSMB: buf[SMB_COM] %x com %x\n",buf[SMB_COM]&0xff,
                                                      com&0xff);
	*rcls = 0;
	*err = 0;
#endif DEBUG
	return -1;
    }
    *rcls = buf[SMB_RCLS];
    *err = GET_SMBWORD(buf+SMB_ERR);
    return 0;
}
