/*
**	if_token.h, token ring definitions and structs. TI refers
**	to the TI TMS380 Token Ring chip set Users Guide.
*/

/*
** Routing Information Fields
*/
struct token_sgmt  {
	u_short		token_segmt_number;
};

#define	MAXSGMTS	8

struct token_route {
	u_short		  control;		/* Route control */
	struct token_sgmt segments[MAXSGMTS];	/* Segment numbers */
};
#define	RC_BROADCAST	0x1000			/* All ring broadcat */
#define	RC_LENGTH	0x1f00			/* Length bits */
#define	RC_LEN_SFT	8			/* Length shift */
#define	RC_DIRECTION	0x0080			/* Direction Bit */
#define	RC_TOTARGET	0x0080			/* Org -> Target */

/*
 * Structure of a 10Mb/s Ethernet header.
 */
struct	token_header {
	u_char		   token_access;	/* Access control field */
	u_char		   token_frame;		/* Frame control field */
	u_char		   token_dhost[6];
	u_char		   token_shost[6];
#ifdef notdef
	struct token_route token_route;		/* Routing info field */
#endif
};
#define	TOKENTYPE_MAC	0x0000;			/* MAC packet */

/*
**  Frame Control bit definitions
*/
#define	FC_TYPE		0xc0			/* Type bits */
#define FC_MAC		0x00			/* MAC Frame indicator */
#define FC_STD		0x40			/* non-MAC Frame indicator */
#define	FC_PCF		0x0f			/* MAC PCF bits */
#define	FC_EXP		0x01			/* Express buffer */
#define	FC_BCON		0x02			/* Beacon */
#define	FC_CLAM		0x03			/* Claim Token */
#define	FC_PRG		0x04			/* Ring Purge */
#define	FC_AMP		0x05			/* Active Monitor Present */
#define	FC_SMP		0x06			/* Standby Monitor Present */


/*
**  802.2 header, used after the token (MAC) header for IP.
*/
struct llc_header {
	u_char	llc_dsap;		/* DSAP field */
	u_char	llc_ssap;		/* SSAP field */
	u_char	llc_cntl;		/* Control field */
};
#define	LLC_SIZE	3
#define	SAP_IP		0xaa			/* LLC IP SAP */
#define	LLC_U		0x3			/* Unnumbered format */

/*
**  Special "SNAP" header, for kludging IP on LLC
*/
struct snap {
	u_char	snap_spare[3];		/* Three bytes of junk (zero) */
	u_char	snap_type[2];		/* Standard "ethertype" type field */
};
#define	SNAP_SIZE	5

/*
** The TI chip set is that we are working with these days, so out MTU is
**	defined by that.  the equasion is (see TI . 4-93):
**		(BUFFER SIZE - 8) * TRANSMIT BUFFER MAX
**	With 112 and 14, this gives a MTU of 1456.  This is the max possible
**	as there are only 16 112 byte buffers and at lease two must be
**	reserved for receive (again, see TI pp. 4-91 to 4-93).
*/
#define	TOKENBUFSIZE	112
#define	TOKENBUFMAX	14
#define	TOKENHDRSIZE	(sizeof(struct token_header) + LLC_SIZE + SNAP_SIZE)
#define	TOKENMTU	(((TOKENBUFSIZE-8) * TOKENBUFMAX) - TOKENHDRSIZE)
#define	TOKENMIN	(sizeof(struct token_header)+1)

/*
 * Token Ring Address Resolution Protocol.
 *
 * See RFC 826 for protocol description.  Structure below is adapted
 * to resolving internet addresses.  Field names used correspond to 
 * RFC 826.
 */
struct	token_arp {
	struct arphdr tr_hdr;
#define TRARPHRD_TOKEN 	4	/* token ring hardware address */
#define TRARPHRD_ETHER 	6	/* erstwhile token */
	u_char	trarp_sha[6];	/* sender hardware address */
	u_char	trarp_spa[4];	/* sender protocol address */
	u_char	trarp_tha[6];	/* target hardware address */
	u_char	trarp_tpa[4];	/* target protocol address */
};
#define	trarp_hrd	tr_hdr.ar_hrd
#define	trarp_pro	tr_hdr.ar_pro
#define	trarp_hln	tr_hdr.ar_hln
#define	trarp_pln	tr_hdr.ar_pln
#define	trarp_op	tr_hdr.ar_op

/*
 * Structure shared between the token driver modules and
 * the address resolution code.  For example, each ec_softc or il_softc
 * begins with this structure.
 */
struct	trarpcom {
	struct ifnet ac_if;		/* network-visible interface */
	u_char ac_traddr[6];		/* token ring hardware address */
	struct in_addr ac_ipaddr;	/* copy of ip address - XXX */
};

/*
 * Internet to ethernet address resolution table.
 */
struct	trarptab {
	struct	in_addr at_iaddr;	/* internet address */
	u_char	at_traddr[6];		/* token ring address */
	struct	mbuf *at_hold;		/* last packet until resolved/timeout */
	u_char	at_timer;		/* minutes since last reference */
	u_char	at_flags;		/* flags */
};

#ifdef	KERNEL
u_char tokenbroadcastaddr[6];
struct trarptab *trarptnew();
#endif
