/*
 * copyright (c) 1987.  Kinetics, Inc.
 *
 * aarp.h :  AppleTalk Address Resolution Protocol definitions.
 */

#define	PROBERETRIES		5
#define	REQRETRIES		5
#define	AARP_ENETTYPE		1

#define	MAXPROTLEN	4
#define	MAXHARDLEN	6
#define	ATAMTLEN	255

/*
 *  AARP packet format for ethernet
 */
struct aarphdr {
	u_short	hardtype;			/* hardware type */
	u_short	prottype;			/* protocol type */
	u_char	hardlen;			/* hardware address len */
	u_char	protlen;			/* protocol address len */
	u_short	cmd;				/* packet type - see below */
	u_char	shardaddr[MAXHARDLEN];		/* source hardware address */
	u_char	slogaddr[MAXPROTLEN];		/* source protocol address */
	u_char	dhardaddr[MAXHARDLEN];		/* dest hardware address */
	u_char	dlogaddr[MAXPROTLEN];		/* dest protocol address */
};

/* AARP commands */
#define	AARPREQ		1		/* request address mapping */
#define	AARPRESP	2		/* address mapping response */
#define	AARPPROBE	3		/* choose an unused address */

/* address extraction macros */
#define	aarp_spa(ea)	(*(struct in_addr *)(ea)->slogaddr)
#define	aarp_tpa(ea)	(*(struct in_addr *)(ea)->dlogaddr)
