/*
 * Copyright (c) 1980, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)netisr.h	7.1 (Berkeley) 6/4/86
 */

/*
 * The networking code runs off software interrupts.
 *
 * You can switch into the network by doing splnet() and return by splx().
 * The software interrupt level for the network is higher than the software
 * level for the clock (so you can enter the network in routines called
 * at timeout time).
 */

/*
 * These definitions are only to provide compatibility with old code; 
 * new stuff should use softcall directly.
 */
#define	schednetisr(isrname)	softcall(isrname, (caddr_t)0)

#define	NETISR_RAW	rawintr		/* raw net intr */
#define	NETISR_IP	ipintr		/* IP net intr */
#define	NETISR_NS	nsintr		/* NS net intr */
#define	NETISR_IMP	impintr		/* AF_IMPLINK net intr */
#define	NETISR_DDP	ddpintr		/* AF_APPLETALK net intr */
#define NETISR_RFS	netrfsintr	/* RFS net intr */

int	rawintr();

#ifndef is68k_kobj
#ifdef	INET
int	ipintr();
#endif	INET

#ifdef	NS
int	nsintr();
#endif	NS

#include "imp.h"
#if	NIMP > 0
int	impintr();
#endif	NIMP > 0

#ifdef	APPLETALK
int	ddpintr();
#endif	APPLETALK

#ifdef	RFS
int	netrfsintr();
#endif	RFS
#endif	is68k_kobj
