#include "../h/types.h"
#include "saio.h"
#include "../dev/sioreg.h"
#include "../machine/board.h"

#define	MULT	10
#define	NLOGS	1000
#define	SMD_VECT	0x40
#define BSIZE		(0xfc00 / 4)

#define devtoblk(x)	((x)/ NCPB)
#define devtochan(x)	((x)% NCPB)

struct siochan 	 	*sio_addr[NSIO];
struct sioblock 	*blk_addr[NBLOCKS];

int	sioint();
int	softint();
int	timerint();
int	vmeint();
int	clock;
extern	long dorte;
extern	unsigned long memsize;
unsigned int	dbuf[BSIZE+1];
int fi, diskerr, memerr, iteration;
unsigned long *lptr;
extern char end;
int *dptr, *mptr, doffset, moffset;
struct log {
	unsigned long l_exp;
	unsigned long l_act;
	unsigned long l_addr;
	unsigned long l_iter;
} log[NLOGS];
int logindex;

main()
{
        register int i, j;
        char buf[50];
	int multbuf[MULT];

        do  {
                printf("device: "); gets(buf);
                fi = open(buf, 2);
        } while (fi < 0);
	for (i = 0 ; i < BSIZE ; i++)
		dbuf[i] = i;
	lseek(fi, 0, 0);
	if (write(fi, dbuf, BSIZE * 4) != BSIZE * 4) {
		printf("Write failed");
		exit(1);
	}

	printf("Press any key to print error log\n");
	rupt_enable();
	vme_rupt_enable();
	dorte = 1;
	set_vec(SMD_VECT, vmeint);
	set_vec(TIMER_VECT, timerint);
	set_vec(SOFT_VECT, softint);
	set_vec(SIO_VECT, sioint);
	sioinit();
	_splx(0x2000);
	ioctl(fi, 0, 0);		/* turn on interrupt */
	vmeint();

	iteration = 0;
	while (++iteration) {
		mptr = (int *)((int)&end + moffset);
		for (lptr=mptr ; ((unsigned long)lptr+3)<memsize ; lptr++)
			*lptr = 0;

		for (lptr=mptr ;((unsigned long)lptr+(sizeof multbuf))<memsize;
		       lptr += MULT) {
			for (j = 0 ; j < MULT ; j++) { 
				multbuf[j] = (int)&lptr[j];
			}
			pushmult(multbuf, lptr);
		}

		for (lptr=mptr ; ((unsigned long)lptr+(sizeof multbuf))<memsize;
		       lptr++)
			if (*lptr != (unsigned long)lptr) {
printf("MEMERROR: exp=0x%x, act=0x%x, addr=0x%x\n", lptr,*lptr, lptr);
				logerror(lptr, *lptr, lptr, iteration);
			}
		if (++moffset == 4)
			moffset = 0;

	}
}

vmeint()
{
	if (doffset)
		doffset = 0;
	else
		doffset = 2;

	lseek(fi, 0, 0);
	read(fi, (int *)((int)dbuf + doffset), BSIZE * 4);
}

sioinit()
{
	register int i, opcr, acr;
	struct s2698device *p;
	unsigned short interval = CLOCKPERIOD;
	
	
	p = (struct s2698device *)OCTART_ADDR;
	for (i = 0 ; i < NSIO; i++)
		if (devtochan(i) == 0)
			sio_addr[i] = &p->s2698_block[devtoblk(i)].blk_chana;
		else
			sio_addr[i] = &p->s2698_block[devtoblk(i)].blk_chanb;

	for (i = 0 ; i < NBLOCKS; i++) {
		blk_addr[i] = &p->s2698_block[i];
		afcwb(&blk_addr[i]->blk_isr_imr, 
			IMR_CHANA_RXRDY|IMR_CHANB_RXRDY);
		afcrb(&blk_addr[i]->blk_ct_stop);
		if (i == RTCOUNTER)
                        opcr = OPCR_MOPA_CTO | OPCR_MOPB_RTSN;
                else
                        opcr = OPCR_MOPA_RTSN | OPCR_MOPB_RTSN;
                afcwb(&blk_addr[i]->blk_ipr_opcr, opcr);
                if (i == RTCOUNTER)
                        acr = ACR_TIMER_CLK;
                else if (i == CLKCOUNTER)
                        acr = ACR_CNTR_MPI;
                else if ((i == CMCOUNTER) || (i == CHCOUNTER))
                        acr = ACR_CNTR_MPI_DIV_16;
                else
                        acr = 0;
                afcwb(&blk_addr[i]->blk_ipcr_acr, acr);
		if (i == RTCOUNTER) {
			afcwb(&blk_addr[RTCOUNTER]->blk_ctu, hibyte(interval));
			afcwb(&blk_addr[RTCOUNTER]->blk_ctl, lobyte(interval));
			afcrb(&blk_addr[RTCOUNTER]->blk_ct_go,lobyte(interval));
		}

		afcwb(&sio_addr[i * NCPB + 0]->chan_cr, 
		    CR_CMD_RST_MR|CR_DISABLE_TX|CR_DISABLE_RX);
		afcwb(&sio_addr[i * NCPB + 0]->chan_mr12, 
		    MR1_8_BIT|MR1_PAR_NONE);
		afcwb(&sio_addr[i * NCPB + 0]->chan_mr12, MR2_1_STOP);
		afcwb(&sio_addr[i * NCPB + 0]->chan_sr_csr, 0xbb);
		afcwb(&sio_addr[i * NCPB + 0]->chan_cr,
	    	    CR_CMD_RST_MR|CR_ENABLE_TX|CR_ENABLE_RX);
		if (i)
			afcwb(&sio_addr[i*NCPB+0]->chan_cr,CR_CMD_RTSN_ASSERT);

		afcwb(&sio_addr[i * NCPB + 1]->chan_cr, 
		    CR_CMD_RST_MR|CR_DISABLE_TX|CR_DISABLE_RX);
		afcwb(&sio_addr[i * NCPB + 1]->chan_mr12, 
		    MR1_8_BIT|MR1_PAR_NONE);
		afcwb(&sio_addr[i * NCPB + 1]->chan_mr12, MR2_1_STOP);
		afcwb(&sio_addr[i * NCPB + 1]->chan_sr_csr, 0xbb);
		afcwb(&sio_addr[i * NCPB + 1]->chan_cr,
	    	    CR_CMD_RST_MR|CR_ENABLE_TX|CR_ENABLE_RX);
		afcwb(&sio_addr[i * NCPB + 1]->chan_cr,CR_CMD_RTSN_ASSERT);
	}

}


sioint()
{
	register unsigned char sr, c;
	register i;

	for (i = 0 ; i < NSIO ; i++) {
		sr = afcrb(&sio_addr[i]->chan_sr_csr);
		if (sr & SR_RXRDY) {
			afcrb(&sio_addr[i]->chan_rhr_thr);
			printlog();
		}
	}
}

timerint()
{
	set_softint();
}

softint()
{
	clear_softint();
	if ((clock++ % 60) == 0)
		_blink_errled();
}


logerror(exp, act, addr, iter)
{
	log[logindex].l_exp = exp;
	log[logindex].l_act = act;
	log[logindex].l_addr = addr;
	log[logindex].l_iter = iter;
	if (++logindex >= NLOGS)
		logindex = 0;
	memerr++;
}

printlog()
{
	register i, last;

	printf("\n\n	****** ERROR LOG ******\n\n");
	printf("%d errors in %d iterations\n\n", memerr, iteration);
	if (memerr){
		if (memerr > logindex)
			last = NLOGS;
		else
			last = logindex;
		for (i = 0 ; i < last ; i++)
			printf("EXP=0x%x  ACT=0x%x  ADDR=0x%x  ITER=%d\n", 
				log[i].l_exp,
				log[i].l_act,
				log[i].l_addr,
				log[i].l_iter);
	}
	printf("\n\n");
}
