
/* SCCS id @(#)video.h	1.1 */
/* Structures to contain information about the current monitor type. */

#define	FASTVIDEO	/* structure changes for optimised OpenChip code */

#ifndef	lword
#define	lword		unsigned long
#endif	lword

typedef struct {
    short	polarity;               /* the passive value of the signal */
    short	type;                   /* the type of sync for this signal */
} sync_info;

/* values for sync type */

#define DISABLED	0               /* signal is always off */
#define VERT_SYNC	1               /* signal is vertical sync */
#define HORIZ_SYNC	2               /* signal is horizontal sync */
#define COMP_SYNC	3               /* signal is composite sync
                                           (horizontal EOR vertical) */

#define NSYNCS		3               /* how many sync signals to generate */

/* Constants for the polarities of signals */

#define ACTIVE_HIGH	0
#define ACTIVE_LOW	-1

/* Structure which defines the characteristics of a monitor. All of the
   'horizontal' measurements in this structure are in units of the time
   taken to display a long word of 1 bit pixels (c.f. rowwords in an
   OpenTop form). This means that in general they have to be multiplied
   by the number of bit planes when being used. The 'vertical'
   measurements are in raster lines. */

typedef struct {
    short	prate;		/* pixel rate in MHz */
    sync_info	sync[NSYNCS];   /* info for each sync output */
    short	interlaced;     /* TRUE if the picture is interlaced */
    short	line_width;     /* total scan line width in row long words */
    short	h_blank;        /* offset to start of horizontal blanking */
    short	h_sync_start;   /* offset to start of horizontal sync */
    short	h_sync_end;     /* offset to end of horizontal sync */
    short	scan_lines;     /* total scan lines per frame */
    short	v_blank;        /* offset to start of vertical blank */
    short	v_sync_start;   /* offset to start of vertical blank */
    short	v_sync_end;     /* offset to end of vertical blank */
} mon_info;

/* The structure of the part of the video list which contains
   pointers to video data. Each scan line consists of a pointer
   to the data for the visible part of the line followed by
   three words of sync information. The structure has
   four words of sync information since the sync
   information words must always come in pairs. The last
   word will always have a repeat count of zero, so can be used
   for palette changes and to cause frame interrupts. */

#ifdef	FASTVIDEO

/* align a vid_sync pointer ready for the next raster_line according to */
/* ordering of sync patterns within a long word */

#define	RASTERALIGN(v)	((raster_line *)(((unsigned long)(v) ^ 2L + 3L) & ~3L))

/* step to previous/next sync pattern entries according to */
/* ordering of sync patterns within a long word */

#define	PREVVIDSYNC(v)		((v)-(((unsigned long)(v) & 2) ? 3 : -1))
#define	NEXTVIDSYNC(v)		((v)+(((unsigned long)(v) & 2) ? -1 : 3))

typedef struct
{
    unsigned char vs_flags;
    unsigned char vs_count;			/* LAST in word */
} vid_sync;

typedef struct {
    lword	*data;                  /* -> raster data */
    vid_sync	h_sync;                 /* horizontal sync pulse */
    vid_sync	front_porch;            /* front porch sync, LAST in long */
    vid_sync	flags;                  /* flags word */
    vid_sync	back_porch;             /* back porch sync data */
} raster_line;

#else !FASTVIDEO

/* align a vid_sync pointer ready for the next raster_line according to */
/* ordering of sync patterns within a long word */

#define	RASTERALIGN(v)	((raster_line *)(((unsigned long)(v) + 3L) & ~3L))

/* step to previous/next sync pattern entries according to */
/* ordering of sync patterns within a long word */

#define	PREVVIDSYNC(v)		((v)-1)
#define	NEXTVIDSYNC(v)		((v)+1)

typedef struct
{
    unsigned char vs_count;			/* count FIRST in word */
    unsigned char vs_flags;
} vid_sync;

typedef struct {
    lword	*data;                  /* -> raster data */
    vid_sync	front_porch;            /* front porch sync, FIRST in long */
    vid_sync	h_sync;                 /* horizontal sync pulse */
    vid_sync	back_porch;             /* back porch sync data */
    vid_sync	flags;                  /* flags word */
} raster_line;

#endif !FASTVIDEO
