
/* VDMA test */

#include "../h/types.h"
#include "saio.h"
#include "sais68k.h"
#include "../dev/sioreg.h"
#include	<setjmp.h>
jmp_buf	vdma;
extern	int (*user_exit)();


long errcnt;
extern	int	memsize;

#define devtoblk(x)	((x)/ NCPB)
#define devtochan(x)	((x)% NCPB)
struct siochan 	 	*sio_addr[NSIO];
struct sioblock 	*blk_addr[NBLOCKS];
extern	int dorte, ignore_intr;
extern short	scr;
int	rd_keybd(), vdma_space;
extern	char keybd_intr;

#ifdef	PROMDIAG
#	define	MEMADDR	0x200000	/* above boot and below prom */
	extern int go_no_go;
	p_vdma()
#else
#	define	MEMADDR	0x300000
	int go_no_go = 0;
	main()
#endif
{
	register index;
	int	err_cnt = 0;

	printf("\n--- %i Standalone VDMA/VBMATM Diagnostics --- (%s)\n",
					time_str(read_time()) );
	bs_20("");				/* initilize the back space counter */
	if(!go_no_go) printf("\n The test assumes presence of ram at %x-%x\n",
									 MEMADDR, MEMADDR +0xfffff);
	user_exit = rd_keybd;
	sio_init(1);			/* enable keyboard interrupts */
	if(setjmp(vdma) == ''){   /* prepare to return here on ^C */
		user_exit = 0;
		sio_init(0);		/* disable sio */
		restvdma();
		return(1);
	}

	initvdma();
	for (index = 0 ; index < VBM_SLOTS ; index++) {
		if (! go_no_go)
			printf(" Testing VBMATM map index %d.\n", index);
		errcnt = 0;
		testvbm(index);
		err_cnt += errcnt;
		if( go_no_go){ if(err_cnt) break;}
		else printf(" Index %d, %d error encountered\n", index, errcnt);
	}
/*	if (go_no_go) bs_20("\b");
 */
	bs_20((err_cnt)? "** Failed **" : "** Passed **");
	user_exit = 0;
	sio_init(0);		/* disable sio */
	restvdma();
	return(err_cnt);
}

/**********************************/
restvdma()
{
	register int i, map;
	register short j;

	afcww(&vbmatm_reg[0], (VBM_AM_SHORT << 6)|VBM_PORT_16);
	afcww(&vbmatm_reg[1], (VBM_AM_STD   << 6)|VBM_PORT_16);
	afcww(&vbmatm_reg[2], (VBM_AM_EXT   << 6)|VBM_PORT_16);
	for (i = 3; i < VBM_SLOTS; i++)
		afcww(&vbmatm_reg[i], (VBM_AM_EXT << 6)|VBM_PORT_32);

	map = VBM_BASE(0);
	j = btop(MEMADDR);
	for (i = 0 ; i < btoc(VDMA_SPACE) ; i++, j++)
		*(short *)(map+VDMA_MAP_ADDR(i,vbnum)) = j;
}


initvdma()
{
	register int i, map;
	register short j;

	afcww(&vbmatm_reg[0], (VBM_AM_SHORT << 6)|VBM_PORT_16);
	map = VBM_BASE(0);
	j = btop(MEMADDR);
	for (i = 0 ; i < btoc(VDMA_SPACE) ; i++, j++)
		*(short *)(map+VDMA_MAP_ADDR(i,vbnum)) = j;
}

testvbm(index)
{
	if(! index) vdma_space = VDMA_SPACE;
	afcww(&vbmatm_reg[index], (VBM_AM_STD << 6)|VBM_PORT_16);
	testmem(index, "PORT_16", 0);
	if(go_no_go) vdma_space = 0x100;
	afcww(&vbmatm_reg[index], (VBM_AM_STD << 6)|VBM_PORT_32);
	testmem(index, "PORT_32", 0);
	afcww(&vbmatm_reg[index], 0x0002|(VBM_AM_EXT << 6)|VBM_PORT_16);
	testmem(index, "PORT_16", 1);
	afcww(&vbmatm_reg[index], 0x0002|(VBM_AM_EXT << 6)|VBM_PORT_32);
	testmem(index, "PORT_32", 1);
	afcww(&vbmatm_reg[index], (VBM_AM_EXT << 6)|VBM_PORT_16);
	testmem(index, "PORT_16", 2);
	afcww(&vbmatm_reg[index], (VBM_AM_EXT << 6)|VBM_PORT_32);
	testmem(index, "PORT_32", 2);
}

testmem(index, port, am)
char *port;
{
	unsigned long addr;
	register i, j;

	addr = VBM_BASE(index);
	if (am == 1)
		addr += 0x7f00000;
	else if (am == 2)
		addr += MEMADDR;

	for (j = 0 ; j < 3 ; j++) {
		if (j == 0)
   			for (i = 0 ; i < 4 ; i++) 
				onepass(addr+i, j, port, am, index);
		else if(j == 1)
   			for (i = 0 ; i < 2 ; i++) 
				onepass(addr+i, j, port, am, index);
		else 
				onepass(addr, j, port, am, index);
	}
}

/*
 * am = 0  for STD
 * am = 1  for EXT tanslated by VDMA
 * am = 2  for EXT non translated
 */
onepass(addr, size, port, am, index)
char *port;
{
	register j, vact, mact, pat, off, paddr;
	char *acc, *amc,hex_addr[68];

	if (am == 0)
		amc = "AM_STD";
	else
		amc = "AM_EXT";

	if (size == 0)
		acc = "long";
	else if (size == 1)
		acc = "word";
	else
		acc = "byte";
	
	if (go_no_go) {
		sprintf(hex_addr,"(%d) %s at %a, %s, %s",index,amc,addr,acc,port);
		bs_20(hex_addr);
	}
	else
		printf("     Testing %s VMEADDR=0x%x, %s access, %s\n",
	     						amc, addr, acc, port);

	off = addr & (vdma_space -1);
	paddr = MEMADDR + (addr & (vdma_space -1));
	if (size == 0) {
		pat = 0xDEADBEEF;
		for (j = 0 ; (off + j + 3) < vdma_space && (! rd_keybd()); j += 4)
			*(long *)(addr + j) = pat;
		for (j = 0 ; (off + j + 3) < vdma_space  && (! rd_keybd()); j += 4) {
			mact = *(long *)(paddr + j);
			vact = *(long *)(addr + j);
			if ((vact != pat) || (mact != pat))
				verror(pat,vact,mact,acc, port, addr+j, paddr+j);
		}
	} else if (size == 1) {
		pat = 0xBEEF;
		for (j = 0 ; (off + j + 1) < vdma_space  && (! rd_keybd()); j += 2)
			*(short *)(addr + j) = pat;
		for (j = 0 ; (off + j + 1) < vdma_space  && (! rd_keybd()); j += 2) {
			mact = *(unsigned short *)(paddr + j);
			vact = *(unsigned short *)(addr + j);
			if ((vact != pat) || (mact != pat))
				verror(pat,vact,mact,acc, port, addr+j, paddr+j);
		}
	} else {
		pat = 0xBF;
		for (j = 0 ; (off + j) < vdma_space  && (! rd_keybd()); j++)
			*(char *)(addr + j) = pat;
		for (j = 0 ; (off + j) < vdma_space  && (! rd_keybd()); j++) {
			mact = *(unsigned char *)(paddr + j);
			vact = *(unsigned char *)(addr + j);
			if ((vact != pat) || (mact != pat))
				verror(pat,vact,mact,acc, port, addr+j, paddr+j);
		}
	}
}

verror(pat, vact, mact, acc, port, vaddr, paddr)
char *acc, *port;
{
	printf("ERROR: %s, %s access, vaddr=0x%x, paddr=0x%x\n", 
		port, acc, vaddr, paddr);
	printf("       EXP=0x%x, VACT=0x%x, MACT=0x%x\n", pat, vact, mact);
	errcnt++;
}


rd_keybd()
{
	register	char	c;

	if(keybd_intr){
	   c = keybd_intr;
	   keybd_intr = 0;	
	   longjmp(vdma,c);
	}
	return(0);
}


/**************** EOF *******************/
