#include "saio.h"
#include "sais68k.h"

#define	BUFSIZE 0x400

char line[80];
long buf1[BUFSIZE], buf2[BUFSIZE];

main()
{
	register int i, io, iter, error;

	printf("Integrated Solutions VmeBackplane Test\n");

	printf("Make sure the remote bootd is started with -w,\n");
	printf("and the remote file has the write permission.\n");

	while (1) {
		printf("Remote file: ");
		gets(line);
		striplwhite(line);
		if ((io = open(line, 2)) < 0) {
			printf("Cant access remote file\n");
			continue;
		}
		iter = 1;
		error = 0;
		while (1) {
			for (i = 0 ; i < BUFSIZE ; i++) {
				buf1[i] = rand();
				buf2[i] = 0xDEADBEEF;
			}
			lseek(io, 0, 0);
			if (write(io, buf1, sizeof buf1) != sizeof buf1) {
				printf("write failed\n");
				break;
			}
			lseek(io, 0, 0);
			if (read(io, buf2, sizeof buf2) != sizeof buf2) {
				printf("read failed\n");
				break;
			}
			for (i = 0 ; i < BUFSIZE ; i++) {
				if (buf1[i] != buf2[i]) {
					error++;
printf("ERROR: INDEX=0x%x, ADDR=0x%x, EXP=0x%X, ACT=0x%x\n%s\n", 
					i*4, &buf2[i],buf1[i], buf2[i],
					"PRESS <CR> TO CONTINUE");
					gets(line);
				}
			}
			printf("%d iterations, %d errors\n", iter++, error);
			if (getlocal())
				break;
		}
		close(io);
	}
}
