#include "saio.h"
#include "sais68k.h"
#include "saboot.h"
#include "../is68kif/if_ring.h"
#include "../is68kif/if_vbreg.h"

#define	VBVADDR	0x500000	/* KLUDGE !!! kernel virtual address */
#define	HMTIMEOUT	60	/* timeout value for host share memory */
static struct ma	*map = ((struct ma *)VBVADDR);

#define splhigh(x)	0	/* dummy */
#define splx(x)		0	/* dummy */

static struct ring *freeringp, *inputringp, *outputringp;


extern u_char		broaddr[6];	/* Ethernet broadcast address */
u_char			vbme[6];	/* Ethernet address of this machine */
u_char			vbhost[6];	/* Ethernet address of host machine */
struct boot_packet	vb_rcv;
struct boot_packet	vb_xmt;
int			vbsend();
int			vbpkid;
struct st		vbst = {512, -1, -1, -1, -1, NULL};

#define	VBDELAY	5000
#define	VBWAIT(y, z, t)	{ register int i = VBDELAY; 		\
				    if (t)				\
					*(int *)t = 0;			\
				    else				\
					i *= 20;			\
				    while (y) {			\
				    	if (getlocal() == 'x')		\
						return(vbabort(z));	\
				    	else if (--i == 0)		\
					    if (t) { 			\
						*(int *)t = 1;		\
						break;			\
					    } else			\
						return(vbtimeout(z));\
					DELAY(250);			\
				    }					\
				}
vbopen(io)
	register struct iob *io;
{
	register struct boot_packet *bp;
	register struct bcb *bcbp;
	register struct hmmagic *hmp;
	short s;
	int timeout;
	register j;

	if (io->i_unit >= 1 || vbnum <= 0) {
vbnp:		printf("vb: not present\n");
		return -1;
	}
	mapin(map, (struct ma *)VBPHYS0, VBSIZE0);
	if (!probe(map, &s)) {
#if	defined(M68025) || defined(M68030)
		hmp = (struct hmmagic *)VME_EXTENDED;
		if (!probe(hmp, &s))
			goto emem;
		for (j = 0 ; j < HMTIMEOUT ; j++) {
			VBWAIT(hmp->hm_magic != HMMAGIC, 0, &timeout);
			if (timeout)
				continue;
		}
		if (j >= HMTIMEOUT)
			goto emem;
		mapin(map, (struct ma *)((u_int)hmp + hmp->hm_base), VBSIZE0);
#else	defined(M68025) || defined(M68030)
		goto emem;
#endif	defined(M68025) || defined(M68030)
	}

	map->ma_icpu.ic_active[vbnum] = VB_INACTIVE;
	if (vbjoin() <= 0)
		goto emem;
	vbpkid = 0;
	io->i_st = vbst;

	freeringp = ItoKv(map->ma_icpu.ic_freeringp, struct ring *, map);
	inputringp = ItoKv(map->ma_icpu.ic_inputringp[vbnum], struct ring *, map);
	outputringp = ItoKv(map->ma_icpu.ic_inputringp[0], struct ring *, map);

	/* flush any input */
	while(bcbp = (struct bcb *)vbringget(inputringp))
		vbringput(freeringp, bcbp);

	/* Get Ethernet address.  */
	bcopy(map->ma_icpu.ic_ethaddr, vbhost, 6);
	bcopy(vbhost, vbme, 6);
	ICPUX(vbme) = vbnum;

	if (netopen(vbsend, io, &vb_xmt, &vb_rcv, &vbpkid, vbme, vbhost)) {
		vbclosering();
		return -1;
	}
	return 0;

  emem:	printf("vb: not present\n");
	mapin(map, (struct ma *)VBVADDR, VBSIZE0);
	return -1;
}

vbclose(io)
	register struct iob *io;
{
	int err;

	err = netclose(vbsend, io, &vb_xmt, &vb_rcv, &vbpkid, vbme, vbhost);
	vbclosering();
	return err;
}

/* clear active, flush input, and unmap */
vbclosering()
{
	register struct bcb *bcbp;

	if (map->ma_icpu.ic_active[vbnum]) {
		map->ma_icpu.ic_active[vbnum] = VB_INACTIVE;
		while( bcbp = (struct bcb *)vbringget(inputringp))
			vbringput(freeringp, bcbp);
	}
	mapin(map, (struct ma *)VBVADDR, VBSIZE0);
}

vbstrategy(io, func)
	register struct iob *io;
{
	return netstrategy(vbsend, io, func, &vb_xmt, &vb_rcv, &vbpkid, 
		vbme, vbhost);
}

vbsend(io, bpx, bpr, pkidp)
	struct iob *io;
	register struct boot_packet *bpx, *bpr;
	int *pkidp;
{
	register struct bcb *bcbp;
	register int retry = 0, rcv = 21;
	int timeout;

	do {
	    if (rcv++ > 20) {
		rcv = 0;
		if ((vbxmit(io, bpx) == 0) || (retry++ > 40))
			goto lost;
	    }
	    do {
		VBWAIT((bcbp = (struct bcb *)vbringget(inputringp)) == 0,
			0, &timeout);
		if (timeout && ((retry++ > 40) || (vbxmit(io, bpx) == 0)))
			goto lost;
	    } while (timeout);
	    ItoK(bcbp, struct bcb *, map);
	    bzero(bpr, sizeof(struct boot_packet));
	    bcopy(ItoKv(bcbp->b_addr, char *, map), bpr, bcbp->b_len);
	    KtoI(bcbp, struct bcb *, map);
	    VBWAIT(vbringput(freeringp, bcbp) == 0, 1, 0);
	} while (bcmp(bpr->bp_eh.ether_dhost, broaddr, 6) == 0 || 
		 bpr->bp_eh.ether_type != ETHERTYPE_ISIBOOT ||
		 bpr->bp_pkid != *pkidp );
	bpx->bp_cmd = bpr->bp_cmd;
	*pkidp = (*pkidp) + 1;
	return 1;
lost:	printf("vb: lost connection\n");
	return 0;
}

vbxmit(io, bpx)
	struct iob *io;
	register struct boot_packet *bpx;
{
	register struct bcb *bcbp;

	VBWAIT((bcbp = (struct bcb *)vbringget(freeringp)) == 0, 2, 0);
	ItoK(bcbp, struct bcb *, map);
	bcopy(bpx, ItoKv(bcbp->b_addr,char *,map), sizeof(struct boot_packet));
	bcbp->b_len = sizeof(struct boot_packet);
	KtoI(bcbp, struct bcb *, map);
	VBWAIT(vbringput(outputringp, bcbp) == 0, 3, 0);
	return 1;
}

vbjoin()
{
	register unsigned char *p = &map->ma_icpu.ic_active[0];

	*p = VB_INACTIVE;
	VBWAIT(*p != VB_ACTIVE, -1, 0);
	if (map->ma_icpu.ic_inputringp[vbnum]  &&  tas(&p[vbnum])) {
		p[vbnum] = VB_ACTIVE;
		return 1;
	}
	printf("vb: busy\n");
	return -1;
}

vbtimeout(x)
{
	printf("vb: timeout %d\n", x);
	return(x >= 0 ? 0 : -1);
}

vbabort(x)
{
	printf("vb: abort %d\n", x);
	return(x >= 0 ? 0 : -1);
}

#include "../is68kif/if_vbring.c"
