#define	BRAIN_DAMAGED_QIC2
/*
 * NOTE: problem with command packets not being
 * in 18 bit address land resolved via KLUDGE.
 */
/*	ts.c	6.1	83/07/29	*/

/*
 * TS11 tape driver
 */
#include "saio.h"
#include "sais68k.h"
#include "../dev/tsreg.h"

#define TS_MAXCNT	0xF000

struct tsdevice	*tsstd[] = { 
#define	NTS	3
	(struct tsdevice *)&vme_stdio[0xFFF550], 
	(struct tsdevice *)&vme_stdio[0xFFF520],
	(struct tsdevice *)&vme_stdio[0xFFF540]
};

int			sadie_blocksize;
struct st 		tsst = { 512, -1, -1, -1, -1, NULL};
int			ts_bn;
char			ts_opened;
struct ts {
	struct ts_cmd	*ts_cmd;
	struct ts_char	ts_char;
	struct ts_sts	ts_sts;
} 			ts;

struct	iob	ctsbuf;
struct ts *ts_qbaddr;
unsigned long ts_cmd_qbaddr;

tsopen(io)
	register struct iob *io;
{
	register struct tsdevice *tsaddr = tsstd[io->i_unit];
	int i;

	if (io->i_unit >= NTS || !probe(&tsaddr->tssr, &i)) {
		printf("ts: controller not present\n");
		goto err;
	}
	
	tsaddr->tssr = TSSR_RESET;
	DELAY(200);
	if ((tsaddr->tssr & TS_NBA) == 0)
		goto err;

	tswait(tsaddr);				/* wait for system ready */
	tsaddr->tssr = TSSR_RESET;		/* reset */
	if (tswait(tsaddr)){
		printf("got err from tswait\n");
		goto err;
	}
	if (ts_qbaddr == NULL) {
		ctsbuf.i_ma = (long) &ts;
		ctsbuf.i_cc = sizeof(ts);
		ts_qbaddr = (struct ts *)(VDMA_STD(qbsetup(&ctsbuf, 1),vbnum));
		ctsbuf.i_ma = (long)(0x400 +
			(sizeof (struct ts_cmd) * io->i_unit)); /*KLUDGE*/
		ctsbuf.i_cc = sizeof(struct ts_cmd) * NTS;
		ts_cmd_qbaddr = VDMA_STD(qbsetup(&ctsbuf, 1),vbnum);
	}

	/* set up characteristics data */
	ts.ts_cmd = (struct ts_cmd *)(0x400 + 
			(sizeof (struct ts_cmd) * io->i_unit)); /*KLUDGE*/
	i = paddr(&ts_qbaddr->ts_sts);
	ts.ts_char.char_ladr = loword(i);
	ts.ts_char.char_hadr = hiword(i);
	ts.ts_char.char_size = sizeof(ts.ts_sts);
	ts.ts_char.char_mode = TS_ESS;
	ts.ts_char.ext_char_mode = TS_WRB;
	/* set up command data */
	i = paddr(&ts_qbaddr->ts_char);
	ts.ts_cmd->c_cmd = TS_ACK|TS_CVC|TS_SETCHR;
	ts.ts_cmd->c_loba = loword(i);
	ts.ts_cmd->c_hiba = hiword(i);
	ts.ts_cmd->c_size = sizeof(ts.ts_char);
	if (tswait(tsaddr))
		goto err;
	tsaddr->tssr = hiword(ts_cmd_qbaddr) & 0xFF;
	tsaddr->tsdb = (int)ts_cmd_qbaddr;
	if (tswait(tsaddr))
		goto err;

	if (tsaddr->tssr&TS_OFL) {
		printf("ts: offline\n");
		goto err;
	}
	if (tscommand(tsaddr, TS_REW, 0, 0, 1))
		goto err;
	if (io->i_boff && (io->i_flgs&F_BLKOFF) == 0) {
		if (tscommand(tsaddr, TS_SFORWF, 0, io->i_boff, 1))
			goto err;
		io->i_boff = 0;
	}
	ts_bn = 0;
	if (sadie_blocksize)
		tsst.nbsec = sadie_blocksize;
	else {
	    ctsbuf.i_ma = 0x800;
	    ctsbuf.i_cc = TS_MAXCNT;
	    if (tscommand(tsaddr, TS_RCOM, VDMA_STD(qbsetup(&ctsbuf, 0),vbnum),
			 TS_MAXCNT, 1)) /* KLUDGE */
		tsst.nbsec = 512;
	    else
		tsst.nbsec = TS_MAXCNT - ts.ts_sts.s_rbpcr;
	    if (tscommand(tsaddr, TS_SREV, 0, 1, 1))
		goto err;
	}
	io->i_cc = 0;
	ts_opened = 1;
	io->i_st = tsst;
	return (0);
   err:	return(-1);
}

tsclose(io)
	register struct iob *io;
{
	register struct tsdevice *tsaddr = tsstd[io->i_unit];

	if (ts_opened) {
		ts_opened = 0;
		return (tscommand(tsaddr, TS_REW, 0, 0, 0));
	}
	return (-1);
}

tscommand(tsaddr, func, addr, count, wait)
	register struct tsdevice *tsaddr;
{
	if ((func & TS_WCOM) == TS_RCOM || (func & TS_WCOM) == TS_WCOM) {
		ts.ts_cmd->c_size = count;
		ts.ts_cmd->c_loba = loword(addr);
		ts.ts_cmd->c_hiba = hiword(addr);
	} else
		ts.ts_cmd->c_repcnt = count;
	ts.ts_cmd->c_cmd = TS_ACK|TS_CVC|func;
	tsaddr->tssr = hiword(ts_cmd_qbaddr) & 0xFF;
	tsaddr->tsdb = (int)ts_cmd_qbaddr;
	if (wait)
		return (tswait(tsaddr));
	else
		return (0);
}

tsstrategy(io, func)
	register struct iob *io;
{
	register struct tsdevice *tsaddr = tsstd[0];
	register int bn = io->i_bn;
	register int errcnt;
	register int cmd;
	register int bpart, bleft;
	register long qbinfo;

	if (bn != ts_bn) {
		if (bn > ts_bn)
			tscommand(tsaddr, TS_SFORW, 0, bn-ts_bn, 1);
		else {
#ifndef	BRAIN_DAMAGED_QIC2
			tscommand(tsaddr, TS_SREV, 0, ts_bn-bn, 1);
#else	BRAIN_DAMAGED_QIC2
			tscommand(tsaddr, TS_SREVF, 0, 1, 1);
			tscommand(tsaddr, TS_SFORW, 0, bn, 1);
#endif	BRAIN_DAMAGED_QIC2
		}
		if (tsaddr->tssr & TS_SC ) {
			printf("ts: bad seek\n");
			return (-1);
		}
	}
	ts_bn = bn;
	errcnt = 0;
	bleft = io->i_cc;

	do {
		bpart = tsst.nbsec;
		if (func == READ)
			cmd = TS_RCOM;
		else {
			cmd = TS_WCOM;
			printf("ts: can`t write\n");
			return (-1);
		}
		ctsbuf.i_ma = io->i_ma;
		ctsbuf.i_cc = bpart;
	        qbinfo = VDMA_STD(qbsetup(&ctsbuf, 0),vbnum);
retry:		if (tswait(tsaddr))
			return (-1);
		if (tscommand(tsaddr, cmd, qbinfo, bpart, 1))
			return (-1);
		if (ts.ts_sts.s_xs0 & TS_TMK)
			return (io->i_cc - bleft);
		if (tsaddr->tssr & TS_SC ) {
			printf("ts: error er=%b xs0=%b\n",tsaddr->tssr,
				TSSR_BITS, ts.ts_sts.s_xs0, TSXS0_BITS);
			if (errcnt==10) {
				printf("ts: unrecovered error\n");
				return (-1);
			}
			errcnt++;
			cmd |= TS_RETRY;
			goto retry;
		}
		if (errcnt)
			printf("ts: recovered\n");
		bpart -= ts.ts_sts.s_rbpcr;
		io->i_ma += bpart;
		ts_bn++;
		bleft -= bpart;
	} while (bleft > 0);
	return (io->i_cc);
}

tswait(tsaddr)
	register struct tsdevice *tsaddr;
{
	register int i;
	short sr;
	
	DELAY(400);
	for (i = 800000; i ; i--)
		if (probe(&tsaddr->tssr, &sr) && (sr & TS_SSR) != 0)
			break;
		else
			DELAY(400);
	if (i == 0) {
		printf("ts: timeout\n");
		return (-1);
	}
	return (0);
}
