#define NPROMS		2
#define PROMSIZE	128
/*
 * How to split a file for burning a 27128 (32K x 8) prom:
 *
 *	          a.out		
 *		 \  V  /
 *		  \   /
 *		   | |
 *		_________
 *		| strip |
 *		---------
 *		   | |
 *		_________
 *		| prom  |
 *		| split |
 *		---------
 *	   /--------^--------\
 *	   |     |     |     |
 *	  LOLO  LOHI  HILO  HIHI
 *	   |     |     |     |
 *	-------------------------
 *	| hex | hex | hex | hex |
 *	-------------------------
 *	   |     |     |     |
 *	  lolo  lohi  hilo  hihi
 *
 *
 * File names reflect <order of prom><address in file>:
 *
 *			LOW PROM	HI  PROM
 *		file:   +------+        +------+
 *		      0:|      |      1:|      |
 *			| LOLO |	| HILO |
 *		 0x1FFE:|      | 0x1FFF:|      |
 *			+------+	+------+
 *		 0x2000:|      | 0x2001:|      |
 *			| LOHI |	| HIHI |
 *		 0x3FFE:|      | 0x3FFF:|      |
 *			+------+	+------+
 *
 * How to burn a set of 27128 (32K x 8) proms:
 *	In the following description steps designated with a 'M' are 
 *	manual, steps with an '*' designate what to key into the prom
 *	burner, and steps with an 'H' tell you what to type in on the host.
 *	
 *  1)	M Set type to B.
 *  2)	M Set size to 64K (2764).
 *  3)	M Power on prom burner, connect to a terminal on a host machine.
 *  4)	* reset.
 *  5)	* Fn E0 Enter 02 Enter.	(Select data format: Exorcisor)
 *  6)	* Fn E3 Enter 01 Enter.	(Select number of stop bits: 1)
 *  7)	M Place the LOW 27128 prom in socket, pin 1 (notch) up, pull lever down.
 *  8)	M Set 128K (27128, AM28) adaptor switch to LOWER.
 *  9)	* In Enter.
 * 10)	H type in "cat LOLO > /dev/tty?"
 * 11)	* (beeps when done).
 *
 * 12)	* Program
 * 13)	* (beeps when done).
 *
 * 14)	* Reset
 * 15)	M Set 128K (27128, AM28) adaptor switch to UPPER.
 * 16)	* In Enter.
 * 17)	H type in "cat LOHI > /dev/tty?"
 * 18)	* (beeps when done).
 *
 * 19)	* Program
 * 20)	* (beeps when done).
 *
 * 21)	* Reset
 * 22)	* Remove the LOW 27128 prom from adaptor, it is cooked.
 * 23)	M Place the HI 27128 prom in socket, pin 1 (notch) up, pull lever down.
 * 24)	M Set 128K (27128, AM28) adaptor switch to LOWER.
 * 25)	* In Enter.
 * 26)	H type in "cat HILO > /dev/tty?"
 * 27)	* (beeps when done).
 *
 * 28)	* Program
 * 29)	* (beeps when done).
 *
 * 30)	* Reset
 * 31)	M Set 128K (27128, AM28) adaptor switch to UPPER.
 * 32)	* In Enter.
 * 33)	H type in "cat LOHI > /dev/tty?"
 * 34)	* (beeps when done).
 *
 * 35)	* Program
 * 36)	* (beeps when done).
 *
 * 37)	* Reset
 * 38)	* Remove the HI 27128 prom from adaptor, it is cooked.
 * 39)	M Party
 */

#include <stdio.h>
#include <a.out.h>
#include <sys/file.h>

struct exec	header;

union x {
	short	i_int;
	struct bytes {
		unsigned char	c_hi;
		unsigned char	c_lo;
	} 	c_bytes;
} x;
#define PROMBITS(x)	(x*1024)
#define PROMBYTES(x)	(PROMBITS(x)/8)
#define Open(u,f)	if((u = open(f,O_CREAT+O_TRUNC+O_WRONLY,0640)) < 0) {  \
				printf("psplit: cannot open %s\n",f);	  \
				return;					  \
			} else
main()
{
	int	i, imagesize, pindx, end;
	int	lolo, lohi, hilo, hihi;

	if (read(0,&header,sizeof(header)) != sizeof(header)) {
		printf("psplit: cannot read header\n");
		return;
	}

	if (header.a_magic != OMAGIC) {
		printf("psplit: can only split 407 files\n");
		return;
	}

	imagesize = header.a_text + header.a_data;

	if (imagesize > NPROMS*PROMBYTES(PROMSIZE) ) {
		printf("psplit: image size %d will not fit in %d 27%d proms\n",
			imagesize,NPROMS,PROMSIZE);
		return;
	} else
		printf("psplit: %d%% of available space used\n",
			(imagesize * 100) / (NPROMS*PROMBYTES(PROMSIZE)) );

	Open(lolo,"lolo");
	Open(lohi,"lohi");
	Open(hilo,"hilo");
	Open(hihi,"hihi");

	end = imagesize < PROMBYTES(PROMSIZE) ? imagesize : PROMBYTES(PROMSIZE);

	/*
	 * do low addresses in hi and low prom 
	 */
	for (i = pindx = 0; i < end ; i = i + 2, pindx = pindx + 2) {
		if (read(0,&x.i_int,2) != 2) {
			printf("psplit: read error\n");
			return;
		}
		if (write(lolo,&x.c_bytes.c_lo,1) != 1 ) {
			printf("psplit: lolo write error\n");
			return;
		}
		if (write(hilo,&x.c_bytes.c_hi,1) != 1 ) {
			printf("psplit: hilo write error\n");
			return;
		}
	}

	end = (imagesize-pindx) < PROMBYTES(PROMSIZE) ? (imagesize-pindx) : 
		PROMBYTES(PROMSIZE);

	/*
	 * do hi addresses in hi and low prom 
	 */
	for (i = 0; i < end ; i = i + 2, pindx = pindx + 2) {
		if (read(0,&x.i_int,2) != 2) {
			printf("psplit: read error\n");
			return;
		}
		if (write(lohi,&x.c_bytes.c_lo,1) != 1 ) {
			printf("psplit: lohi write error\n");
			return;
		}
		if (write(hihi,&x.c_bytes.c_hi,1) != 1 ) {
			printf("psplit: hihi write error\n");
			return;
		}
	}
}
