#include <a.out.h>

struct exec header;

main(argc, argv)
	int	argc;
	char	*argv[];
{
	int	i;
	int	oldentry, newentry;

	if (argc != 3) {
		printf("usage: chentry file address\n");
		exit(1);
	}
	sscanf(argv[2], "%x", &newentry);

	if ((i = open(argv[1],2,0)) < 0 ) {
		printf("chentry: cannot open '%s'\n",argv[1]);
		exit (1);
	}
	if (read(i, &header, sizeof(header)) != sizeof(header)) {
		printf("chentry: cannot read header\n");
		exit (1);
	}
	if (N_BADMAG(header)) {
		printf("chentry: not in a.out format\n");
		exit (1);
	}

	oldentry = header.a_entry;
	header.a_entry = newentry;

	if (lseek(i, 0, 0) < 0) {
		printf("chentry: cannot seek back to begining of file\n");
		exit (1);
	}
	if (write(i, &header, sizeof(header)) != sizeof(header)) {
		printf("chentry: cannot write header\n");
		exit (1);
	}
	printf("chentry: old entry=0x%x, new entry=0x%x\n",oldentry,newentry);
}
