
#include "../h/types.h"
#include "saio.h"
#include "../dev/sioreg.h"

int clock;

#define devtoblk(x)	((x)/ NCPB)
#define devtochan(x)	((x)% NCPB)

struct siochan 	 	*sio_addr[NSIO];
struct sioblock 	*blk_addr[NBLOCKS];

extern	long dorte;
static int	timerhdlr();
extern int	ignore_intr, tperr();
extern short	scr;

int	intr_cnt, tick_flg, strt_time, el_time;

#ifdef	PROMDIAG
extern int	go_no_go;
	p_timer()
#else
int go_no_go = 0;
	main()
#endif
{
	register unsigned char c;
	static	char	str[24];
	printf("\n--- %i Standalone SIO TIMER Diagnostics --- (%s)\n",
					time_str(read_time()) );
	bs_20("");				/* initilize the back space counter */
	if(! go_no_go)	printf("\n The test blinks leds every second.    ");
	dorte = 1;
	ignore_intr = 1;		/* ignore the first interrupt */
	_splx(0x2000);
	rupt_enable();
	ignore_intr = 0;
	_splx(0x2700);

	set_vec(TIMER_VECT, timerhdlr);
	timerinit();
	intr_cnt = 0;
	clock = 0;

	while (1) {
		if(tick_flg) {
			tick_flg = 0;
 		 	if(go_no_go)
				bs_20((scr & SCR_LED_OFF) ? "OOO" : "***");
			else{
				sprintf(str," %s error rate%4d",
                        (scr & SCR_LED_OFF) ? "OOO" : "***",
				  		100 - (intr_cnt)*100/el_time);
				bs_20(str);
			}
		}
		c = getlocal();
		if (c == '' || c == '')	{
			timer_reset();
			printf("^%c",(c== '')? 'C' :'D');
			return (1);
		}
#ifdef	PROMDIAG
		if( (go_no_go) && (clock>300) && (100-(intr_cnt)*100/el_time) == 0 ){
			timer_reset();
			bs_20("** Passed **");
			return (0);
		} 
#endif	PROM_DIAG
	}
}

timer_reset()
{
	_splx(0x2700);
	rupt_disable();
	/* turn the timmer interrupt enable off */
	afcrb(&blk_addr[RTCOUNTER]->blk_ct_stop);
}

timerhdlr()
{
	if ((clock++ % 60) == 0) {
		_blink_errled();
		if (! intr_cnt++) strt_time = read_time() -1;
		else {
			el_time = read_time() - strt_time;
			tick_flg++;
		}
	}
}


/* Sio initialization */
timerinit()
{
	register chan = devtochan(RTCOUNTER);
	register blk = devtoblk(RTCOUNTER);
	register int i, b, c, opcr, acr;
	struct s2698device *p;
	unsigned short interval = CLOCKPERIOD;
	
	p = (struct s2698device *)OCTART_ADDR;
	for (i = 0 ; i < NSIO; i++)
		if (devtochan(i) == 0)
			sio_addr[i] = &p->s2698_block[devtoblk(i)].blk_chana;
		else
			sio_addr[i] = &p->s2698_block[devtoblk(i)].blk_chanb;

	while ((afcrb(&sio_addr[chan]->chan_sr_csr)&SR_TXEMT) == 0);

	afcwb(&sio_addr[chan]->chan_cr,	CR_DISABLE_TX | CR_DISABLE_RX);
	for (i = 0 ; i < NBLOCKS; i++) {
		blk_addr[i] = &p->s2698_block[i];
		afcrb(&blk_addr[i]->blk_ct_stop);
		afcwb(&blk_addr[i]->blk_isr_imr, 0);
		afcwb(&blk_addr[i]->blk_ipcr_acr, ACR_BRGS);
	}

	opcr = OPCR_MOPA_CTO | OPCR_MOPB_RTSN;
	acr =  ACR_BRGS | ACR_MPI0A_INT | ACR_MPI0B_INT | ACR_TIMER_CLK;
	
	afcwb(&blk_addr[RTCOUNTER]->blk_ipr_opcr, opcr);
	afcwb(&blk_addr[RTCOUNTER]->blk_ipcr_acr, acr);

	afcwb(&blk_addr[RTCOUNTER]->blk_ctu,hibyte(interval));
	afcwb(&blk_addr[RTCOUNTER]->blk_ctl,lobyte(interval));
	afcrb(&blk_addr[RTCOUNTER]->blk_ct_go); 	

	afcwb(&sio_addr[chan]->chan_cr,	CR_ENABLE_TX | CR_ENABLE_RX);

/*
printf("\nM1 = %x",afcrb(&sio_addr[chan]->chan_mr12));
printf("\nM2 = %x",afcrb(&sio_addr[chan]->chan_mr12));
printf("\nSR = %x\n",afcrb(&sio_addr[chan]->chan_sr_csr));
*/
	_splx(0x2000);

}

#ifndef	PROMDIAG
#endif	PROMDIAG
