#include "../machine/board.h"

static int	softint();
extern	long dorte;
extern	int ignore_intr, tperr();
extern	short scr;
int	cnt = 0;


#ifdef	PROMDIAG
extern int go_no_go;
	p_softint()
#else
int go_no_go = 0;
	main()
#endif
{
	register unsigned char c;
	register int strt;

	printf("\n--- %i Standalone SOFTWARE INTERRUPT Diagnostics --- (%s)\n",
					time_str(read_time()) );
	bs_20("");				/* initilize the back space counter */
	if(! go_no_go) {
		printf("\n The LEDS toggle on each occurance of a software %s",
													"interrupt.  ");
		printf("\n Press any key to generate a software interrupt.   ");
	}
	dorte = 1;
	ignore_intr = 1;
	_splx(0x2000);
	rupt_enable();
	ignore_intr = 0;

	set_vec(SOFT_VECT, softint);
	cnt = 0;

	/* start test loop */
	while (1) {
		set_softint();
		if(go_no_go) {
			strt = read_time();
			for(; read_time() - strt <=1;);
			c = getlocal();
		} else
		 	c = wgetlocal();

		if(c == '' || c == '' || cnt >= 4){
			softoff();
  			if(cnt >= 4) {
				bs_20("** Passed **");
				return(0);
			}
			else { 	
				printf("^%c\n",(c== '')? 'C' :'D');
				return (1);
			}
		}
	}
}

softint()
{
	clear_softint();
	_blink_errled();
	if (go_no_go) cnt++;
	bs_20((scr & SCR_LED_OFF) ? "OOO" : "***");
}

softoff()
{
	clear_softint();
	rupt_disable();
	_splx(0x2700);
	set_vec(TIMER_VECT, tperr);
}
