
#include "../h/types.h"
#include "../machine/board.h"
#include "../dev/sioreg.h"

extern long dorte;
char buf[80];
char rupton;


#define devtoblk(x)	((x)/ NCPB)
#define devtochan(x)	((x)% NCPB)

struct siochan 	 	*sio_addr[NSIO];
struct sioblock 	*blk_addr[NBLOCKS];

int	sioint();
unsigned char c;
int 	p;


#ifdef	PROMDIAG
	p_siotest()
#else
	main()
#endif
{
	register unsigned char c;
	int *vb, *getvb();

	printf("\n--- %i Standalone SIO Diagnostics ---\n\n");
	printf(" All ports are configured to 9600 baud, 8bit No parity\n");
	rupton = 1;
	dorte = 1;
	set_vec(SIO_VECT, sioint);
	rupt_enable();
	sioinit();
	_splx(0x2000);
	while (1) { ;
#ifdef	PROMDIAG
		if(getlocal() == '\004') {
			printf("^D\n");
			return;
		}
#endif	PROMDIAG
	}
}

/* Sio initialization */
sioinit()
{
	register int i, opcr, cr, j;
	struct s2698device *p;
	
	p = (struct s2698device *)OCTART_ADDR;
	for (i = 0 ; i < NSIO; i++)
		if (devtochan(i) == 0)
			sio_addr[i] = &p->s2698_block[devtoblk(i)].blk_chana;
		else
			sio_addr[i] = &p->s2698_block[devtoblk(i)].blk_chanb;

	for (i = 0 ; i < NBLOCKS; i++) {
		blk_addr[i] = &p->s2698_block[i];
		afcwb(&blk_addr[i]->blk_ipcr_acr, ACR_MPI0A_INT|ACR_MPI0B_INT);
		afcrb(&blk_addr[i]->blk_ct_stop);

		if (rupton)
			afcwb(&blk_addr[i]->blk_isr_imr, 
			   IMR_MPI_PORT_CHANGE|IMR_CHANA_RXRDY|IMR_CHANB_RXRDY);
		else
			afcwb(&blk_addr[i]->blk_isr_imr, 0);

		if (i)
			opcr = OPCR_MOPA_RTSN | OPCR_MOPB_RTSN;
		else
			opcr = OPCR_MOPA_CTO | OPCR_MOPB_RTSN;
		afcwb(&blk_addr[i]->blk_ipr_opcr, opcr);

		afcwb(&sio_addr[i * NCPB + 0]->chan_cr, 
		    CR_CMD_RST_MR|CR_DISABLE_TX|CR_DISABLE_RX);
		afcwb(&sio_addr[i * NCPB + 0]->chan_mr12, 
		    MR1_8_BIT|MR1_PAR_NONE);
		afcwb(&sio_addr[i * NCPB + 0]->chan_mr12, MR2_1_STOP);
		afcwb(&sio_addr[i * NCPB + 0]->chan_sr_csr, 0xbb);
		afcwb(&sio_addr[i * NCPB + 0]->chan_cr,
	    	    CR_CMD_RST_MR|CR_ENABLE_TX|CR_ENABLE_RX);
		if (i)
			afcwb(&sio_addr[i*NCPB+0]->chan_cr,CR_CMD_RTSN_ASSERT);

		afcwb(&sio_addr[i * NCPB + 1]->chan_cr, 
		    CR_CMD_RST_MR|CR_DISABLE_TX|CR_DISABLE_RX);
		afcwb(&sio_addr[i * NCPB + 1]->chan_mr12, 
		    MR1_8_BIT|MR1_PAR_NONE);
		afcwb(&sio_addr[i * NCPB + 1]->chan_mr12, MR2_1_STOP);
		afcwb(&sio_addr[i * NCPB + 1]->chan_sr_csr, 0xbb);
		afcwb(&sio_addr[i * NCPB + 1]->chan_cr,
	    	    CR_CMD_RST_MR|CR_ENABLE_TX|CR_ENABLE_RX);
		afcwb(&sio_addr[i * NCPB + 1]->chan_cr,CR_CMD_RTSN_ASSERT);
	}
}

sioint()
{
        register u_char isr;
        register i;
        register char ipcr, ipr;

        for (i = 0 ; i < NBLOCKS ; i++) {
                isr = afcrb(&blk_addr[i]->blk_isr_imr);
                if (isr & ISR_CHANA_RXRDY)
                        siorint(i * NCPB);
                if (isr & ISR_CHANB_RXRDY)
                        siorint(i * NCPB + 1);
                if (isr & ISR_MPI_PORT_CHANGE) {
                        ipcr = afcrb(&blk_addr[i]->blk_ipcr_acr);
                        ipr = afcrb(&blk_addr[i]->blk_ipr_opcr);
                        if (ipcr & IPCR_DELTA_MPI0A)
                                siocint(i * NCPB, ipcr & CHANADCD);
                        if (ipcr & IPCR_DELTA_MPI0B)
                                siocint(i * NCPB + 1, ipcr & CHANBDCD);
                }
        }
}

siorint(unit)
{
        register struct siochan *sioaddr = sio_addr[unit];
        register u_int c;

	c = afcrb(&sioaddr->chan_rhr_thr);
	afcwb(&sioaddr->chan_rhr_thr, c);
}

siocint(unit, on)
{
	printf("Port change interrupt on unit %d\n", unit);
}


