#include "../dev/sioreg.h"
#include "nvram.QX.h"

#define NDUCHANS	2	/* Set to 2 to use B aswell */
#define	CHANNEL0_VECTOR	0x8c	/* gives vectors in the range 0x88 to 0x8e */
#define	CHANNEL1_VECTOR	0x94	/* gives vectors in the range 0x90 to 0x95 */
#define RXBUFSIZE	8	/* Receive buffer size */
#define TXBUFSIZE	12	/* Transmit buffer size*/


#define NDUSCCS 2

struct dusccchan *duaddr[NDUSCCS] =
{
    (struct dusccchan *) 0x01000100,
    (struct dusccchan *) 0x01000120
};

short btbl[] = {
    6, 		/* 9600 BAUD default */
    48, 	/* 1200		BAUD*/
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    24,		/* 2400		BAUD*/
    24,
    6,		/* 9600		BAUD*/
    6,
    3, 		/* 19200	BAUD*/
    3
};

duscc_init ()
{
    register int i, cnt, speed = 13;
    register struct dusccchan *du;
    struct nv_ram nvram;

    for (cnt = 0; cnt < NDUSCCS; cnt++) {
	du = duaddr[cnt];

	du->du_ccr = DU_CCR_DISABL_TX;
	du->du_ccr = DU_CCR_DISABL_RX;
	du->du_ccr = DU_CCR_CT_STOP;
	du->du_pcr = DU_PCR_X2_CRYS | DU_PCR_GPO2 | DU_PCR_SY_RTS | 
	    DU_PCR_RTxC_INPUT | DU_PCR_TRxC_INPUT;
	du->du_cmr1 = DU_CMR1_NRZ | DU_CMR1_PRTY_NONE | DU_CMR1_ASYNC;

	du->du_ttr = DU_TTR_CLK_32xOWN_CT;
	du->du_rtr = DU_RTR_CLK_CT;

	du->du_omr = DU_OMR_TxRDY_EMPTY | DU_OMR_RxRDY_NEMPT | DU_OMR_GPOUT1 | 
	    DU_OMR_RTS;

	du->du_ctcr = DU_CTCR_0_DTCT_PRESET | DU_CTCR_1_SCALE | DU_CTCR_4CLK;

	du->du_ier = DU_IER_TSR7_3 | DU_IER_RXRDY;

	du->du_tpr = DU_TPR_TX_8BITS | DU_TPR_1STOP | DU_TPR_TX_CTS;

	du->du_rpr = DU_RPR_RX_8BITS | DU_RPR_STRIP_PRTY | DU_RPR_DCD_ENBL_RX;

	if (getram (&nvram) < 0)   	/* parity error in nv ram */
	    speed = 13;			/* set baud to 9600 */
	else 
	    speed = nvram.sio[cnt] & 0xf;
	du->du_ctprh = btbl[speed] >> 8;
	du->du_ctprl = btbl[speed];

	du->du_ccr = DU_CCR_CT_PRST;
	du->du_ccr = DU_CCR_CT_START;

	/* bug fix */
	du->du_cmr2 = DU_CMR2_CONN_LOOP | DU_CMR2_POLLED | DU_CMR2_NO_FCS;
	du->du_ccr = DU_CCR_RST_TX;
	du->du_ccr = DU_CCR_ENBL_TX;
	for (i = 100; --i > 0;);
	du->du_ccr = DU_CCR_DISABL_TX;
	/* end of bug fix */

	du->du_cmr2 = DU_CMR2_CONN_NORM | DU_CMR2_POLLED | DU_CMR2_NO_FCS;
	du->du_ccr = DU_CCR_RST_TX;
	du->du_ccr = DU_CCR_ENBL_TX;

	du->du_ccr = DU_CCR_RST_RX;
	du->du_ccr = DU_CCR_ENBL_RX;
    }
}

put_du (dev, c)
char c;
{
	register struct dusccchan *addr;
	register char	rdychr;
	register short	s;

	addr = duaddr [dev];
	if (addr == (struct dusccchan *) 0x01000100)
		rdychr = DU_GSR_A_TXRDY;
	else
		rdychr = DU_GSR_B_TXRDY;

	if ((addr->du_gsr & rdychr) == 0) {
		return(0);
	}
	else {
		addr->du_txfifo = (char)c;
		return(1);
	}
}

get_du (dev)
{
	register struct dusccchan *addr;
	register char c, stat, rdychr;
	register int	s;

	addr = duaddr [dev];
	rdychr = (dev == 0 ? DU_GSR_A_RXRDY : DU_GSR_B_RXRDY);

	if ((addr->du_gsr & rdychr) == 0) {
		return (0);
	}
	c = addr->du_rxfifo; /* read data BEFORE reset error */
	stat = addr->du_rsr & (DU_RSR_FRM_ERR | DU_RSR_PRTY_ERR);
	addr->du_rsr = stat; /* reset the frm and parity error bits. */
	return(c);
}


int		getchar(), putchar();
int             (*putch) () = putchar;
int             (*getch) () = getchar;

#define CTLQ     0x11
#define CTLS     0x13
static char lochar = 0, rmchar = 0;

int		putslow=0;
int		autoboot=0;

getchar ()
{
	register int c;

	c = wgetlocal();
	if (c == '\r')
		wputlocal('\n');
	putchar(c);
	return c;
}

putchar (c)
register int c;
{
	if (autoboot)
		return;
	wputlocal(c);
	if (c == '\n')
		wputlocal('\r');
}

wgetremote()
{
	register int c;

	while ((c = getremote()) == 0) ;
	return(c);
}

wgetlocal()
{
	register int c;

	while ((c = getlocal()) == 0) ;
		return(c);
}

wputlocal(c)
{
	register int ic;

	if ((ic = getloc()) != 0) {
		if (ic == CTLS)
			while (getloc() != CTLQ) ;
		else if (ic != CTLQ)
			lochar = ic;
	}
	while (putlocal(c) == 0) ;
}

wputremote(c)
{
	register int ic;

	if ((ic = getrem()) != 0) {
		if (ic == CTLS)
			while (getrem() != CTLQ) ;
		else if (ic != CTLQ)
			rmchar = ic;
	}

	while (putremote(c) == 0) ;
}

getremote()
{
	register char c;

	if (rmchar) {
		c = rmchar;
		rmchar = 0;
		return(c);
	} else
		return(getrem());
}

getlocal()
{
	register char c;

	if (lochar) {
		c = lochar;
		lochar = 0;
		return(c);
	} else
		return(getloc());
}

putlocal(c)
char c;
{
	putslow = 0;
	if (putloc(c) == 0)
		return 0;
#define QX_GIP
#ifdef 	QX_GIP
	g_putc(c);		/* graphics putc */
#endif 	QX_GIP
#ifdef	QX_QGRAPH
	con_putc(c);		/* graphics putc */
#endif 	QX_QGRAPH
	return 1;
}

getloc(x)
{
	register int c;

#ifdef 	QX_QGRAPH
	if (c = con_getc())	/* get char from graphics kbd */
	    return (c & 0x7F);	/* if available */
#endif 	QX_QGRAPH

	c = get_du(0);
	return(c & 0x7F);
}

putloc(c)
char c;
{
	if (put_du(0, c) == 0)
		return 0;
	return 1;
}

getrem()
{
	register int	c;

	c = get_du(1);
	return(c & 0x7F);
}

putremote(c)
char c;
{
	register int i;

	if (put_du(1, c) == 0)
		return (0);
	if (putslow)
		DELAY(2000);
	return(1);
}
