/*
 * Stand-alone  -- setjmp, longjmp
 *
 *	longjmp(a,v)
 * will generate a "return(v)" from
 * the last call to
 *	setjmp(a)
 * by restoring registers from the stack,
 * previous signal mask, and doing a return.
 *
 */

#define	ENTRY(x)	.globl _/**/x; .align 1; _/**/x:

ENTRY(setjmp)
	movl	sp@+,a1			/* return address */
	movl	sp@,a0			/* jmpbuf */
	movml	#<d2-d7,a2-a7>,a0@
	movl	a1,a0@(12*4)		/* return pc */
	movl	#0,d0			/* zero return value */
	jmp 	a1@			/* return */

ENTRY(longjmp)
	movl	sp@(4),a0		/* jmpbuf */
	movl	sp@(8),d1		/* get return value */
	movl	a6,d0			/* save fp in case we panic */
	movml	a0@+,#<d2-d7,a2-a6>
	movl	a0@+,a1			/* to be new sp */
	cmpl	sp,a1			/* must be a pop */
	jge 	1f
	pea	msgend-msg
	pea	msg
	pea	2
	jsr	_write
	stop	#0				/* die here */

1:	movl	a1,sp
	movl	a0@,a1			/* return pc */
	movl	d1,d0			/* get return value */
	/*movl	a0,d0			/* nonzero return value */
	jmp 	a1@			/* return */

	.data
msg:	.ascii	"longjmp botch\n"
msgend:
