
/*
 * header file for the SEEQ 8003 Ethernet Data Link Controller as used on the
 * Torch QX.
 * March 1987 C M Bowley, Torch Computers Ltd.
 */

struct seeq8003 {
	char sq_stataddr[6];
	char sq_rxstcm;		/* reads status, writes command register */
	char sq_txstcm;		/* ditto */
};

#define	SEEQ_ADDR	((struct seeq8003 *)0x1000168)
/*
 * the next define is the address of the DMA data register.
 */
#define	SEEQ_RX_DMA	((char *)0x1000158)
#define	SEEQ_TX_DMA	((char *)0x1000160)

/*
 * defines for the transmit command/status registers.
 */
#define SQ_TX_OLD	0x80
#define	SQ_TX_SUCCESS	0x08
#define SQ_TX_16_ATMPT	0x04
#define SQ_TX_COLL	0x02
#define SQ_TX_UNDERFLW	0x01

/*
 * defines for the receive command/status registers. The top two bits of these
 * registers do not correspond so there are multiple defines for them.
 */
#define SQ_RX_OLD	0x80

#define SQ_RX_RCV_DSBL	0x00	/* disable receiver */
#define SQ_RX_RCV_ALL	0x40	/* receive all frames */
#define SQ_RX_RCV_SEL	0x80	/* receive selected station and broadcast frames */
#define SQ_RX_RCV_SMLT	0xc0	/* receive station, broadcast and multicast frames */

#define	SQ_RX_GOOD_FRM	0x20
#define	SQ_RX_END_FRAME	0x10
#define	SQ_RX_SHORT	0x08
#define SQ_RX_DRIBBLE	0x04
#define SQ_RX_CRC	0x02
#define SQ_RX_OVFL	0x01
