/*
 * Standalone driver for the ISI SCSI/ADAPTEC host adaptor disk controller.
 */
#include "saio.h"
#include "sais68k.h"
#include "../dev/sdreg.h"

#define	SDADDR0	  	((struct sddevice *)&vme_stdio[0xFFFFE0])
#define	SDADDR1	  	((struct sddevice *)&vme_stdio[0xFFFFF0])

#define	SD_CN		2			/* number of controllers */
#define	SD_DR		4			/* drives per controller */
#define	UTOCN(x)	((x) >> 2)
#define	UTODR(x)	((x) & 3)
#define	SD_MAXCNT	0x1F000			/* must be multiple of nbsec */

struct sddevice *sdstd[SD_CN] = { SDADDR0, SDADDR1};

int forbb, xbad144, xbad144_soft, sdstrat();

sdopen(io)
	register struct iob *io;
{
	register int			cn = UTOCN(io->i_unit); 
	register int 			dr = UTODR(io->i_unit);
	register struct sddevice 	*sdaddr;

	if (dr >= SD_DR || cn >= SD_CN) {
		printf("sd: bad unit\n");
		return (-1);
	}
	sdaddr = sdstd[cn];
	if (!probe(&sdaddr->sdba,&sdaddr->sdba)) {
		printf("sd: not present\n");
		return (-1);
	}
	if (sdwait(sdaddr))
		return (-1);
	sdaddr->sdcs = (dr<<8) | SD_SIZE | SD_CBSY;
	if (sdwait(sdaddr) || (sdaddr->sdcs & SD_ERR) || (sdaddr->sdda == 0) ||
	    (sdaddr->sdcs == ((dr<<8)|SD_SIZE|SD_CBSY)))
		return (-1);
	io->i_st.nsect = sdaddr->sdwc;
	io->i_st.ntpc = sdaddr->sdda;
	io->i_st.nspc = io->i_st.nsect * io->i_st.ntpc;
	io->i_st.nbsec = sdaddr->sdba;
	io->i_st.ncyl = sdaddr->sdae;
	io->i_st.off = NULL;
/*	printf("(%dx%dx%d)\n",io->i_st.nsect,io->i_st.ntpc,io->i_st.ncyl); /**/
	if ((io->i_boff = diskpart(io)) < 0) {
		printf("sd: bad offset\n");
		return (-1);
	}
	return(0);
}

sdstrategy(io, func)
	register struct iob *io;
{
	register int			bleft, 
					bpart;
	register int 			bn = io->i_bn;
	register int 			dr = UTODR(io->i_unit);

	switch (func) {
	  case READ:
		func = SD_READ; 
		break;
	  case WRITE:
		func = SD_WRITE; 
		break;
	  default:
		printf("sd%d: bad func 0x%x\n", io->i_unit, func);
		return -1;
	}
	bleft = io->i_cc;	/* byte cnt */
	do {
		bpart = (bleft < SD_MAXCNT) ? bleft : SD_MAXCNT;
		if (forbb) {
			if (sdstrat(io,bn,bpart,func) == -1)
				return -1;
			io->i_ma += bpart;
		} else if (badstrat(io,bn,bpart,func,sdstrat,SD_READ) == -1)
			return -1;
		bleft -= bpart;
		bn += bpart / io->i_st.nbsec;
	} while (bleft > 0);
	return io->i_cc;
}

sdstrat(io,bn,bpart,func)
	register struct iob *io;
	register int bn;
	int bpart, func;
{
	register int 			cn = UTOCN(io->i_unit);
	register int 			dr = UTODR(io->i_unit);
	register struct sddevice 	*sdaddr = sdstd[cn];
	int	 			errcnt = 0;
	register unsigned long		qbinfo;

	while (1) {
		sdaddr->sdda = bn;
		qbinfo = VDMA_STD(qbsetup(io, 0),vbnum);
		sdaddr->sdba = qbinfo;
		sdaddr->sdae = ((bn >> 8) &0xFF00) | ((qbinfo >> 16) & 0xFF);
		sdaddr->sdwc = bpart >> 1;
		sdaddr->sdcs = dr<<8 | func | SD_CBSY;
		if (sdwait(sdaddr)) {
			printf("sd%d: HUNG sn=%d ",io->i_unit,bn);
			printf("cs=%b sw=%x %x %x\n",
				sdaddr->sdcs, SDCS_BITS, sdaddr->sdsw[0], 
				sdaddr->sdsw[1], sdaddr->sdsw[2]);
			return (-1);
		}
		if (sdaddr->sdcs & SD_ERR) {
			printf("sd%d: sn=%d cs=%b sw=%x %x %x\n", io->i_unit, 
				bn, sdaddr->sdcs, SDCS_BITS, sdaddr->sdsw[0], 
				sdaddr->sdsw[1], sdaddr->sdsw[2]);
			if (!xbad144 && ++errcnt < 5)
				continue;
			errcnt = 0;
			return -1;
		}
		return 0;
	}
}

sdwait(sdaddr)
	register struct sddevice *sdaddr;
{ 	
	register int l = 0;

	DELAY(700);
	while (sdaddr->sdcs == 0xffff) 
		if (++l == 50000) {
			printf("sd: timeout\n");
			return (-1);
		} else
			DELAY(700);
	return (0);
}

#ifdef	DISK_FORMAT
struct	sdfmt_param	{
	u_char	rsvd1[3];
	u_char	extent_desc_len;
	u_char	density_code;
	u_char	rsvd2[5];
	u_short	block_size;
	u_char	list_format_code;
	u_char	cylinder_count[2];
	u_char	head_count;
	u_short	reduce_write_cyl;
	u_short	write_precomp_cyl;
	u_char	landing_zone;
	u_char	step_pulse_rate;
	u_short	rsvd3;
	u_short	n_blocks;
	u_short	rsvd4;
	u_short	len_defects;
};

struct	sdfmt_defects {
	u_char	cylinder[3];
	u_char	head;
	u_int	byteoffset;
};

static char buf[100];

sdformat()
{
	register struct sddevice *sdaddr;
	register struct sdfmt_param *p;
	register struct sdfmt_defects *d;
	register int i, n;
	int nheads, ncyl, fc;
	char test;
	u_short drive;

	printf("\nFormatting SD disk\n");
loop:	printf("\nFunctions available:\n");
	printf("  a) Format Disk\n  b) Display Parameter and Defect list\n");
	printf("Enter letter of desired function ('H' for help): ");
	stripwhite(gets(buf));
	test = buf[0];
	if (test == 'H')
		goto loop;
	if (test != 'a' && test != 'A' && test != 'b' && test != 'B')
		goto loop;
cntlr:  printf("Controller number (0-%d) ? ",SD_CN-1);
	stripwhite(gets(buf));
	i = getnum(buf);
	if (i < 0 || i >= SD_CN) {
		printf("illegal controller number\n");
		goto cntlr;
	}
	sdaddr = sdstd[i];
	if (!probe(&sdaddr->sdba,&sdaddr->sdba)) {
		printf("controller %d at 0x%x not present\n", i, sdaddr);
		goto cntlr;
	}
drv:    printf("Drive number (0-%d) ? ",SD_DR-1);
	stripwhite(gets(buf));
	drive = getnum(buf);
	if (drive < 0 || drive >= SD_DR) {
		printf("illegal drive number\n");
		goto drv;
	}
	drive = ((drive<<8) & 0x0300) | SD_CBSY | SD_FORMAT;

	if (test == 'a' || test == 'A') {
	hd:	printf("Number of heads ? ");
		stripwhite(gets(buf));
		nheads = getnum(buf);
		if (nheads > 16 || nheads < 1)
		    goto hd;
	cyl:	printf("Number of cylinders ? ");
		stripwhite(gets(buf));
		ncyl = getnum(buf);
		if (ncyl > 2048 || ncyl < 20)
		    goto cyl;
		fc = (nheads-1)<<11 | (ncyl-1);
		printf(" Estimated time until completion is ");
		printf("%d hours and %d min\n",
		    ((nheads*ncyl)/100)/60,((nheads*ncyl)/100)%60);
		printf("format constant = %x, ok ? ",fc);
		stripwhite(gets(buf));
		if (buf[0] != 'y' && buf[0] != 'Y')
		    return;
		sdaddr->sdda = fc;
		sdaddr->sdcs = drive;
		while (sdaddr->sdcs == 0xFFFF) {
		    DELAY(2000);
		    printf(".");
		    DELAY(2000);
		    printf(".");
		    DELAY(2000);
		    printf(".");
		    DELAY(2000);
		    printf(".");
		    DELAY(2000);
		    printf("\r     \r");
		}
		if (sdaddr->sdcs & SD_ERR) {
		    printf("DRIVE DID NOT FORMAT\n");
		    printf("sd: cs=%b sw=%x %x %x\n",
			    sdaddr->sdcs, SDCS_BITS, sdaddr->sdsw[0], 
			    sdaddr->sdsw[1], sdaddr->sdsw[2]);
		} else
		    printf("SUCCESSFUL FORMAT\n");
	} else if (test == 'b' || test == 'B') {
		sdaddr->sdda = 0x8000;		/* read parameter/defect list */
		sdaddr->sdcs = drive;
		p = (struct sdfmt_param *)0x1000;
		d = (struct sdfmt_defects *)0x101E;
		if (sdwait(sdaddr) || sdaddr->sdcs & SD_ERR) {
		    printf("sd: cs=%b sw=%x %x %x\n",
			    sdaddr->sdcs, SDCS_BITS, sdaddr->sdsw[0], 
			    sdaddr->sdsw[1], sdaddr->sdsw[2]);
		    printf("cannot read bad track map\n");
		    return;
		}
		printf("%x: %d 	extent_desc_len\n", 
			    &p->extent_desc_len, p->extent_desc_len);
		printf("%x: %d 	density_code\n", 
			    &p->density_code, p->density_code);
		printf("%x: %d 	block_size\n", 
			    &p->block_size, p->block_size);
		printf("%x: %d 	list_format_code\n", 
			    &p->list_format_code, p->list_format_code);
		printf("%x: %d 	cylinder_count\n",
			    &p->cylinder_count[0],
			    p->cylinder_count[0]<<8|p->cylinder_count[1]);
		printf("%x: %d 	head_count\n", 
			    &p->head_count, p->head_count);
		printf("%x: %d 	reduce_write_cyl\n", 
			    &p->reduce_write_cyl, p->reduce_write_cyl);
		printf("%x: %d 	write_precomp_cyl\n", 
			    &p->write_precomp_cyl, p->write_precomp_cyl);
		printf("%x: %d 	landing_zone\n", 
			    &p->landing_zone, p->landing_zone);
		printf("%x: %d 	step_pulse_rate\n", 
			    &p->step_pulse_rate, p->step_pulse_rate);
		printf("%x: %d 	n_blocks\n", 
			    &p->n_blocks, p->n_blocks);
		printf("%x: %d 	len_defects\n", 
			    &p->len_defects, p->len_defects);
		n = p->len_defects/sizeof(struct sdfmt_defects);
		printf("	%d defects\n",n);
		if (n == 0)
		    return;
		printf("Hit RETURN for list of DEFECTS: ");
		gets(buf);
		printf("	#	CYL  	HEAD	OFFSET\n");
		for (i = 0 ; i < n ; i++) {
		    printf("%x:	%d	%d", d, i, 
		    d->cylinder[0]<<16|d->cylinder[1]<<8|d->cylinder[2]);
		    printf("	%d	%d\n",d->head,d->byteoffset);
		    d++;
		    DELAY(10000);
		}
	}
	goto loop;
}
#endif	DISK_FORMAT
