/* ISI: $Header: sais68k.h,v 5.2 88/11/11 12:17:24 ray Exp $ */
/*	sais68k.h	6.1	83/07/29	*/

/*
 * Standalone definitions peculiar to is68k.
 */

#define setjmp(x)	_setjmp(x)
#define longjmp(x,y)	_longjmp(x,y)

extern int 		cpu;		/* see <sys/cpu.h> */
extern short		cpusw;		/* CPU Switches */
extern int		cpuchip;	/* Type of CPU chip 680?0 */
extern int		vbnum;		/* Cluster node number */
#ifdef	VBUS
extern char		vme_short[];	/* VME shortio address space */
extern char		vme_std[];	/* VME standard address space */
extern char		vme_stdio[];	/* VME standard io address space */
extern char		vme_ext[];  	/* VME extended address space */
extern short	vbmatm_reg[];	/* map registers */
#endif	VBUS

#if defined(M68020) || defined(M68030)
#define	mapin(v,p,n)	v = p
#endif	M68020

#ifdef	QX
#define	RAM_BASE	0x04000000
#else	QX
#define	RAM_BASE	0x00000000
#endif	QX
#define	LINEBUF		(RAM_BASE + 0x700)
#define	LINELEN		0x100

#ifdef	QX
#define	VME_WINDOW	0x04000000
#define	hibusaddr(x)	(((((int)x)-VME_WINDOW) >> 16) & 0x0000ffff)
#define	lobusaddr(x)	((((int)x)-VME_WINDOW)         & 0x0000ffff)
#else	QX
#define	hibusaddr(x)	hiword(x)
#define	lobusaddr(x)	loword(x)
#endif	QX
