
/*
 * addresses of output ports 1 and 2.
 */
#define Q_OP_PORT1	(*(char *)0x1000148)
#define Q_OP_PORT2	(*(char *)0x1000150)

/*
 * The DATIN signal is read through the DUSCC chip GPI2B input.
 */
#define	DATIN	(((struct dusccchan *)0x1000100)[1].du_ictsr & DU_ICTS_GPI2)

/* Values that may be written to output ports 1 and 2 */

#define OP1_RES_VIDSEL0 0
#define OP1_SET_VIDSEL0 1
#define OP1_RES_VIDSEL1 2
#define OP1_SET_VIDSEL1 3
#define OP1_RES_PALSEL0 4
#define OP1_SET_PALSEL0 5
#define OP1_RES_PALSEL1 6
#define OP1_SET_PALSEL1 7
#define OP1_RES_TURNOFF 8
#define OP1_SET_TURNOFF 9
#define OP1_RES_VIDSTOP 10
#define OP1_SET_VIDSTOP 11
#define OP1_RES_RESFIFO 12		/* reset fifo */
#define OP1_SET_RESFIFO 13		/* enable fifo */
#define OP1_RES_RESSCSI 14		/* enable SCSI */
#define OP1_SET_RESSCSI 15		/* reset SCSI */

#define OP2_RES_DATOUT 0		/* serial data */
#define OP2_SET_DATOUT 1
#define OP2_RES_STROBE 2		/* serial clock */
#define OP2_SET_STROBE 3
#define OP2_RES_TIMSEL 4		/* disable clock */
#define OP2_SET_TIMSEL 5		/* enable clock */
#define OP2_RES_RAMSEL 6		/* disable nv-RAM */
#define OP2_SET_RAMSEL 7		/* enable nv-RAM */
#define OP2_RES_KEYRESET 8		/* enable kb */
#define OP2_SET_KEYRESET 9		/* reset kb */
#define OP2_RES_ETHER	12		/* reset LANCRES, reset Ethernet */
#define OP2_SET_ETHER	13		/* set LANCRES, enable Ethernet */
