
struct eth_desc {
	unsigned char *et_dptr;
	struct eth_desc *et_next;
	short et_bufsiz;	/* size of buffer */
	short et_datsiz;	/* number of data bytes */
	short et_flags;
};

#define ET_OWN	0x0001	/* set for MPU ownership, reset otherwise */
#define	ET_STP	0x0002	/* start of frame */
#define	ET_ENP	0x0004	/* end of frame */

/*
 * These error bits are extracted from an Ethernet chip receive status
 * byte but shifted over by 4 bits. The ET_SHRT error may also appear for a
 * transmit frame if the MPU attempts to transmit a frame less than 60 bytes
 * in length.
 */
#define	ET_OVFL	0x0008	/* receive buffer to small to hold received frame */
#define ET_OVER	0x0010	/* overflow on received frame */
#define ET_CRC	0x0020	/* received frame had CRC error */
#define ET_NOCT	0x0040	/* received frame didn't end with a complete octet */
#define ET_SHRT	0x0080	/* undersized frame */

#define ET_UNDR	0x0100	/* underrun on transmit */
#define ET_COLL	0x0200	/* collision on transmit */
#define ET_TX16	0x0400	/* 16 transmission attempts */
