#include "saio.h"
#include "sais68k.h"
#include "saboot.h"
#include "qxether.h"
#include "openchip.h"
#include "nvram.QX.h"

extern int      ignore_intr;

#define	NQE	1
/* #define	DEBUG	/**/

extern u_char   broaddr[6];	/* Ethernet broadcast address */
static struct nv_ram	nv_ram;
u_char          *qxme = &nv_ram.enet_addr[0];
u_char          qxhost[6];	/* Ethernet address of host machine */
struct boot_packet qx_rcv;
struct boot_packet qx_xmt;
int             qxsend();
int             qxpkid;
struct st       qxst = {512, -1, -1, -1, -1, NULL};

struct eth_desc *eth_rx();


qxopen(io)
	register struct iob *io;
{
	register int    stat;

	if (io->i_unit >= NQE) {
		printf("qx: not present\n");
		return -1;
	}
	qxpkid = 0;
	io->i_st = qxst;

	if (getram(&nv_ram)) {
		printf("non-volatile ram error:  can't get ethernet address\n");
		return(-1);
	}
#ifdef	DEBUG
	printf("qxopen, calling eth_init\n");
#endif	DEBUG
	stat = eth_init(nv_ram.enet_addr, 2);
	return netopen(qxsend, io, &qx_xmt, &qx_rcv, &qxpkid, qxme, qxhost);
}

qxclose(io)
	register struct iob *io;
{
	int             err;

	err = netclose(qxsend, io, &qx_xmt, &qx_rcv, &qxpkid, qxme, qxhost);
	return err;
}

qxstrategy(io, func)
	register struct iob *io;
{
	return netstrategy(qxsend, io, func, &qx_xmt, &qx_rcv, &qxpkid,
			   qxme, qxhost);
}

qxsend(io, bpx, bpr, pkidp)
	struct iob     *io;
	register struct boot_packet *bpx, *bpr;
	int            *pkidp;
{
	register int    retry = 0, w, rcv = 21;
	int             i;
	struct eth_desc *qx_packet;

	do {
		if (getlocal() != 0)
			goto lost;
		if (rcv++ > 20) {
			rcv = 0;
			if (retry++ > 40)
				goto lost;
			qxxmit(io, bpx);
		}
		/*
		 * wait for response. 
		 */
		while ((qx_packet = eth_rx()) == 0) {
			switch ((int) qx_packet) {
			case OC_PROBLEM:
				printf("qxsend OP_PROBLEM\n");
				goto lost;
				break;
			case 0:
				break;
			default:
				printf("qxsend rcv'd at 0x%x\n", qx_packet);
				break;
			}
		}
		/*
		 * Copy the packet release the buffer.
		 */
		bcopy(qx_packet->et_dptr, bpr, sizeof(struct boot_packet));
		eth_rerx(qx_packet);
	} while (bcmp(bpr->bp_eh.ether_dhost, broaddr, 6) == 0 ||
		 bpr->bp_eh.ether_type != ETHERTYPE_ISIBOOT ||
		 bpr->bp_pkid != *pkidp);
#ifdef	DEBUG
	show_packet("r ", bpr);
#endif	DEBUG
	bpx->bp_cmd = bpr->bp_cmd;
	*pkidp = (*pkidp) + 1;
	return 1;
lost:	printf("qx: lost connection\n");
	return 0;
}

qxxmit(io, bpx)
	struct iob     *io;
	register struct boot_packet *bpx;
{
	int             x;
#define	QE_BP_SZ (sizeof(struct boot_packet) - sizeof(struct ether_header))

	while (1) {
#ifdef	DEBUG
		show_packet("x ", bpx);
#endif	DEBUG
		x = eth_tx(&(bpx->bp_pkid), QE_BP_SZ,
			   bpx->bp_eh.ether_dhost, ETHERTYPE_ISIBOOT);
		switch (x) {
		case SUCCESS:
			return (1);
		case INVALID:
			printf("qxxmit: INVALID\n");
			return (0);
		case FAILED:
			printf("qxxmit waiting for free buffer\n");
			break;
		case OC_PROBLEM:
			printf("qxxmit: OC_PROBLEM\n");
			return (0);
		}
	}
}

#include "seeq8003.h"
#include "qxoutport.h"

char            etaddr[6] = {0, 0, 0, 0, 0, 0};
char            bcastaddr[6] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

#define NRXDESC		4	/* No. of rx descriptors in our ring */
#define NTXDESC		2	/* No. of tx descriptors in our ring */
#define NDESC	(NRXDESC+NTXDESC)	/* Total no. of ethernet descriptors */
#define ETHBUFSIZE	1516	/* Max. eth. rx/tx buffer size	     */

/* The following array defines enough space for NDESC descriptors on 16 byte */
/* boundaries. The etinit() routine sets up basedesc to point to the first of */
/* these. */

#define ETHDESCSZAL	(((sizeof (struct eth_desc)) + 15) & ~15)

union padded_eth_desc {
	struct eth_desc coke;	/* a cryptic comment; (C) DMG */
	char            pad[ETHDESCSZAL];
};

char            etspace[NDESC * sizeof(union padded_eth_desc) + 15];
struct eth_desc *etrxring;	/* Ptr to rx descriptor ring */
struct eth_desc *ettxring;	/* Ptr to tx descriptor ring */

/* The ethernet buffers must be quad byte aligned; the following array */
/* is big enough for NDESC correctly aligned buffers. */

char            etbufspace[NDESC * ETHBUFSIZE + 3];

/*
 * Initialise the ethernet interface. The address is given by the parameter   
 * which gets copied to 'etaddr'.
 */

eth_init(addr, rcvclass)
	char           *addr;
{
	register unsigned char *etbufptr;
	register union padded_eth_desc *dp, *basedesc;
	register struct openchip *oc = OPENCHIP;
	register struct seeq8003 *sq = SEEQ_ADDR;
	register        i;
	char            dummy;

	Q_OP_PORT2 = OP2_RES_ETHER;	/* assert the reset line */

	basedesc = (union padded_eth_desc *) ((15 + (int) etspace) & ~15);
	etrxring = (struct eth_desc *) (&basedesc[0]);
	ettxring = (struct eth_desc *) (&basedesc[NRXDESC]);

	etbufptr = (unsigned char *) ((3 + (int) etbufspace) & ~3);

	/*
	 * Initialise the transmit descriptor ring
	 */
	for (dp = (union padded_eth_desc *) ettxring, i = 0;
	    i < NTXDESC; i++, dp++) {
		dp->coke.et_dptr = etbufptr;
		dp->coke.et_next = (struct eth_desc *) (dp + 1);
		dp->coke.et_flags = ET_OWN;	/* owned by MPU */
		dp->coke.et_bufsiz = ETHBUFSIZE;
		etbufptr += ETHBUFSIZE;
	}
	dp--;
	dp->coke.et_next = ettxring;	/* Close the ring */

#ifdef	DEBUG
	printf ("(1) ettxring->et_flags = 0x%x\n",ettxring->et_flags);
#endif	DEBUG

	/*
	 * Initialise the receive descriptor ring
	 */
	for (dp = (union padded_eth_desc *) etrxring, i = 0;
	    i < NRXDESC; i++, dp++) {
		dp->coke.et_dptr = etbufptr;
		dp->coke.et_next = (struct eth_desc *) (dp + 1);
		dp->coke.et_flags = 0;		/* owned by OpenChip */
		dp->coke.et_bufsiz = ETHBUFSIZE;
		etbufptr += ETHBUFSIZE;
	}
	dp--;
	dp->coke.et_next = etrxring;	/* Close the ring */

#ifdef	DEBUG
	printf ("(2) ettxring->et_flags = 0x%x\n",ettxring->et_flags);
#endif	DEBUG

	Q_OP_PORT2 = OP2_SET_ETHER;	/* de-assert the reset line */

	/*
	 * Initialise the OpenChip ethernet status registers
	 */

	oc->op_ethrstat = OP_ETH_ACT | OP_ETH_EVNT | OP_ETH_ERR;
	oc->op_ethtstat = OP_ETH_ACT | OP_ETH_EVNT | OP_ETH_ERR;
	sq->sq_rxstcm = SQ_RX_RCV_DSBL;
	/*
	 * perform a delay, 13.6 microseconds.
	 */
	for (i = 40; --i > 0;);

	/*
	 * flush any buffered data out of the receive buffer. 
	 */
	for (i = 16; --i > 0;)
		dummy = *SEEQ_RX_DMA;

	/*
	 * Read the ethernet status to make sure they are clear 
	 */
	dummy = sq->sq_rxstcm;
	dummy = sq->sq_txstcm;

	/*
	 * load the Ethernet address into the chip. 
	 */
	for (i = 0; i < 6; i++)
		sq->sq_stataddr[i] = etaddr[i] = *addr++;

	/*
	 * restart the OpenChip. 
	 */
	oc->op_ethrstat = 0;		/* Note interrupts disabled */
	oc->op_ethtstat = 0;
	oc->op_ethrx = etrxring;	/* Set the rx.ring ptr	 */

	/*
	 * restart the Ethernet chip. 
	 */
	sq->sq_txstcm = SQ_TX_SUCCESS|SQ_TX_16_ATMPT|SQ_TX_COLL|SQ_TX_UNDERFLW;

	/*
	 * value of rcvclass implies:
	 * 1 == all good frames
	 * 2 == all good frames to this address & broadcast
	 * 3 == all good frames to this address & broadcast & multicast
	 * 4 == all frames including errors
	 */
	switch (rcvclass) {
	case 1:
		sq->sq_rxstcm = SQ_RX_RCV_ALL|SQ_RX_GOOD_FRM|SQ_RX_END_FRAME;
		break;
	case 2:
		sq->sq_rxstcm = SQ_RX_RCV_SEL|SQ_RX_GOOD_FRM|SQ_RX_END_FRAME;
		break;
	case 3:
		sq->sq_rxstcm = SQ_RX_RCV_SMLT|SQ_RX_GOOD_FRM|SQ_RX_END_FRAME;
		break;

	case 4:
		sq->sq_rxstcm = SQ_RX_RCV_ALL|SQ_RX_GOOD_FRM|SQ_RX_END_FRAME
		    |SQ_RX_SHORT|SQ_RX_CRC|SQ_RX_DRIBBLE|SQ_RX_OVFL;
		break;

	default:
		return INVALID;
	}

	return SUCCESS;
}

eth_tx(dptr, n, address, type)
	register unsigned char *dptr, *address;
{
	register struct eth_desc *dp;
	register unsigned char *bp;
	register int    i;

	if (n > ETHBUFSIZE - 14)/* 14 = 12 bytes addr, 2 bytes type */
		return INVALID;
	dp = ettxring;
	if (dp->et_flags & ET_OWN) {
		ettxring = ettxring->et_next;	/* The ring moves on */

		bp = dp->et_dptr;	/* Register ptr to ethernet buffer */
		for (i = 0; i < 6; i++)	/* Add in the destination address */
			*bp++ = *address++;
		for (i = 0; i < 6; i++)	/* Add in the source address */
			*bp++ = etaddr[i];
		*bp++ = type >> 8;	/* Add in the type field */
		*bp++ = type;
		while (n-- > 0)	/* Add in the users data */
			*bp++ = *dptr++;
		dp->et_datsiz = bp - dp->et_dptr;	/* Set the buffer size */
		dp->et_flags = ET_STP | ET_ENP;	/* Kick off tx */

#ifdef	DEBUG
		printf ("Before kicking off transmission:\n");
		printf("dp = 0x%x\n", dp);
		printf ("dp->et_dptr = 0x%x\n", dp->et_dptr);
		printf ("dp->et_datsiz = %d\n", dp->et_datsiz);
		printf ("dp->et_bufsiz = %d\n", dp->et_bufsiz);
		printf ("dp->et_flags = %d\n", dp->et_flags);
		printf ("op_ethtstat = 0x%x\n", OPENCHIP->op_ethtstat);
#endif	DEBUG

		OPENCHIP->op_ethtx = dp;

#ifdef	DEBUG
		if (OPENCHIP->op_ethtstat & OP_ETH_ERR)
			printf("OP_ETH_ERR set\n"); 
#endif	DEBUG

#ifdef	DEBUG
		printf ("After kicking off transmission:\n");
		printf ("dp = 0x%x\n", dp);
		printf ("dp->et_dptr = 0x%x\n", dp->et_dptr);
		printf ("dp->et_datsiz = %d\n", dp->et_datsiz);
		printf ("dp->et_bufsiz = %d\n", dp->et_bufsiz);
		printf ("dp->et_flags = %d\n", dp->et_flags);
		printf ("op_ethtstat = 0x%x\n", OPENCHIP->op_ethtstat);
#endif	DEBUG
		return SUCCESS;
	} else
		return FAILED;
}

struct eth_desc *
eth_rx()
{
	if ((OPENCHIP->op_ethrstat & OP_ETH_EVNT)
	    && (etrxring->et_flags & ET_OWN))
		return etrxring;
	else
		return NULL;
}

eth_rerx()
{
	etrxring->et_flags = 0;
	OPENCHIP->op_ethrx = etrxring;
	etrxring = etrxring->et_next;
}

#ifdef	DEBUG
show_packet(s, p)
	char           *s;
	struct boot_packet *p;
{
	printf(s);
	printf(" d=%x:%x:%x:%x:%x:%x",
	       p->bp_eh.ether_dhost[0],
	       p->bp_eh.ether_dhost[1],
	       p->bp_eh.ether_dhost[2],
	       p->bp_eh.ether_dhost[3],
	       p->bp_eh.ether_dhost[4],
	       p->bp_eh.ether_dhost[5]
		);
	printf(" s=%x:%x:%x:%x:%x:%x",
	       p->bp_eh.ether_shost[0],
	       p->bp_eh.ether_shost[1],
	       p->bp_eh.ether_shost[2],
	       p->bp_eh.ether_shost[3],
	       p->bp_eh.ether_shost[4],
	       p->bp_eh.ether_shost[5]
		);
	printf(" t=0x%x", p->bp_eh.ether_type);
	printf(" id=%d cmd=0x%x offset=%d len=%d\n",
	       p->bp_pkid, p->bp_cmd, p->bp_offset, p->bp_len);
}
#endif	DEBUG
