/*	qt.c	1.1	88/5/12	*/

/*
 * ISI Liberator scsi tape driver
 */

/*#define	DEBUG	/**/

#include "saio.h"
#include "sais68k.h"
#include "openchip.h"
#include "openscsi.h"
#include "qscsi.h"
#include "qsreg.h"

/*             _________________________________
 * i_unit:     | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
 *             ---------------------------------
 *             \__________/ \_____/ \_________/ 
 *                flags      cont      device
 */

#define NQT			1
#define NQT_DEV			8
#define QT_CTLR(unit)		(unit&0x1F)
#define QT_CONT(unit)		((QT_CTLR(unit) >> 3) & 7)
#define QT_DEVICE(unit)		(QT_CTLR(unit) & 7)
#define QT_QSCTLR(unit)	((QT_CONT(unit) << 3) | QT_DEVICE(unit))
#define QTF_SETBLKSZ		0x80
#define QTF_ISI			0x40
#define QTF_SWAB		0x20

#define QT_MAXRETRY		3
#define QT_MAXCNT		0x1FE00

#define QT_BLKCNT		1
#define QT_BYTCNT		2

#define QT_SRECS		0
#define QT_SFILES		0x10000

int			sadie_blocksize;
struct st 		qtst = { 512, -1, -1, -1, -1, NULL};
int			qt_bn;
int			qt_resid;
int			qt_blksz;
u_char			qt_opened;
u_char			qt_filemark;
u_char			qt_status[LEN_STATUS];
u_char			qt_buf;

int			qtstrat();

union scsi_sns		qt_sns;
struct scsi_inq		qt_inq;
struct scsi_msen	qt_msen;
struct scsi_msel	qt_msel;
struct scsi_blklim	qt_blklim;
union scsi_cdb		qt_tmpcdb;

qtopen(io)
	register struct iob *io;
{
	if (qsopen(QT_CTLR(io->i_unit))) {
		printf("qt%d: controller not present\n",io->i_unit);
		return(-1);
	}
	if (qtinq(io->i_unit))
		return(-1);
	if (qtrewind(io->i_unit))
		return(-1);

	if (io->i_boff && (io->i_flgs&F_BLKOFF) == 0)
		if (qtspace(io->i_unit, io->i_boff, QT_SFILES))
			return(-1);
	qt_bn = 0;

	if (qtsize(io->i_unit)) {
		return(-1);
	}

	qt_blksz = qtst.nbsec;
	if (sadie_blocksize)
		qtst.nbsec = sadie_blocksize;
	else if (io->i_unit & QTF_ISI)
		if (qtreadisisize(io))
			return(-1);

#ifdef SETBLKSZ
	if (io->i_unit & QTF_SETBLKSZ) {
		qt_blksz = qtreadblksz(io->i_unit);
	}
#endif SETBLKSZ

	if ((io->i_boff == 0) || (io->i_flgs&F_BLKOFF))
	    if (qtslctmod(io->i_unit))
		return(-1);
	if (io->i_boff && (io->i_flgs&F_BLKOFF) == 0)
		io->i_boff = 0;
	io->i_cc = 0;
	qt_opened = 1;
	io->i_st = qtst;
	return (0);
}

qtclose(io)
	register struct iob *io;
{
	if (qt_opened) {
		qt_opened = 0;
		return(qtrewind(io->i_unit));
	}
	return (-1);
}

qtstrategy(io, func)
	register struct iob *io;
{
	int unit = io->i_unit;
	int bn = io->i_bn * (qtst.nbsec / qt_blksz);
	int bpart, bleft, cmd, dir, count;
	struct scsi_cmnd *qcmd;
	union scsi_cdb *cdb;

	cdb = &qt_tmpcdb;
	qcmd = (struct scsi_cmnd *) qsgetcmd(QT_QSCTLR(io->i_unit));

	if (bn != qt_bn)
		if (unit & QTF_ISI) {
			if (qtisispace(unit, bn - qt_bn)) {
				printf("qt%d: bad seek\n", unit);
				return (-1);
			}
		} else {
			if (qtspace(unit, bn - qt_bn, QT_SRECS)) {
				printf("qt%d: bad seek\n", unit);
				return (-1);
			}
		}
	qt_bn = bn;
	if (func == READ) {
		cmd = CMD_READ;
	} else {
		cmd = CMD_WRITE;
		printf("qt%d: can`t write\n", unit);
		return (-1);
	}

	bleft = io->i_cc;
	do {
		bpart = (bleft < QT_MAXCNT) ? bleft+(bleft&1) : QT_MAXCNT;
		if (unit & QTF_ISI)
			if ((bpart = qtisiheader(unit, QT_BYTCNT)) < 0)
				return(-1);

		count = (bpart + qt_blksz - 1) / qt_blksz;
		qt_resid = count;
		SET_CDB_0(cdb, cmd, 0, ((count>>8)&0xFFFF) | 0x10000, 
			count & 0xFF, 0, 0);
		SET_CMD(qcmd,0,cdb,sizeof(struct cdb_0),qt_status,
			SFN_NOT_FINISHED,LEN_STATUS,io->i_ma,bpart,0);
		if (qtcommand(unit, qcmd)) {
			printf("qt%d: read failed\n");
			return(-1);
		}
		bpart -= (qt_resid * qt_blksz);
		io->i_ma += bpart;
		bleft -= bpart;
		qt_bn += count;
		if (qt_filemark) {
			qt_filemark = 0;
			return (io->i_cc - bleft);
		}
	} while (bleft > 0);
	return (io->i_cc);
}

qtinq(unit)
{
	struct scsi_cmnd *cmd;
	union scsi_cdb *cdb;

	cdb = &qt_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QT_QSCTLR(unit));

	/* do an inquiry command and find out what kind of device it is */
	SET_CDB_0(cdb, CMD_INQUIRY, 0, 0, sizeof(qt_inq), 0, 0);
	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qt_status,
		SFN_NOT_FINISHED,LEN_STATUS,&qt_inq,sizeof(qt_inq),0);
	if (qtcommand(unit, cmd)) {
		return (-1);
	}
	if (qt_inq.inq_pdtype != INQ_PDT_TAPE) {
		printf("qt%d: not a tape\n", unit);
		return (-1);
	}

	/* see if it is ready  ...
	SET_CDB_0(cdb, CMD_TESTREADY, 0, 0, 0, 0, 0);
	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qt_status,
		SFN_NOT_FINISHED,LEN_STATUS,&qt_buf,1,0);
	if (qtcommand(unit, cmd))
		return (-1);
	... */

	return (0);
}

qtrewind(unit)
{
	struct scsi_cmnd *cmd;
	union scsi_cdb *cdb;

	cdb = &qt_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QT_QSCTLR(unit));

	SET_CDB_0(cdb, CMD_REZERO, 0, 0, 0, 0, 0);
	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qt_status,
		SFN_NOT_FINISHED,LEN_STATUS,&qt_buf,1,0);
	if (qtcommand(unit, cmd)) {
		printf("qt%d: rewind failed\n",unit);
		return(-1);
	}
	return(0);
}

qtspace(unit,count,rec_fil)
{
	u_int	lba = (((u_int )count >> 8) & 0xFFFF) | (u_int )rec_fil;
	u_int	bc  = (u_int )count & 0xFF;
	struct scsi_cmnd *cmd;
	union scsi_cdb *cdb;

	cdb = &qt_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QT_QSCTLR(unit));

	/* space forward/backward 'count' records/files */
	SET_CDB_0(cdb, CMD_SPACE, 0, lba, bc, 0, 0);
	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qt_status,
		SFN_NOT_FINISHED,LEN_STATUS,&qt_buf,1,0);
	if (qtcommand(unit, cmd)) {
		printf("qt%d: space failed\n", unit);
		return (-1);
	}
	return (0);
}

qtsize(unit)
{
	struct scsi_cmnd *cmd;
	union scsi_cdb *cdb;

	cdb = &qt_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QT_QSCTLR(unit));

	/* get current block size information */
	SET_CDB_0(cdb, CMD_MSENSE, 0, 0, sizeof(qt_msen), 0, 0);
	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qt_status,
		SFN_NOT_FINISHED,LEN_STATUS,&qt_msen,sizeof(qt_msen),0);
	if (qtcommand(unit, cmd)) {
		printf("qt%d: mode sense failed\n", unit);
		return (-1);
	}
	qtst.nbsec = SCSI_HML(qt_msen.msen_bd.bd_bl);

	/* get block limits information */
	bzero(&qt_blklim, sizeof(struct scsi_blklim));
	SET_CDB_0(cdb, CMD_BLKLIM, 0, 0, 0, 0, 0);
	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qt_status,
		SFN_NOT_FINISHED,LEN_STATUS,&qt_blklim,sizeof(qt_blklim),0);
	if (qtcommand(unit, cmd))
		printf("qt%d: blocklimits failed\n", unit);

	return(0);
}

qtslctmod(unit)
{
	struct scsi_cmnd *cmd;
	union scsi_cdb *cdb;

	cdb = &qt_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QT_QSCTLR(unit));

	/* select buffering mode (if possible) */
	/* also select block size (if needed and possible) */
	qt_msen.msen_len = 0;
	qt_msen.msen_mtype = 0;
	qt_msen.msen_wprot = 0;
	qt_msen.msen_rsvd = 0x10; /* use buffered mode */
	qt_msen.msen_bdl = 8;
	qt_msen.msen_bd.bd_density = 0;
	SCSI_HML_SET(qt_msen.msen_bd.bd_nb, 0);
	SCSI_HML_SET(qt_msen.msen_bd.bd_bl, qt_blksz);
	SET_CDB_0(cdb, CMD_MSELECT, 0, 0, 12, 0, 0);
	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qt_status,
		SFN_NOT_FINISHED,LEN_STATUS,&qt_msen,12,0);
	if (qtcommand(unit, cmd))
		printf("Mode Select Failed - Ignored\n");
	
	return(0);
}

qtcommand(unit, cmd)
	register struct scsi_cmnd	*cmd;
{
	int				count = 0;

	while (1) {
	    switch (qtissue(unit,cmd,0)) {
		case  SNS_7_KEY_NO_SENSE:
		case  SNS_7_KEY_RECOVERED:
				return (0);		/* ok */
		case  SNS_7_KEY_ABORT_CMD:
		case  SNS_7_KEY_UNIT_ATTN:
				if (++count == QT_MAXRETRY)
					return (-1);	/* hard error */
				else
					continue;	/* retry */
		case  -(SCSI_STATUS_BUSY):
					continue;	/* retry forever */
		default:
				return (-1);		/* hard error */
	    }
	}
}

qtissue(unit, cmd, silent)
	register struct scsi_cmnd	*cmd;
{
	register int nsense = 0;
	register union scsi_cdb	*cdb;

#define	SHHHH(x)	{ if (!silent) x;}

	cdb = &qt_tmpcdb;

	/* If timeout return -1  */
	if (qscomm(QT_QSCTLR(unit), QT_DEVICE(unit), cmd, 10000000)) {
		SHHHH(printf("qt%d: cmd 0x%x timed out \n",
			unit,cdb->cdb_0.cdb_0_cmd));
		return (-1);
	}

	/* If fatal error return -1 */
	if(cmd->sc_flags & SCF_FATAL_COMB) {
		SHHHH(printf("qt%d: fatal error: cmd 0x%x failed: error 0x%x\n",
			unit,cdb->cdb_0.cdb_0_cmd,cmd->sc_flags));
		return(-1);
	}

	/* If command did not end normally */
	if(cmd->sc_finstat != SFN_NORMAL_END) {
		SHHHH(printf("qt%d: fatal error: cmd 0x%x did not finish normally\n",
			unit,cdb->cdb_0.cdb_0_cmd));
		printf("sc_finstat=0x%x, sc_flags=0x%x\n",cmd->sc_finstat,
			cmd->sc_flags);
		return(-1);
	}

	/* If normal end and no request sense return 0 */
	if((cmd->sc_finstat == SFN_NORMAL_END) && !(cmd->sc_flags & SCF_RQS_SNS)) {
		qt_resid = 0;
		return (0);
	}

	if((cmd->sc_flags & SCF_RQS_SNS) == 0)  {
		SHHHH(printf("qt%d: fatal error\n",unit));
		return(-1);
	}

	SET_CDB_0(cdb, CMD_SENSE, 0, 0, sizeof (qt_sns), 0, 0);
	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qt_status,
		SFN_NOT_FINISHED,LEN_STATUS,&qt_sns,sizeof(qt_sns),0);
	if (qscomm(QT_QSCTLR(unit), QT_DEVICE(unit), cmd, 8000)) {
	    SHHHH(printf("qt%d: SENSE timeout\n", unit));
		return (-1);
	}

	if (cmd->sc_finstat != SFN_NORMAL_END) {
	    SHHHH(printf("qt%d: SENSE fatal error\n", unit));
	    return (-1);
	}
	if (qt_sns.sns_7.sns_7_class != 7) {
	    SHHHH(printf("qt%d: invalid sense class %d\n", unit,
		qt_sns.sns_7.sns_7_class));
	    return (-1);
	}
	if (qt_sns.sns_7.sns_7_valid) {
		qt_resid = SCSI_HMML(qt_sns.sns_7.sns_7_info);
	    SHHHH(printf(": resid=%d", SCSI_HMML(qt_sns.sns_7.sns_7_info)));
	}
	SHHHH(printf("\n"));
	if (qt_sns.sns_7.sns_7_eom) {
	    SHHHH(printf("qt%d: unexpected physical eot\n", unit));
		return(-1);
	}
	if (qt_sns.sns_7.sns_7_fil_mk)
		qt_filemark = 1;
	return (qt_sns.sns_7.sns_7_key);
}

qtreadisisize(io)
	register struct iob *io;
{
	int		unit = io->i_unit;

	if((qtst.nbsec = qtisiheader(unit,QT_BYTCNT)) == -1)
		return(-1);

	if (qtspace(unit, -1, QT_SRECS)) {
		printf("qt%d: reverse space not supported; rewinding...\n",unit);
		if (qtrewind(unit))
			return(-1);
		if (io->i_boff && (io->i_flgs&F_BLKOFF) == 0)
			if (qtspace(unit, io->i_boff, QT_SFILES))
				return(-1);
	}
}

qtisispace(unit, count)
{
	int	c, tb;


	if (count < 0)
		printf("qt%d: reverse space record not supported\n", unit);

	for (c = (count / (qtst.nbsec / qt_blksz)); c > 0; c--) {
		/* read a header block */
		tb = qtisiheader(unit, QT_BLKCNT);
		if (tb < 0)
			return(-1);
		if (tb == 0)
			return(0);
		/* space forward rest of record */
		if (qtspace(unit, tb, QT_SRECS))
			return(-1);
	}
	return(0);
}

qtisiheader(unit, retval)
{
	struct scsi_cmnd *cmd;
	union scsi_cdb *cdb;
	union ihead {
		struct isihead	{
			u_short	ih_id;
			u_short	ih_fileno;
			u_short	ih_fileba;
			u_short	ih_blksz;
			u_short	ih_count;
		}			qt_ih;
		char buf[512];
	}	qt_ihead;

	cdb = &qt_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QT_QSCTLR(unit));

	qt_ihead.qt_ih.ih_id = 0;
	/* read header block */
	SET_CDB_0(cdb, CMD_READ, 0, 0x10000, 1, 0, 0);
	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qt_status,
		SFN_NOT_FINISHED,LEN_STATUS,&qt_ihead,512,0);
	if (qtcommand(unit, cmd))
		return(-1);

	if(qt_ihead.qt_ih.ih_id != 0xA1FE) {
		printf("gd%d: bad isi header 0x%x\n",unit,qt_ihead.qt_ih.ih_id);
		return(-1);
	}

	if (retval == QT_BLKCNT)
		return(qt_ihead.qt_ih.ih_count);
	if (retval == QT_BYTCNT)
		return(qt_ihead.qt_ih.ih_blksz);
	return(-1);
}

#ifdef	DEBUG
printcdb0(cdb)
	char *cdb;
{
	register char i;

	printf("cdb_0: ");
	for(i=0;i<6;i++)
		printf("%x ",*cdb++);
	printf("\n");
}
#endif	DEBUG
