
/*#define DEBUG			/**/

#include "saio.h"
#include "sais68k.h"
#include "openchip.h"
#include "openscsi.h"
#include "qxoutport.h"
#include "qscsi.h"
#include "qsreg.h"

/*
 *        _________________________________ 
 * ctlr:  | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
 *        --------------------------------- 
 *                 \_cont____/ \__device_/ 
 */

/* Macros */

#define	QS_CONT(ctlr)	((ctlr >> 3) & 0x7)
#define	QS_DEVICE(ctlr)	(ctlr & 0x7)

#define GETMST()	(OPENCHIP->op_scstat & OP_ST_MST_MASK)
#define GETPHASE()	(OPENCHIP->op_scstat & OP_ST_PHSMASK)
#define GETSTATE()	(OPENCHIP->op_scstat & OP_ST_STATEMASK)
#define NEWMST(x)	(OPENCHIP->op_scstat = (OPENCHIP->op_scstat & ~OP_ST_MST_MASK) | x)
#define NEWPHASE(x)	(OPENCHIP->op_scstat = (OPENCHIP->op_scstat & ~OP_ST_PHSMASK) | x)
#define NEWSTATE(x)	(OPENCHIP->op_scstat = (OPENCHIP->op_scstat & ~OP_ST_STATEMASK) | x)

#define NQS		1
#define NQS_targ_cont	8

struct qsdevice *QSstd[NQS] = { (struct qsdevice *) 0x1000178};
struct scsi_cmnd qs_cmd[NQS * NQS_targ_cont];

u_char	msgout;
u_char	msginbuf;
u_char 	noanswer;
u_char	initflag;
u_char	status[LEN_STATUS];

qsopen(ctlr)
	register int    ctlr;
{
	register int    cont = QS_CONT(ctlr);
	register struct qsdevice *qsaddr = QSstd[cont];
	int             i;

	if (cont >= NQS) {
		printf("qs%d: bad controller\n", cont);
		return (-1);
	}
	qsinit(qsaddr);
	return (0);
}

qsinit(wdptr)
	struct qsdevice *wdptr;
{
	OPENCHIP->op_sccntrl = 0;	/* stop any DMA */
	while (OPENCHIP->op_sccntrl & OP_SC_DACT) {	/* wait for it ... */
		DELAY(10);
	}
	/*
	 * If the auxilliary status register has BSY and CIP set, it
	 * indicates that it has not yet been reset so do it now. 
	 */
	if ((wdptr->wd_addr_stat &
	     (WD_AUX_BSY | WD_AUX_CIP)) == (WD_AUX_BSY | WD_AUX_CIP)) {
		Q_OP_PORT1 = OP1_SET_RESSCSI;
		DELAY(100);
		Q_OP_PORT1 = OP1_RES_RESSCSI;
		DELAY(100);
	}
	/*
	 * After writing to the ownid register in the SCSI chip, a reset
	 * command must be issued to the chip. This will result in at leaset
	 * 1 interrupt which should be fielded. 
	 */
	do {
		OPENCHIP->op_scsintr = 0xff;
		DELAY(100);
	} while (OPENCHIP->op_scsintr);

	wdptr->wd_addr_stat = WD_OWNID;
	wdptr->wd_data = 0;
	wdptr->wd_addr_stat = WD_COMMAND;
	wdptr->wd_data = WD_CMD_RESET;
	/*
	 * wait for the OpenChip to respond to the interrupt from the WD33C93
	 * and then reset that. 
	 */
	while (!(OPENCHIP->op_scsintr)) {
		/*
		 * perform a slight delay so as not to access the Openchip
		 * too frequently. 
		 */
		DELAY(100);
	}
	/*
	 * Don't want to handle reselection or selection. 
	 */
	wdptr->wd_addr_stat = WD_SOURCE_ID;
	wdptr->wd_data = 0;
	wdptr->wd_addr_stat = WD_TIMEOUT;
	wdptr->wd_data = 30;		/* 30 * 8ms = 240ms timeout on sel */
	/*
	 * now reset the interrupt. Do it after the above writes to avoid any
	 * conflict with the OpenChip over setting up the address. 
	 */
	OPENCHIP->op_scsintr = 0xff;

	return (0);
}

struct scsi_cmnd *qsgetcmd(ctlr)
	register int ctlr;
{
	return(&qs_cmd[QS_DEVICE(ctlr)]);
}

qscomm(ctlr, targ, cmd, timeout)
	struct scsi_cmnd *cmd;
{
	register struct qsdevice *wdptr;

	wdptr = QSstd[QS_CONT(ctlr)];

#ifdef	DEBUG
	qsprintcmd(cmd);
#endif	DEBUG

	wdptr->wd_addr_stat = WD_DEST_ID;
	wdptr->wd_data = targ;
	wdptr->wd_addr_stat = WD_SYNCHRNS;
	wdptr->wd_data = 0;
	wdptr->wd_addr_stat = WD_CONTROL;
	wdptr->wd_data = WCNT_DMA;
	wdptr->wd_addr_stat = WD_COMMAND;
	wdptr->wd_data = WD_CMD_SEL_NOATN;
	OPENCHIP->op_sccntrl &= ~OP_SC_SELATN;
	NEWSTATE(SC_SELECTING);

	while (cmd->sc_finstat == SFN_NOT_FINISHED) {
		if ((OPENCHIP->op_scsintr & SCNT_REASON_MASK) == SCNT_MANUAL) {
			scmannorm(wdptr, cmd);
			OPENCHIP->op_scsintr = 0xff;	/* reset the SCSI */
		}
		DELAY(400);
		if(timeout-- == 0)
			return(-1);
	}
	/* Caller checks for errors */
	return(0);
}

scmannorm(wdptr, cmd)
	struct qsdevice *wdptr;
	struct scsi_cmnd *cmd;
{
	unsigned char   status;
	unsigned char   c;

	status = OPENCHIP->op_scsistatus;

	/*
	 * There are several different versions of status which encode the
	 * new phase. In order to reduce the number of case's in a switch
	 * such multiple choices are reduced to one. 
	 */
	if (status & 0x08)
		status &= 0x0f;
	switch (GETSTATE()) {
	case SC_SELECTING:
		switch (status) {
		case WDST_SEL_CMPLT:	/* select completed successfully */
			NEWSTATE(SC_CONNECTED);
			break;
		case WDST_TIMEOUT_CMD_TERM:	/* selection timed out */
			cmd->sc_finstat = SFN_SLCT_TIMEOUT;
			noanswer = 1;
			break;
		default:
			printf("SELECTING with status 0x%x\n", status);
			break;
		}
		break;

	case SC_CONNECTED:
		/*
		 * If DMA was in use, it must be tidied up. 
		 */
		if (OPENCHIP->op_sccntrl & OP_SC_DACT) {
			unsigned long   lngth;
			char           *cptr;

			OPENCHIP->op_sccntrl &= ~OP_SC_DACT;
			/*
			 * wait for DACT to read as reset. Perform a slight
			 * delay in the loop so as not to access the OpenChip
			 * too much. 
			 */
			do {
				DELAY(10);
			} while (OPENCHIP->op_sccntrl & OP_SC_DACT);

			/*
			 * get the remaining count out of the SCSI chip. 
			 */
			wdptr->wd_addr_stat = WD_TRANS_COUNT0;
			lngth = (unsigned char) wdptr->wd_data;
			lngth <<= 8;
			lngth |= (unsigned char) wdptr->wd_data;
			lngth <<= 8;
			lngth |= (unsigned char) wdptr->wd_data;
			/*
			 * calculate the corrected DMA pointer. 
			 */
			cptr = OPENCHIP->op_scdmaptr;
			cptr -= (unsigned char) ((unsigned char) cptr +
				(unsigned char) lngth) - OPENCHIP->op_scsum;

			switch (GETPHASE()) {
			case OP_ST_PHS_DATA_IN:
			case OP_ST_PHS_DATA_OUT:
				if (!(cmd->sc_flags & SCF_DATA_OVFL)) {
					cmd->sc_datlnk.sl_cnt = lngth;
					cmd->sc_datlnk.sl_ptr = cptr;
				}
				break;
			case OP_ST_PHS_STATUS:
				if (!(cmd->sc_flags & SCF_STATUS_OVFL)) {
					cmd->sc_nstat = lngth;
					cmd->sc_pstat = cptr;
				}
				break;
			case OP_ST_PHS_COMMAND:
				if (!(cmd->sc_flags & SCF_COMM_OVFL)) {
					cmd->sc_ncmnd = lngth;
					cmd->sc_pcmnd = cptr;
				}
				break;
			}
		}
		switch (status) {
			/*
			 * statuses 0x1? indicate previous transfer completed
			 * normally. 0x4? indicates transfer completed with
			 * count != 0. 0x8? indicates first transfer after
			 * connection. 
			 */
		case 0x08 | PHS_MSG_IN:
			setupDMA(wdptr,&msginbuf, 1, OP_ST_PHS_MSG_IN);
			break;
		case 0x08 | PHS_MSG_OUT:
			setupDMA(wdptr,&msgout, 1, OP_ST_PHS_MSG_OUT);
			break;
		case 0x08 | PHS_STATUS:
			if (cmd->sc_nstat) {
				setupDMA(wdptr,cmd->sc_pstat, cmd->sc_nstat, OP_ST_PHS_STATUS);
			} else {
				cmd->sc_flags |= SCF_STATUS_OVFL;
				setmanual(wdptr, OP_ST_PHS_STATUS);
			}
			break;
		case 0x08 | PHS_COMMAND:
			if (cmd->sc_ncmnd) {
				setupDMA(wdptr,cmd->sc_pcmnd, cmd->sc_ncmnd, OP_ST_PHS_COMMAND);
			} else {
				cmd->sc_flags |= SCF_COMM_OVFL;
				setmanual(wdptr, OP_ST_PHS_COMMAND);
			}
			break;
		case 0x08 | PHS_DATA_IN:
		case 0x08 | PHS_DATA_OUT:
			if (cmd->sc_datlnk.sl_cnt == 0) {
				cmd->sc_flags |= SCF_DATA_OVFL;
				if ((status & PHS_MASK) == PHS_DATA_IN) {
					setmanual(wdptr, OP_ST_PHS_DATA_IN);
				} else {
					setmanual(wdptr, OP_ST_PHS_DATA_OUT);
				}
			} else {
				if ((status & PHS_MASK) == PHS_DATA_IN) {
					setupDMA(wdptr,cmd->sc_datlnk.sl_ptr, cmd->sc_datlnk.sl_cnt, OP_ST_PHS_DATA_IN);
				} else {
					setupDMA(wdptr,cmd->sc_datlnk.sl_ptr, cmd->sc_datlnk.sl_cnt, OP_ST_PHS_DATA_OUT);
				}
			}
			break;
		case WDST_DISCONN_SERV:	/* normal disconnect */
		case WDST_DISCONN_CMD_TERM:	/* unexpected disconnect */
			/*
			 * Notice that l_state is guaranteed to be L_ST_NULL
			 * since it gets set so when a reselection takes
			 * place. 
			 */
			switch (GETMST()) {
			case MST_NULL:
			case MST_DISC:
				cmd->sc_finstat = SFN_NO_CMND_CMPLT;
				break;
			case MST_CMPLT:
			case MST_CMPLT2:
				cmd->sc_finstat = SFN_NORMAL_END;
				break;
			}
			/*
			 * The code may now go ahead and try to issue another
			 * command. 
			 */
			break;
		case WDST_MSG_IN_PAUSE:	/* message in has paused */
			switch (msginbuf) {
			case MSG_CMD_COMPLETE:
				NEWMST(MST_CMPLT);
				wdptr->wd_addr_stat = WD_COMMAND;
				wdptr->wd_data = WD_CMD_NEG_ACK;
				break;
			case MSG_EXTENDED:
				setmanual(wdptr, OP_ST_PHS_MSG_IN);
			case MSG_SAVE_DPTR:
			case MSG_RESTORE_PTRS:
			default:
				msgout = MSG_MSG_REJECT;
				wdptr->wd_addr_stat = WD_COMMAND;
				wdptr->wd_data = WD_CMD_ASSRT_ATN;
				wdptr->wd_data = WD_CMD_NEG_ACK;
				break;
			case MSG_DISCONNECT:
				NEWMST(MST_DISC);
				wdptr->wd_addr_stat = WD_COMMAND;
				wdptr->wd_data = WD_CMD_NEG_ACK;
				break;
			case MSG_MSG_REJECT:
				/*
				 * It is hard to see what to do if this is
				 * received but the specification says that a
				 * message reject message may not be rejected
				 * itself. 
				 */
				wdptr->wd_addr_stat = WD_COMMAND;
				wdptr->wd_data = WD_CMD_NEG_ACK;
				break;
			}
			break;
		default:
			printf("CONNECTED with status 0x%x\n", status);
			break;
		}
		break;
	}
}


static char     non_val;

setmanual(wdptr, phase)
	struct qsdevice *wdptr;
	char            phase;
{
	wdptr->wd_addr_stat = WD_TRANS_COUNT0;
	wdptr->wd_data = 0xff;
	/*
	 * It isn't really worth writing a value to any but the most
	 * significant byte of the transfer counter. 
	 */
	wdptr->wd_addr_stat = WD_COMMAND;
	wdptr->wd_data = WD_CMD_TRANS_PAD;
	NEWPHASE(phase);
	if (!(phase & OP_ST_PHS_IO)) {
		OPENCHIP->op_scdmaptr = &non_val;
		OPENCHIP->op_sccntrl |= OP_SC_DACT;
	}
}


static
setupDMA(wdptr, ptr, cnt, phase)
	struct qsdevice *wdptr;
	char           *ptr;
	int             cnt;
	char            phase;
{

	wdptr->wd_addr_stat = WD_TRANS_COUNT0;
	wdptr->wd_data = cnt >> 16;
	wdptr->wd_data = cnt >> 8;
	wdptr->wd_data = cnt;
	wdptr->wd_addr_stat = WD_COMMAND;
	wdptr->wd_data = WD_CMD_TRANS_INFO;
	NEWPHASE(phase);
	OPENCHIP->op_scdmaptr = ptr;
	OPENCHIP->op_scsum = (char) ptr + (char) cnt;
	while (wdptr->wd_addr_stat & WD_AUX_CIP)
		DELAY(10);
	OPENCHIP->op_sccntrl |= OP_SC_DACT;
}


qsprintcmd(cmd)
	register struct scsi_cmnd *cmd;
{
	char i;
	char *cdb;

	printf("\n printcmd, cmd 0x%x, dbgmsg=%s\n",cmd,cmd->dbgmsg);
	printf("datlnk.sl_ptr=0x%x, datlnk.sl_cnt=%d\n",
		cmd->sc_datlnk.sl_ptr,cmd->sc_datlnk.sl_cnt);
	printf("pcmnd=0x%x, ncmnd=%d, pstat=0x%x, nstat=%d, finstat=0x%x\n",
		cmd->sc_pcmnd,cmd->sc_ncmnd,cmd->sc_pstat,cmd->sc_nstat,cmd->sc_finstat);
	cdb = cmd->sc_pcmnd;
	printf("cdb: ");
	for(i=0;i<cmd->sc_ncmnd;i++)
		printf("%x ",*cdb++);	
	printf("\n");
}
