
/*#define		DEBUG		/**/

#include "saio.h" 
#include "sais68k.h" 
#include <setjmp.h> 
#include "openchip.h" 
#include "openscsi.h"
#include "qscsi.h"
#include "qsreg.h"

/*
 *                        /-----ctlr----\ 
 *           ________________________________ 
 * i_unit:   | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 | 
 *           -------------------------------- 
 *                        \_____/ \_____/ \_/
 *                         cont    device  lun 
 */
#define	NQD			1
#define	NQD_DEV			4
#define	NQD_LUN			2
#define	QD_UNIT(cont, dev, lun)	(((cont&3)<<3)|((dev&3)<<1)|(lun&1))
#define QD_QSCTLR(cont, dev)	((cont << 3) | dev)
#define	QDU_LUN(unit)		(unit&1)
#define	QDU_CTLR(unit)		((unit >> 1)&0xF)
#define	QDU_DEVICE(unit)	(QDU_CTLR(unit) & 3)
#define	QDU_CONT(unit)		((QDU_CTLR(unit) >> 2) & 3)
#define	QDU_QSCTLR(unit)	((QDU_CONT(unit) << 3) | QDU_DEVICE(unit))

#define	QD_MAXCNT	0x1fe00
#define QD_MAXRETRY	3

int             forbb, xbad144, xbad144_soft, xbad144_hadsoft, qdstrat();
int             qd_formatting = 0;

union scsi_sns		qd_sns;
struct scsi_inq		qd_inq;
struct scsi_msen	qd_msen;
struct scsi_msel	qd_msel;
struct scsi_rcap	qd_rcap;
struct scsi_cdb		qd_tmpcdb;
u_char qd_status[LEN_STATUS];
u_char qd_buf;
char qdbuf[512];

qdopen(io)
	register struct iob *io;
{
	if(qsopen(QDU_QSCTLR(io->i_unit)) || qdinq(io->i_unit) || qdsize(io)) {
		printf("qd%d: device not responding\n",io->i_unit);
		return (-1);
	}
	if ((io->i_boff = diskpart(io)) < 0) {
		printf("qd%d: bad offset\n", io->i_unit);
		return (-1);
	}
	if (qdslctmod(io->i_unit))
		return (0);	/* it's not a fatal error; keep going */
	return (0);
}


qdstrategy(io, func)
	register struct iob *io;
{
	register int    bleft, bpart, bn;

#ifdef	DEBUG
	printf("qdstrategy(%s)\n",(func == READ) ? "READ" : "WRITE");
#endif	DEBUG

	bn = io->i_bn;
	func = (func == READ) ? CMD_XREAD : CMD_XWRITE;
	bleft = io->i_cc;

	do {
		bpart = (bleft < QD_MAXCNT) ? bleft : QD_MAXCNT;
		if (forbb) {
			if (qdstrat(io, bn, bpart, func) == -1)
				return (-1);
			io->i_ma += bpart;
		} else if (badstrat(io,bn,bpart,func,qdstrat,CMD_XREAD) == -1)
			return (-1);
		bleft -= bpart;
		bn += bpart / io->i_st.nbsec;
	} while (bleft > 0);
	return (io->i_cc);
}

qdstrat(io, bn, bpart, func)
	register struct iob *io;
{
	int chunk, leftover;
	char *bufptr;

	chunk = (bpart / 512) * 512;
	leftover = bpart - chunk;
	bufptr = (char *) io->i_ma;

#ifdef	DEBUG
	printf("chunk=%d leftover=%d\n",chunk, leftover);
#endif	DEBUG

	if(qdstrat2(bufptr,io->i_unit,bn,chunk,func) != 0)
		return(-1);
	if(leftover) {
		bufptr += chunk;
		if(qdstrat2(qdbuf,io->i_unit,(bn+(chunk/io->i_st.nbsec)),
			512,func) != 0)
			return(-1);
		bcopy(qdbuf,bufptr,leftover);	
	}
}
qdstrat2(buf, unit, bn, bpart, func)
	char *buf;

{
	register struct scsi_cmnd *cmd;
	register struct scsi_cdb *cdb;
	int				count = 0;

	cdb = &qd_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QDU_QSCTLR(unit));

	while (1) {
	    SET_CDB_1(cdb, func,  QDU_LUN(unit), 0, bn,
		(bpart+511)>>9, 0, 0);
	    SET_CMD(cmd,0,cdb,sizeof(struct cdb_1),qd_status,SFN_NOT_FINISHED,
		    LEN_STATUS, buf, bpart & ~0x1,0);
	    cmd->sc_dat2lnk = cmd->sc_datlnk;
	    sprintf(cmd->dbgmsg,"scsi cmd=0x%x, lun=%d\n",func,
		QDU_LUN(unit));

	    switch (qdissue2((func==CMD_XREAD)?"READ":"WRITE",cmd,unit,0)){
		case  0:	return (0);			/* ok */
		case  -1:	return (-1);			/* hard error */
		case  1:	if (++count == QD_MAXRETRY)	/* retry */
					return (-1);
	    }
	}
}

qdissue(command, cmd, unit, silient)
	register char			*command;
	register struct scsi_cmnd	*cmd;
	register int			silient;
{
	struct scsi_cmnd		cmdsav;
	int				count = 0;

	bcopy(cmd, &cmdsav, sizeof(struct scsi_cmnd));
	while (1) {
	    switch (qdissue2(command, cmd, unit, silient)) {
		case  0:	return (0);			/* ok */
		case  -1:	return (-1);			/* hard error */
		case  1:	if (++count == QD_MAXRETRY)	/* retry */
					return (-1);
	    }
	    bcopy(&cmdsav, cmd, sizeof(struct scsi_cmnd));
	}
}

qdissue2(command, cmd, unit, silient)
	register char			*command;
	register struct scsi_cmnd	*cmd;
	register int			silient;
{
	register int nsense = 0;
	register struct scsi_cdb *cdb;

	cdb = &qd_tmpcdb;

#define	SHHHH(x)	{ if (!silient) x;}

	/* If timeout return -1 */
	if (qscomm(QDU_QSCTLR(unit), QDU_DEVICE(unit), cmd, 
		qd_formatting ? 1000000 : 800000)) {
	    SHHHH(printf("qd%d: %s: timed out\n", unit, command));
		return (-1);
	}
	/* If fatal error return -1 */
	if (cmd->sc_flags & SCF_FATAL_COMB) {
	    SHHHH(printf("qd%d: %s: fatal error: fatal cmd combination\n", 
		unit, command));
#ifdef	DEBUG
	    printf("sc_flags=0x%x\n",cmd->sc_flags);
#endif	DEBUG
		return(-1);
	}
	/* If cmd did not end normally return -1 */
	if (cmd->sc_finstat != SFN_NORMAL_END) {
	    SHHHH(printf("qd%d: %s: fatal error: cmd ended abnormally\n", 
		unit, command));
#ifdef	DEBUG
	    printf("sc_finstat=0x%x\n",cmd->sc_finstat);
#endif	DEBUG
		return(-1);
	}
	/* If normal end and no request sense return 0 */
	if ((cmd->sc_finstat == SFN_NORMAL_END) && !(cmd->sc_flags & SCF_RQS_SNS)) 
		return (0);

	if((cmd->sc_flags & SCF_RQS_SNS) == 0) {
	    SHHHH(printf("qd%d: %s: fatal error: illegal request sense\n", 
		unit, command));
#ifdef	DEBUG
	    printf("sc_flags=0x%x\n",cmd->sc_flags);
#endif	DEBUG
		return(-1);
	}

sns:	SET_CDB_0(cdb, CMD_SENSE, QDU_LUN(unit), 0, sizeof (qd_sns),
	    0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_sns, sizeof(qd_sns),0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_SENSE, lun=%d\n",QDU_LUN(unit));
	if (qscomm(QDU_QSCTLR(unit), QDU_DEVICE(unit), cmd, 8000)) {
	    SHHHH(printf("qd%d: SENSE: fatal error\n", unit));
	    return (-1);
	}
	if (qd_sns.sns_7.sns_7_class != 7) {
	    SHHHH(printf("qd%d: invalid sense class %d\n", unit,
		qd_sns.sns_7.sns_7_class));
	    return (-1);
	}
	SHHHH(printf("qd%d: %s", unit, command));
	if (qd_sns.sns_7.sns_7_valid)
	    SHHHH(printf(": bn %d (0x%x)", SCSI_HMML(qd_sns.sns_7.sns_7_info),
		SCSI_HMML(qd_sns.sns_7.sns_7_info)));
	switch (qd_sns.sns_7.sns_7_key) {
	    case SNS_7_KEY_RECOVERED:
		SHHHH(printf(": soft error\n"));
		if (xbad144_soft) {
		    xbad144_hadsoft = 1;
		    return (-1);
		}
		return (0);

	    case SNS_7_KEY_ABORT_CMD:
	    case SNS_7_KEY_UNIT_ATTN:
		SHHHH(printf(": reissued\n"));
		return (1);

	    default:
		SHHHH(printf(": hard error\n"));
		return (-1);
	}
}


qdslctmod(unit)
{
	int				len;
	register int			lun; 
	register struct pag_desc	*pdn, *pdl;
	register struct scsi_cmnd 	*cmd;
	register struct scsi_cdb 	*cdb;

	lun = QDU_LUN(unit);

#ifdef	DEBUG
	printf("qdslctmod(%d)\n",unit);
#endif	DEBUG

	cdb = &qd_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QDU_QSCTLR(unit));

	/* get the current error recovery parameter page in msen */
	SET_CDB_0(cdb, CMD_MSENSE, lun, PD_ERROR<<8, sizeof(qd_msen),
	    0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_msen, sizeof(qd_msen),0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_MSENSE, lun=%d\n",lun);
	if (qdissue("MSENSE ERR", cmd, unit, 0))
		return (-1);
	pdn = (struct pag_desc *)(((char *)&qd_msen.msen_bd)+qd_msen.msen_bdl);
	if (pdn->pd_pg.pg_err.err_per)
		return (0);
	len = qd_msen.msen_len + 1;
	qd_msen.msen_len = 0;
	qd_msen.msen_wprot = 0;
	qd_msel = *((struct scsi_msel *)&qd_msen);

	/* get changable status of error recovery parameters page in msen */
	SET_CDB_0(cdb, CMD_MSENSE, lun, (0x40 | PD_ERROR)<<8,
	    sizeof(qd_msen), 0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_msen, sizeof(qd_msen),0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_MSENSE, lun=%d\n",lun);
	if (qdissue("MSENSE CERR", cmd, unit, 0))
		return (-1);

	pdl = (struct pag_desc *)(((char *)&qd_msel.msel_bd)+qd_msel.msel_bdl);
	if (pdn->pd_pg.pg_err.err_per)
		pdl->pd_pg.pg_err.err_per = 1;

	/* send page to drive */
	SET_CDB_0(cdb, CMD_MSELECT, lun, pdl->pd_save<<16, len, 0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_msel, len, 0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_MSELECT, lun=%d\n",lun);
	pdl->pd_save = 0;
	if (qdissue("MSELECT ERR", cmd, unit, 0))
		return (-1);
	return (0);
}



qdinq(unit)
{
	register int			lun  = QDU_LUN(unit);
	register int			ctlr = QDU_CTLR(unit);
	register struct scsi_cmnd 	*cmd;
	register struct scsi_cdb 	*cdb;

	cdb = &qd_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QDU_QSCTLR(unit));

#ifdef	DEBUG
	printf("qdinq(%d)\n",unit);
#endif	DEBUG

	/* do an inquiry command and find out what kind of device it is */
	SET_CDB_0(cdb, CMD_INQUIRY, lun, 0, sizeof(qd_inq), 0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_inq, sizeof(qd_inq), 0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_INQUIRY, lun=%d\n",lun);
	if (qdissue("INQUIRY", cmd, unit, 1))
		return (-1);
	if (qd_inq.inq_pdtype != INQ_PDT_DISK) {
		printf("qd%d: not a disk\n", unit);
		return (-1);
	}

	/* spin unit up and see if it is ready */
	SET_CDB_0(cdb, CMD_STARTSTOP, lun, 0, 1, 0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_buf, 1, 0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_STARTSTOP, lun=%d\n",lun);
	if (qdissue("START", cmd, unit, 1))
		return (-1);
	DELAY(200000);			/* warm up, dont want BUSY status */

	SET_CDB_0(cdb, CMD_TESTREADY, lun, 0, 0, 0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_buf, 1, 0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_TESTREADY, lun=%d\n",lun);
	if (qdissue("TESTREADY", cmd, unit, 0))
		return (-1);
	return (0);
}

qdsize(io)
	register struct iob	*io;
{
	register int			lun  = QDU_LUN(io->i_unit);
	register struct pag_desc	*pd;
	register int			spd, spc;
	register struct scsi_cmnd 	*cmd;
	register struct scsi_cdb 	*cdb;

	cdb = &qd_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QDU_QSCTLR(io->i_unit));

	/* get capacity information */
	SET_CDB_1(cdb, CMD_RCAPAC, lun, 0, 0, 0, 0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_1),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_rcap, sizeof(qd_rcap), 0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_RCAPAC, lun=%d\n",lun);
	if (qdissue("RCAPAC", cmd, io->i_unit, 0))
		return (-1);
	spd = qd_rcap.rcap_lba + 1;	/* sectors per disk */
	io->i_st.nbsec = qd_rcap.rcap_bl;
	if (io->i_st.nbsec != 512) {
		printf("qd%d: bad blocksize (%d)\n", io->i_unit, io->i_st.nbsec);
		return (-1);
	}

	/* Get cylinder boundary, by setting PMI */
	SET_CDB_1(cdb, CMD_RCAPAC, lun, 0, 1, 1, 0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_1),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_rcap, sizeof(qd_rcap), 0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_RCAPAC, lun=%d\n",lun);
	if (qdissue("RCAPAC PMI", cmd, io->i_unit, 0))
		return (-1);
	spc = qd_rcap.rcap_lba + 1;	/* sectors per cylinder */

	/* get current value geometry information */
	SET_CDB_0(cdb, CMD_MSENSE, lun, PD_GEOMETRY<<8,sizeof(qd_msen), 0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_msen, sizeof(qd_msen), 0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_MSENSE, lun=%d\n",lun);
	if (qdissue("MSENSE GEO", cmd, io->i_unit, 0))
		return (-1);
	pd = (struct pag_desc *)(((char *)&qd_msen.msen_bd)+qd_msen.msen_bdl);
	io->i_st.ncyl = SCSI_HML(pd->pd_pg.pg_geo.geo_cyl);
	io->i_st.ntpc =  pd->pd_pg.pg_geo.geo_heads;

	/* get current value format information */
	SET_CDB_0(cdb, CMD_MSENSE, lun, PD_FORMAT<<8, sizeof(qd_msen), 0, 0);
    	SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    LEN_STATUS, &qd_msen, sizeof(qd_msen), 0);
    	cmd->sc_dat2lnk = cmd->sc_datlnk;
	sprintf(cmd->dbgmsg,"scsi cmd=CMD_MSENSE, lun=%d\n",lun);
	if (qdissue("MSENSE FMT", cmd, io->i_unit, 0))
		return (-1);
	pd = (struct pag_desc *)(((char *)&qd_msen.msen_bd)+qd_msen.msen_bdl);
	io->i_st.nsect =  pd->pd_pg.pg_fmt.fmt_spt;

	/* test geometry for consistency */
	if ((io->i_st.nsect * io->i_st.ntpc * io->i_st.ncyl) == 0) {
		printf("qd%d: nonsense geometry (%dx%dx%d)\n", io->i_unit,
		    io->i_st.nsect, io->i_st.ntpc, io->i_st.ncyl);
		return (-1);  /* nonsense geometry */
	}

	/* if capacity is less than calculated size, try various adjustments */
	if ((io->i_st.nsect * io->i_st.ntpc * io->i_st.ncyl) != spd) {
	    /* if cylinder size too small, try subtracting alternate sectors */
	    if ((io->i_st.nsect * io->i_st.ntpc) > spc &&
		pd->pd_pg.pg_fmt.fmt_tpz != 0)
		    io->i_st.nsect - = pd->pd_pg.pg_fmt.fmt_alt_spz /
					pd->pd_pg.pg_fmt.fmt_tpz;

	    /* if cylsize still too small, try subtracting alt tracks */
	    if (((io->i_st.nsect * io->i_st.ntpc) > spc)  &&
		 (io->i_st.ntpc == pd->pd_pg.pg_fmt.fmt_tpz))
		      io->i_st.ntpc -= pd->pd_pg.pg_fmt.fmt_alt_tpz;

	    /* if spc still wrong */
	    if ((io->i_st.nsect * io->i_st.ntpc) != spc) {
		/* if spc not multiple of headcount */
		if (spc % io->i_st.ntpc) {
		    /* and spc not multiple of tracksize */
		    /* then just take blocks off end of disk */
		    if (spc % io->i_st.nsect)
			spc = io->i_st.nsect * io->i_st.ntpc;
		    else		/* spc multiple of tracksize  */
			io->i_st.ntpc = spc / io->i_st.nsect;
		} else			/* spc multiple of headcount */
		    io->i_st.nsect = spc / io->i_st.ntpc;
	    }

	    /* spc now ok; if still unequal, drop cylinders at end */
	    if ((io->i_st.nsect * io->i_st.ntpc * io->i_st.ncyl) != spd)
		io->i_st.ncyl = spd / spc;
	}
	io->i_st.nspc = io->i_st.nsect * io->i_st.ntpc;
	io->i_st.off = NULL;
	return (0);
}

#ifdef	DISK_FORMAT
static char buf[100];
#define	BSIZE	400
static u_short fmtlist[BSIZE];
static u_char deflist[BSIZE];

qdformat()
{
	register struct scsi_cmnd	*cmd;
	register struct scsi_cdb	*cdb;
	int	unit, cont, target, lun, count, i;
	char	test;
	u_int	pat = 0;		/* default data pattern for format */
	u_int	ilv = 0;		/* default interleave value */
	u_char	fmtdata = 0;		/* default format data bit */
	u_char	cmplist = 0;		/* default complete list bit */
	u_char	listfmt = 0;		/* default defect list format */
	u_char	listsize = 0;		/* default defect list length */

	qd_formatting = 1;
	printf("\nFormatting QD disk\n");
loop:
	printf("\nFunctions available:\n");
    	printf(" a) Format Disk\n b) Reassign Bad Blocks\n \n");
	printf("\nEnter letter of desired function: ");
	stripwhite(gets(buf));
	test = buf[0];
	if (test != 'a' && test != 'A' && test != 'b' && test != 'B')
		goto loop;
    ctl:printf("Controller number (0-%d) ? ", NQD-1);
	stripwhite(gets(buf));
	cont = getnum(buf);
	if (cont < 0 || cont >= NQD) {
		printf("illegal controller number\n");
		goto ctl;
	}
	if (qsopen(QDU_QSCTLR(QD_UNIT(cont, 0, 0)))) {
		printf("controller %d not found\n", cont);
		goto ctl;
	}
    dev:printf("Target number (0-%d) ? ", NQD_DEV-1);
	stripwhite(gets(buf));
	target = getnum(buf);
	if (target < 0 || target >= NQD_DEV) {
		printf("illegal target number\n");
		goto dev;
	}
    lun:printf("Logical Unit number (0-%d) ? ", NQD_LUN-1);
	stripwhite(gets(buf));
	lun = getnum(buf);
	if (lun < 0 || lun >= NQD_LUN) {
		printf("illegal logical unit number\n");
		goto lun;
	}
	unit = QD_UNIT(cont, target, lun);
	cdb = &qd_tmpcdb;
	cmd = (struct scsi_cmnd *) qsgetcmd(QDU_QSCTLR(unit));

	if (qsopen(QDU_QSCTLR(unit)) || qdinq(unit)) {
		printf("qd%d: target not responding\n", unit);
		goto loop;
	}

	if (test == 'a' || test == 'A') {	/* FORMAT DRIVE */
	    printf("Use default parameters? Y\b");
	    stripwhite(gets(buf));
	    if (buf[0] == 'N' || buf[0] == 'n') {
		printf("Data Pattern for format(0-256)? (default=%d) ", pat);
		    stripwhite(gets(buf));
		if (buf[0])
		    pat = getnum(buf);
		printf("Interleave factor X:1? (default=%d) ", ilv);
		stripwhite(gets(buf));
		if (buf[0])
		    ilv = getnum(buf);
		printf("FMTDATA bit (0-1)? %x\b", fmtdata);
		stripwhite(gets(buf));
		if (buf[0])
		    fmtdata = getnum(buf);
		printf("CMPLIST bit (0-1)? %x\b", cmplist);
		stripwhite(gets(buf));
		if (buf[0])
		    cmplist = getnum(buf);
		printf("Defect List Format (0-7)? %x\b", listfmt);
		stripwhite(gets(buf));
		if (buf[0])
		    listfmt = getnum(buf);
		if (fmtdata) {
		    printf("Size of defect data in 16 bit words (0-255)? %x\b",
			listsize);
		    stripwhite(gets(buf));
		    if (buf[0])
			listsize = getnum(buf);
		    if (listsize) do {
			for (i=0; i<listsize; i++) {
			    printf("word %2d: %4x    : ", i, fmtlist[i]);
			    stripwhite(gets(buf));
			    if (buf[0])
				fmtlist[i] = getnum(buf);
			}
			printf("see it again? N\b");
			stripwhite(gets(buf));
			i = buf[0];
		    } while (i == 'y' || i == 'Y');
		}
	    }

	    i = ((((fmtdata&1)<<4)|((cmplist&1)<<3)|(listfmt&7))<<16) |
		(pat << 8) | (ilv >> 8);
	    SET_CDB_0(cdb, CMD_FORMAT, QDU_LUN(unit), i, ilv, 0, 0);
	    SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    	LEN_STATUS, fmtlist, listsize << 1, 0);
    	    cmd->sc_dat2lnk = cmd->sc_datlnk;
	    sprintf(cmd->dbgmsg,"scsi cmd=CMD_MSENSE, lun=%d\n",lun);
	    printf("WARNING: this test destroys disk contents\n");
	    printf("Do you want to proceed? (y or n) ");
	    stripwhite(gets(buf));
	    if (buf[0] != 'y' && buf[0] != 'Y')
		goto loop;

	    count = 0;
	    while (1)
		switch (qdissue2("FORMAT", cmd, unit, 0)) {
		    case 0:	printf("SUCCESSFUL FORMAT\n");
				goto loop;
		    case  -1:	printf("retry ? N\b");
				stripwhite(gets(buf));
				if (buf[0] == 'y' || buf[0] == 'Y')
				    break;
				else
				    goto loop;
		    case  1:	if (++count == QD_MAXRETRY)
				    goto loop;
		}
	} else if (test == 'b' || test == 'B') { /* REASSIGN DEFECTIVE BLOCKS */
	    printf("Enter Logical Block Addresses in decimal: <CR> to end list\n");
	    for (i=1;i<100;i++) {
		printf("lba:   ");
		stripwhite(gets(buf));
		if (buf[0] == 0)
		    break;
		*(u_int *)&fmtlist[i*4] = getnum(buf);
	    }
	    *(u_int *)fmtlist = (i-1)*4;

	    SET_CDB_0(cdb, CMD_REASSIGN, QDU_LUN(unit), 0, 0, 0, 0);
	    SET_CMD(cmd,0,cdb,sizeof(struct cdb_0),qd_status,SFN_NOT_FINISHED,
	    	LEN_STATUS, fmtlist, i * 4, 0);
    	    cmd->sc_dat2lnk = cmd->sc_datlnk;
	    sprintf(cmd->dbgmsg,"scsi cmd=CMD_MSENSE, lun=%d\n",lun);
	    count = 0;
	    while (1)
		switch (qdissue2("REASSIGN", cmd, unit, 0)) {
		    case  0:	printf("SUCCESSFUL REASSIGNMENT\n");
				goto loop;
		    case  -1:	printf("retry ? N\b");
				stripwhite(gets(buf));
				if (buf[0] == 'y' || buf[0] == 'Y')
				    break;
				else
				    goto loop;
		    case  1:	if (++count == QD_MAXRETRY)
				    goto loop;
		}
	}
}
#endif	DISK_FORMAT
