/*#define	BAD144DEBUG	/* */
#include "saio.h"
#include "sais68k.h"

# define min(x,y) (x<y ? x : y)

int forbb;
union {
        struct dkbad x_dkbad;
        int x_pad[((sizeof(struct dkbad)+511) >> 9) << 9];
} dkbad [NFILES];

int lastreg;

/*
 * Note... this routine does not
 * really allocate; unless bdp == 1
 * you always get the same space.
 * When bdp == 1 you get some other space.
 */
qbsetup(io, bdp)
	register struct iob *io;
	int bdp;
{
#ifdef	M68030
	register int npf, i, o, reg;
	register unsigned v;

	v = btop(io->i_ma);
	o = (int)io->i_ma & PGOFSET;
	npf = btoc(io->i_cc + o);
	i = reg = lastreg;
	if (bdp)
		lastreg += npf;
	while (npf-- != 0) {
		*(short *)&vme_short[VDMA_MAP_ADDR(i,vbnum)] = v++;
		i++;
	}
	return ((reg << PGSHIFT) | o);
#else	M68030
	return(io->i_ma);
#endif	M68030
}

badstrat(io, sbn, len, func, strat, read)
register struct iob *io;
register int sbn, len;
register int func, read;
int (*strat)();
{
	register int i, lo, hi;
	register int lbn = sbn + ((len+511) >> DEV_BSHIFT) - 1;
	register struct dkbad *bad = (struct dkbad *)(&dkbad[io - iob]);
	register int badbn = io->i_st.ncyl*io->i_st.nspc - io->i_st.nsect;
	register int sz;
	register int bbn;
	int nbs;
	int savema = io->i_ma;

# define ncpd io->i_st.ncyl
# define ntrks io->i_st.ntpc
# define nspt io->i_st.nsect

	/*
	 * if the bad sector map has not yet been read in then read it in
	 * and convert from DEC-144 (cyl/trk/sec) to block number.
	 */
retry:	if (bad->bt_csn == 0) {
		nbs = 0;
		io->i_ma = paddr(bad);
		if ((*strat)(io,badbn,sizeof(struct dkbad),read) == -1) {
			printf("can't read bad sector map\n");
			io->i_ma = savema;
			goto done;	/* so we'll keep trying */
		}
#ifdef	BAD144DEBUG
		printf("read bad144 map from block %d\n", badbn);
#endif	BAD144DEBUG
		io->i_ma = savema;
		if (bad->bt_csn != 0 && bad->bt_flag == 0) {
		    for (i = 0; i < MAXBADBLK; i++) {
		   	if (bad->bt_bad[i].bt_cyl == 0xFFFF)
	    		    bad->bt_bad[i].bt_bn = -1;
			else if ((bad->bt_bad[i].bt_cyl >= ncpd) ||
			 ((bad->bt_bad[i].bt_trksec >> 8) >= ntrks) ||
			 ((bad->bt_bad[i].bt_trksec & 0xff) >= nspt)) {
				printf("bad bad144 map\n");
				bad->bt_csn = -1;
				break;
		        } else {
#ifdef	BAD144DEBUG
				printf("(cyl %d,trk %d,sec %d)",
				    bad->bt_bad[i].bt_cyl,
				    (bad->bt_bad[i].bt_trksec>>8) & 0xff,
		            	    bad->bt_bad[i].bt_trksec&0xff);
#endif	BAD144DEBUG
	    	    		bad->bt_bad[i].bt_bn = 
				   (((bad->bt_bad[i].bt_cyl * ntrks) +
				   ((bad->bt_bad[i].bt_trksec>>8)&0xff)) *nspt)+
				    (bad->bt_bad[i].bt_trksec&0xff);
				nbs++;
#ifdef	BAD144DEBUG
				printf("[blk %d] remapped to %d\n",
				    bad->bt_bad[i].bt_bn, badbn - nbs);
#endif	BAD144DEBUG
				
		        }
			
		    }
#ifdef	BAD144DEBUG
		    if (nbs != 0)
			    printf("%d remapped sectors\n", nbs);
#endif	BAD144DEBUG
		    bad->bt_csn = 1;
		    bad->bt_mbz = nbs;
		} else
		    bad->bt_csn = -1;
	}

	/* binary search the bad sector map for remapped sectors */
	if (bad->bt_csn == 1 && bad->bt_mbz) {
	    lo = 0;
	    while (sbn <= lbn) {
	    	hi = bad->bt_mbz-1;
		while ((hi - lo) > 1) { /**/
			i = lo + (hi - lo)/2;
			if (bad->bt_bad[i].bt_bn == sbn)
				hi = lo = i;
			else if (bad->bt_bad[i].bt_bn < sbn)
				lo = i;
			else
				hi = i;
		}
		if (bad->bt_bad[lo].bt_bn >= sbn)
			hi = lo;
		bbn = bad->bt_bad[hi].bt_bn;

#ifdef	BAD144DEBUG
printf("sbn %d bbn %d lbn %d\n", sbn, bbn, lbn);
#endif	BAD144DEBUG
		if (bbn < sbn || bbn > lbn)	/* transfer from sbn to lbn */
			goto done;
#ifdef	BAD144DEBUG
printf("*** sbn %d bbn %d lbn %d\n", sbn, bbn, lbn);
#endif	BAD144DEBUG
		if (sbn < bbn) {	/* transfer from sbn to bbn */
			sz = min(len,(bbn - sbn) * 512);
			if ((*strat)(io,sbn,sz,func) == -1)
				return -1;
			io->i_ma += sz;
			len -= sz;
		}
		sz = min(len, 512);	/* transfer remapped bbn */
		/* badbn = io->i_st.ncyl*io->i_st.nspc - io->i_st.nsect */
		if ((*strat)(io, (badbn - 1) - hi, sz, func) == -1) {
			printf("bad block in remap area!\n");
			return -1;
		}
		io->i_ma += sz;
		len -= sz;
		sbn = bbn+1;
	    }
	    return 0;
	}
done:	i = (*strat)(io,sbn,len,func);
	io->i_ma += len;
	return (i);
}

/* clear the in memory bad144 map for the unit */
badclose(io)
register struct iob *io;
{
	bzero((caddr_t)(&dkbad[io - iob]), sizeof(struct dkbad));
}
