
/* This set of diagnostics are made from the short stand alone tests
 * written originally by Paul Sheen during initial testing of the 
 * 68030 CPU board.  They are not, nor are they intended to be, a 
 * complete and through test of each component part represented.
 *
 *	 cache, fpu, nvram, siotest, softint, timer, vdma, mem,  DEBUG
 *
 */

#include	"saio.h"
#include "sais68k.h"
#include "../dev/sioreg.h"

#define devtoblk(x)	((x)/ NCPB)
#define devtochan(x)	((x)% NCPB)
struct siochan 	 	*sio_addr[NSIO];
struct sioblock 	*blk_addr[NBLOCKS];
extern	int dorte;
static int	sio_hdlr();
extern int	ignore_intr;
extern short	scr;

extern	int (*user_exit)();
/*
#include	<setjmp.h>
jmp_buf	menu;
jmp_buf prom_task;
*/

extern	int enter_debug();
char buf[80];
int	go_no_go;
int	keybd_intr = 0;
int p_softint(), p_timer(),	p_fpu(), p_vdma(), p_cache();

#define NUMBER_OF_SELECTIONS 	5
int (*test[NUMBER_OF_SELECTIONS])() =
		{ p_softint, p_timer, p_fpu, p_vdma, p_cache} ;

prom_diags()
{
	int  rec_error, i;
	char c;

	print_menu();
	while (1) {
		user_exit = 0;
		rec_error = 0;
		printf("\nDIAGS->: ");
cloop:
		c = wgetlocal();
		c = (c >= 'A' && c <= 'Z') ? c +0x20: c;
		if((c > 0x1f) && (c != 0x20)) putchar(c);
		switch (c) {
			case '':
				return(1);
			case '':
				break;
			case '1':
				go_no_go = (go_no_go)? 0: 1;
				break;
			case 'c':
				p_cache();
				break;
			case 'f':
				p_fpu();
				break;
			case 'g':
				go_no_go++;
				i = 0;
				do {
					rec_error = (*test[i++])();
				} while ((! rec_error) && i < NUMBER_OF_SELECTIONS);
				go_no_go--;
				break;
			case 'i':
				p_siotest();
				break;
			case '&':
				nvram();
				break;
			case 'm':
				p_mem();
				break;
			case 's':
				p_softint();
				break;
			case 't':
				p_timer();
				break;
			case 'v':
				p_vdma();
				break;
			case '|':
				user_exit = 0;
				enter_debug();

			case 'x':
				printf("\n");
				return(0);
			case ' ':
			case '\t':
				printf("\b ");
				goto cloop;
			case '\n':
				break;
			case 'h':
			case '?':
			default:
				print_menu();
				break;
		}
	}
}

print_menu()
{
	printf("\n--- %i PROM Version of Standalone Diagnostics---\n");
	printf("\n    1 -  set GO_NO_GO flag %s", (go_no_go)? "off" : "on");
	printf("\n    c -  Cache test");
	printf("\n    f -  Fpu test");
	printf("\n    g -  run Go_no_go tests (s,t,f,v,c)");
	printf("\n    h -  Print Menu");
	printf("\n    i -  sIotest");
	printf("\n    m -  Memory test");
	printf("\n    s -  Softint test");
	printf("\n    t -  Timer test");
	printf("\n    v -  Vdma test");
	printf("\n    | -  enter DEBUG");
	printf("\n    & -  nvram utility");
	printf("\n    x -  eXit to monitor");
}

/*********  END OF FILE ********/
