char buf[80];
int lerrs;
int terrs;
int toterrs;

#include "../h/param.h"
#include "../machine/board.h"
#include "../machine/pte.h"

main()
{
	register int i, v, x, *p, n;

	printf("\n--- %i Standalone MMU Mapping Diagnostic ---\n\n");
loop:	printf("\nDisplay mapping of:\n");
	printf("  a) TBUF\n  b) PTP\n");
	printf("  c) PTES\n");
#ifdef	M68025C
	printf("  d) VDMA\n");
	printf("  e) CACHE\n");
#endif	M68025C
	printf("\nEnter letter of functionality: ");
	stripwhite(gets(buf));
	if (buf[0] == 'a') {
	    printf("  a) SYSTEM\n  b) USER\n");
	    printf("Display mapping of: ");
	    stripwhite(gets(buf));
	    if (buf[0] == 'a')
		p = (int *)TBUF_BASE_SYS;
	    else if (buf[0] == 'b')
		p = (int *)TBUF_BASE_USR;
	    else 
		goto loop;
	    for (i = 0, n = 0; i < NTBUFS ; i++, p += TBUF_INCR/sizeof(int) ) {
		v = *p & TBUF_MASK;
		if (v & TBUF_VALID) {
			printf("%x: %b -> %x\n",p,v,TBUF_BITS, 
				(v&PG_PFNUM)<<PGSHIFT);
			n++;
		}
		if (((n+1)%22) == 0) {
			n = 0;
			printf("  More (%d%%): ",(i*100)/NTBUFS);
			stripwhite(gets(buf));
			if (buf[0] == 'q') goto loop;
		}
	    }
	} else if (buf[0] == 'b') {
	    printf("Enter context number (x for as is): ");
	    stripwhite(gets(buf));
	    if (buf[0] != 'x')
	    	*CTX = (char)gethex(buf);
	    p = (int *)PTP_BASE;
	    for (i = 0, n = 0 ; i < NPTPS ; i++, p += PTP_INCR/sizeof(int) ) {
		v = *p & PTP_MASK;
		x = ((v<<PGSHIFT)|((v&PTP_LSB)>>PTP_LSBSHIFT))&PTP_ADRMASK;
		if (v != PTP_INVALID) {
			printf("%x: %x -> %x\n",p,v, x);
			n++;
		}
		if (((n+1)%22) == 0) {
			n = 0;
			printf("  More (%d%%): ",(i*100)/NPTPS);
			stripwhite(gets(buf));
			if (buf[0] == 'q') goto loop;
		}
	    }
	} else if (buf[0] == 'c') {
	    printf("Enter address of PTE's in non translated space: ");
	    stripwhite(gets(buf));
	    p = (int *)gethex(buf);
	    for (i = 0, n = 0 ; i < 1024 ; i++, p++) {
		v = *p;
		if (v & PG_V) {
			printf("%x: %b -> %x\n",p,v,PG_BITS,
				(v&PG_PFNUM)<<PGSHIFT);
			n++;
		}
		if (((n+1)%22) == 0) {
			n = 0;
			printf("  More (%d%%): ",(i*100)/1024);
			stripwhite(gets(buf));
			if (buf[0] == 'q') goto loop;
		}
	    }
	}
#ifdef	M68025C
	else if (buf[0] == 'd') {
	    p = (int *)VDMA_BASE;
	    for (i = 0, n = 0 ; i < NVDMAS ; i++, p += VDMA_INCR/sizeof(int) ) {
		v = *p & VDMA_MASK;
		if (v & VDMA_VALID) {
		    register int j = i, k;

		    for (k = 0; i<NVDMAS ; k++, i++, p+=VDMA_INCR/sizeof(int))
			if ((*p & VDMA_MASK) != v+k)
				break;
		    printf(" %x - %x  ->  %x - %x\n",
			j << PGSHIFT, (j+k)<<PGSHIFT,
			(v&(~VDMA_VALID))<<PGSHIFT,
			((v+k)&(~VDMA_VALID))<<PGSHIFT);
		    n++;
		    if (((n+1)%22) == 0) {
			n = 0;
			printf("  More (%d%%): ",(i*100)/NPTPS);
			stripwhite(gets(buf));
			if (buf[0] == 'q') goto loop;
		    }
		}
	    }
	} else if (buf[0] == 'e') {
		register int *tag_a, *tag_b, *ctl, *dat_a, *dat_b;
		register int tag_av, tag_bv, ctlv, adr;

		printf("\
                 TAG                 DATA                               PADDR\n");
		for (i = 0, n = 0; i < NCTAGS; i++) {
		    tag_a = (int *)(CTAG_A_BASE + CTAG_INCR*i);
		    tag_b = (int *)(CTAG_B_BASE + CTAG_INCR*i);
		    ctl = (int *)(CTAG_CTL_BASE + CTAG_INCR*i);
		    dat_a = (int *)(CDAT_A_BASE + CDAT_WINCR*i);
		    dat_b = (int *)(CDAT_B_BASE + CDAT_WINCR*i);
		    tag_av = *tag_a;
		    tag_bv = *tag_b;
		    ctlv = *ctl;
		    if (tag_av & CTAG_VALID) {
			adr = ((tag_av&CTAG_MATCH)<<PGSHIFT)|(i<<CDAT_W_SHIFT);
			printf("%3d_A %8x:%4x ", i, tag_a,tag_av&CTAG_MATCH);
			printf("%c", (tag_av & CTAG_VALID) ? 'V' : ' ');
			printf("%c", (ctlv & CTAG_A_USEDLAST) ? 'U' : ' ');
			printf("%c", (ctlv & CTAG_A_DIRTY) ? 'D' : ' ');
			printf(" %8x:%8x %8x %8x %8x: ", dat_a,*dat_a,
			    *(dat_a+1),*(dat_a+2),*(dat_a+3));
			printf("%7xX\n", adr >> CDAT_W_SHIFT);
			n++;
		    }
		    if (tag_bv & CTAG_VALID) {
			adr = ((tag_bv&CTAG_MATCH)<<PGSHIFT)|(i<<CDAT_W_SHIFT);
			printf("%3d_B %8x:%4x ", i, tag_b,tag_bv&CTAG_MATCH);
			printf("%c", (tag_bv & CTAG_VALID) ? 'V' : ' ');
			printf("%c", (ctlv & CTAG_A_USEDLAST) ? ' ' : 'U');
			printf("%c", (ctlv & CTAG_B_DIRTY) ? 'D' : ' ');
			printf(" %8x:%8x %8x %8x %8x: ", dat_b,*dat_b,
			    *(dat_b+1),*(dat_b+2),*(dat_b+3));
			printf("%7xX\n", adr >> CDAT_W_SHIFT);
			n++;
		    }
		    if (((n/2)+1)%12 == 0) {
			n = 0;
			printf("  More (%d%%): ",(i*100)/NCTAGS);
			stripwhite(gets(buf));
			if (buf[0] == 'q') goto loop;
			printf("\
                 TAG                 DATA                               PADDR\n");
		    }
		}
	}
#endif	M68025C
	goto loop;
}
