#include "../h/param.h"
#include <setjmp.h>
#include <ctype.h>

extern int has_gip;		/* gip exists */

extern int (*putch)();
extern int (*getch)();
char	*prf_bufp;
char	*gets(), *getsi(), *stripwhite(), *striplwhite(), *zerowhite();

int	(* user_exit)() = 0;

/*
 * Scaled down version of C Library printf. Used to print diagnostic 
 * information directly on console tty.  Since it is not interrupt driven, 
 * all system activities are suspended.  Printf should not be used for 
 * chit-chat.
 *
 * One additional format: %b is supported to decode error registers.
 * Usage is:
 *	printf("reg=%b\n", regval, "<base><arg>*");
 * Where <base> is the output base expressed as a control character, e.g. \10 
 * gives octal; \20 gives hex. If the high bit of <base> is set then regval is 
 * negated. Each arg is a sequence of characters, the first of which gives the 
 * bit number to be inspected (origin 1), and the next characters (up to a 
 * control character, i.e. a character <= 32), give the name of the register. 
 * Thus
 *	printf("reg=%b\n", 3, "\10\2BITTWO\1BITONE\n");		and
 *	printf("reg=%b\n", 0xFC, "\210\2BITTWO\1BITONE\n");
 * would produce output:
 *	reg=3<BITTWO,BITONE>
 */
#define	TOCONS	0x01
#define	TOBUF	0x02

/*VARARGS1*/
printf(fmt, x1)
	char *fmt;
	unsigned x1;
{
	prf(fmt, &x1, TOCONS);
}

sprintf(buf, fmt, x1)
	char *buf;
	char *fmt;
	unsigned x1;
{

	prf_bufp = buf;
	prf(fmt, &x1, TOBUF);
	*prf_bufp++ = '\0';
	return (prf_bufp - buf);
}

perror(fmt, x1)
	char *fmt;
	unsigned x1;
{
	_blink_errled();		/* blink error led */
	prf(fmt, &x1, TOCONS);		/* print error message */
#ifdef	notdef
	if (getlocal())			/* return nonzero if aborted */
		return 1;
	else
#endif	notdef
		return 0;
}

prf(fmt, adx, flags)
	register char *fmt;
	register u_int *adx;
{
	register int b, c, i, p, pad;
	char *s;
	int any;

loop:
	while ((c = *fmt++) != '%') {
		if (c == '\0')
			return;
		prf_putchar(c, flags);
	}
	p = 0;
	pad = 0;
again:
	if ((c = *fmt++) == '\0')
		return;
	if (p == 0 && (c == '-' || c == '+')) {
		pad++;
		goto again;
	}
	if (p == 0 && c >= '0' && c <= '9') {	/* number of places */
		do {
			p = (p * 10) + (c - '0');
			if ((c = *fmt++) == '\0')
				return;
		} while (c >= '0' && c <= '9');
	}

	/* THIS CODE IS VAX DEPENDENT IN HANDLING %l? AND %c */
	switch (c) {

	case 'l':
		goto again;
	case 'x': case 'X':
		b = 16;
		goto number;
	case 'd': case 'D':
	case 'u':		/* what a joke */
		b = 10;
		goto number;
	case 'o': case 'O':
		b = 8;
number:
		printn((u_long)*adx, b, p, flags);
		break;
	case 'a':		/* address */
		printn((u_long)*adx, 16, 8, flags);
		break;
	case 'c':
#ifdef	vax
		b = *adx;
		for (i = 24; i >= 0; i -= 8)
			if (c = (b >> i) & 0x7f)
				prf_putchar(c, flags);
#endif	vax
#ifdef	is68k
		c = *adx;
		prf_putchar(c, flags);
#endif	is68k
		break;
	case 'b':
		b = *adx++;
		s = (char *)*adx;
		c = *s++;
		i = c & 0x80;
		c &= 0x7F;
		printn((u_long)b, c, 0, flags);
		if (i)
			b = ~b;
		any = 0;
		if (b) {
			while (i = *s++) {
				if (b & (1 << (i-1))) {
					prf_putchar( any ? ',' : '<', flags);
					any = 1;
					for (; (c = *s) > 32; s++)
						prf_putchar(c, flags);
				} else
					for (; *s > 32; s++)
						;
			}
			if (any)
				prf_putchar('>', flags);
		}
		break;

	case 's':
		s = (char *)*adx;
	str:	if (p == 0) {
		    while ((c = *s++))
			prf_putchar(c, flags);
		} else if (pad) {
		    while ((c = *s++)) {
			prf_putchar(c, flags);
			p--;
		    }
		    c = ' ';
		    while (p-- > 0)
			prf_putchar(c, flags);
		} else {
		    while ((c = *s++) && p--)
			prf_putchar(c, flags);
		}
		break;

	case '%':
		prf_putchar('%', flags);
		break;

	case 'm':
		i = (int)*adx;
		b = i >> 20;
		printn(b, 10, 0, flags);
		if (p == 0) {
			prf_putchar('.', flags);
			b = 99-(((0x100 - ((i>>12)&0xFF))*99)/0x100);
			if (b < 10)
				prf_putchar('0', flags);
			printn(b, 10, 0, flags);
		}
		break;

	case 'e':		/* print out ethernet address */
		for (s = (char *)*adx, i = 0 ; i < 6 ; i++, s++) {
			printn((*s)&0xFF, 16, 0, flags);
			if (i < 5)
				prf_putchar(':', flags);
		}
		break;

	case 'i':		/* identify bus/cpu type */
# ifdef	QX
		s = "Liberator "; /**/
/*		s = "TORCH VME32QX "; /**/
# else	QX
# ifdef	M68030
		s = "VMEBUS 68030 ";
# else	M68030
# ifdef	M68020
#   ifdef	M68025
		s = "VMEBUS 68225 ";
#   else	M68025
		s = "VMEBUS 68020 ";
# endif	M68025
# endif	M68020
# endif M68030
# endif QX
		for (; c = *s; s++)
			prf_putchar(c, flags);
		s = REV;
		for (; c = *s; s++)
			prf_putchar(c, flags);
		goto loop;
	}
	adx++;
	goto loop;
}

/*
 * Printn prints a number n in base b using p places.
 * We don't use recursion to avoid deep kernel stacks.
 */
printn(n, b, p, flags)
	u_long n;
{
	char prbuf[32];
	register char *cp = prbuf;
	register int np = 0;

	if (b == 10 && (int)n < 0) {
		prf_putchar('-', flags);
		n = (unsigned)(-(int)n);
	}
	do {
		/*	*cp++ = "0123456789abcdef"[n%b];
		 */
		*cp++ = "0123456789ABCDEF"[n%b];
		n /= b;
		np++;
	} while (n);
	if (p) {
		while (np++ < p)
			if (b == 10)
				prf_putchar(' ', flags);
			else
				prf_putchar('0', flags);
	}
	do
		prf_putchar(*--cp, flags);
	while (cp > prbuf);
}

prf_putchar(c, flags)
{
	if (flags & TOCONS)
		(*putch)(c);
	if (flags & TOBUF)
		*prf_bufp++ = c;
}

char *
stripwhite(buf)
	char *buf;
{
	register char c;
	register char *s1, *s2;

	for (s1 = s2 = buf ;  c = *s2 ; s2++)
		if (c != ' ' && c != '\t')
			*s1++ = c;
	*s1 = c;
	return (buf);
}

char *
striplwhite(buf)		/* remove leading white space */
	char *buf;
{
	register char *s1, *s2;

	for (s2 = buf ; *s2 == ' ' || *s2 == '\t'; s2++)
		;
	for (s1 = buf ;  *s2 ;)
		*s1++ = *s2++;
	*s1 = 0;
	return (buf);
}

char *
zerowhite(buf)
	char *buf;
{
	register char *s = buf;

	for (s = buf;  *s;  s += 1)
		if (*s == ' ' || *s == '\t')
			*s = '\0';
	return (buf);
}

char *
gets(buf)
	char *buf;
{
	return (getsi(buf, 0));
}

char *
getsi(buf, i)
	register char *buf;
{
	register char *lp = &buf[i];
	register int c;

	for (;;) {
		c = (*getch)() & 0x7F;
		switch(c) {
		case '\n':
		case '\r':
			c = '\n';
			*lp++ = '\0';
			return(buf);

		case '':
			(*putch)('\b');
		case '\b':
			lp--;
			if (lp <= buf)
				lp = buf;
			else {
				(*putch)(' ');
				(*putch)('\b');
			}
			*lp = 0;
			break;

		case 'u'&037:
			lp = buf;
			(*putch)('\n');
			break;

		case 0x03:		/* ^C */
		case 0x04:		/* ^D */
			if (user_exit) {
				*lp++ = c;
				*lp = '\0';
				(* user_exit)(buf);
			} exit ();

		default:
			*lp++ = c;
		}
	}
	return(buf);
}

getnum(string)
	unsigned char *string;
{
	register unsigned char *sp = string;
	register unsigned char c;
	register int base, num, digit;

	num = 0;
	while ((c = *sp) == ' ' || c == '\t')
		sp++;
	if (*sp == '0') {
		sp++;
		if (*sp == 'x' || *sp == 'X') {
			sp++;
			base = 16;
		} else
			base = 8;
	} else
		base = 10;

	while (c = *sp++) {
		switch (base) {
		  case 8:
			if ('0' <= c && c <= '7') {
				digit = c - '0';
				break;
			} else {
				printf("Invalid octal digit (%c)\n", c);
				return -1;
			}

		  case 16:
			digit = ctoh(c);
			if (digit == -1) {
				printf("Invalid hex digit (%c)\n", c);
				return -1;
			} else
				break;

		  case 10:
			if ('0' <= c && c <= '9') {
				digit = c - '0';
				break;
			} else {
				printf("Invalid decimal digit (%c)\n", c);
				return -1;
			}
		}
		num = num*base + digit;
	}
	return num;
}

gethex(string)
	char *string;
{
	register char *cp = string;
	register int c, n;

	n = 0;
	while (c = *cp++)
		if ((c = ctoh(c)) != -1)
			n = n * 16 + c;
		else 
			return getnum(string);
	return(n);
}

getfield(field, value, base, min, max, err_jmp_buf)
	char	*field;
	u_int	value;
	jmp_buf err_jmp_buf;
{
	register int	i = 0, j = 0, x = value;
	char		backspace[9];
	int		newvalue;
	static char	buf[100];

	x = value;
	i = 0;
	do {
		backspace[i] = '\b';
		i++;
		x /= base;
	} while (x);
	backspace[i] = 0;
range: if (min != max) {
	    if (base == 10)
		sprintf(buf,"%s (%d-%d)", field, min, max);
	    else
		sprintf(buf,"%s (0x%x-0x%x)", field, min, max);
	} else
		sprintf(buf,"%s", field);
	if (has_gip) {
		if (base == 10)
		    printf("    %+40s: [%d] ", buf, value);
		else
		    printf("    %+40s: [0x%x] ", buf, value);
	} else {
		if (base == 10)
		    printf("    %+40s: %d%s", buf, value, backspace);
		else
		    printf("    %+40s: 0x%x%s", buf, value, backspace);
	}
	buf[0] = 0;
	gets(buf);
	if (buf[0] && !isxdigit(buf[0]) && err_jmp_buf)
		longjmp(err_jmp_buf, 1);
	if (sscanf(buf, base == 10 ? 'd' : 'x', &newvalue) < 0)
		newvalue = value;
	if (min != max && ((newvalue < min) || (newvalue > max)))
		goto range;
	value = x = newvalue;
	j = 0;
	do {
		j++;
		x /= base;
	} while (x);
	if (j < i && (has_gip == 0)) {
	    if (base == 10)
		printf("    %+39s*: %d\n", " ", value);
	    else
		printf("    %+39s*: 0x%x\n", " ", value);
	}
	return value;
}

getbits(field, bit, value)
	char		*field;
{
	static char	buf[100];

	printf("    %+40s: ",field);
	if (has_gip == 0) {
		if (value & bit)
			printf("Y\b");
		else
			printf("N\b");
	} else {
		if (value & bit)
			printf("[Y] ");
		else
			printf("[N] ");
	}
	buf[0] = 0;
	gets(buf);
	if (value & bit) {
		if (buf[0] == 'n' || buf[0] == 'N')
			value &= ~bit;
	} else {
		if (buf[0] == 'y' || buf[0] == 'Y')
			value |= bit;
	}
	return value;
}

ctoh(c)
register char c;
{
	if (c >= '0' && c <= '9')
		return (c - '0');
	else if (c >= 'a' && c <= 'f')
		return (c - 'a' + 10);
	else if (c >= 'A' && c <= 'F')
		return (c - 'A' + 10);
	else
		return -1;
}

exit()
{
	printf("\nExit called\n");
	_rtt();
}

sscanf(buf, flag, num)
	char		*buf;
	char		flag;
	unsigned int	*num;

{
	int		i;
	unsigned int	val;
	char		c;

	i  = -1;
	val = 0;
	while (1) {
		i++;
		c = buf[i];
		if (( c == 0 ) || ( c == '\n' ) || ( c == '\r' ))
			return(-1);
		else if (( c >= '0' ) && ( c <= '9' ))
			break;
		else if (( c >= 'a' ) && ( c <= 'f' )) {
			if ( flag == 'x' )
				break;
			else
				return(-1);
		} else if (( c >= 'A' ) && ( c <= 'F' )) {
			if ( flag == 'x' )
				break;
			else
				return(-1);
		} else if (( c == ' ' ) || ( c == '\t' ))
			continue;
		else
			return(-1);
	}

	if ( flag == 'd' ) {
		for ( ; ; ) {
			c = buf[i++];
			if (( c == 0 ) || ( c == '\n' ) || ( c == '\r' )
					|| ( c == ' ' ) || ( c == '\t' )) {
				*num = val;
				return(val);
			} else if (( c > '9' ) || ( c < '0' ))
				return(-1);
			else
				val = val*10 + c - '0';
		}
	}
	else if ( flag == 'x' ) {
		for ( ; ; ) {
			c = buf[i++];
			if (( c == 0 ) || ( c == '\n' ) || ( c == '\r' )
					|| ( c == ' ' ) || ( c == '\t' )) {
				*num = val;
				return(val);
			}
			else if (( c >= '0' ) && ( c <= '9' )) {
				val = val*16 + c - '0';
				continue;
			}
			else if (( c >= 'a' ) && ( c <= 'f' )) {
				val = val*16 + c + 10 - 'a';
				continue;
			}
			else if (( c >= 'A' ) && ( c <= 'F' )) {
				val = val*16 + c + 10 - 'A';
				continue;
			}
			else
				return(-1);
		}
	} else
		return(-1);
}
