/* 
 * standalone driver for parallax graphics controler
 */

#include "saio.h"
#include "sais68k.h"

struct plx_device {
        u_short csr;		/* command/status register */
        u_short cdr;		/* command/data register */
};

struct plx_wholedevice {
	struct plx_device plx;	/* graphics channel */
	struct plx_device vt;	/* terminal emulator */
	struct plx_device sa;	/* serial port A (mouse) */
	struct plx_device sb;	/* serial port B (kbd) */
};

#define PARALLAX ((struct plx_wholedevice *)&vme_short[0x400])
#define	IOCLEAR_DELAY	100		/* time to wait for an ioclear */
#define	REGISTER_DELAY	100		/* time to wait for an ioclear */

#define	CSR_RESET	0x8000
#define	CSR_WC		0x0002
#define	CSR_READY	0x0080
#define	SCSR_TXRDY	0x0400
#define	SCSR_TX9600	0x0b00
#define	SCSR_RX9600	0xb000

int plx_putloc();

*(plxinit())()
{

	register struct plx_wholedevice *plxaddr = PARALLAX;
	register int tries = 10000;
	register u_short saved_csr;
	short x;

	/* if the register does not exist then return null address */
	if (!probe(&plxaddr->plx.csr,&x))
		return 0;

	DELAY(REGISTER_DELAY);
	plxaddr->plx.csr = CSR_RESET;

	while (tries-- > 0) {
		DELAY(IOCLEAR_DELAY);
		saved_csr = plxaddr->plx.csr;
		DELAY(REGISTER_DELAY);
		if ((saved_csr == (CSR_READY|CSR_WC))||(saved_csr == CSR_WC)){
			return(plx_putloc);
		}
	}
	DELAY(REGISTER_DELAY);
	return (0);
}

plx_putloc(c)
{
	register struct plx_wholedevice *plxaddr = PARALLAX;

	if (plxaddr->vt.csr & SCSR_TXRDY) {
		plxaddr->vt.cdr = c;
		DELAY(REGISTER_DELAY);
		return(1);
	} else
		return(0);
}
