/* 
 * standalone driver for parallax graphics controler
 * comment following out definition of PARALLAX for stubs, see sio.c.
#define PARALLAX	(struct pdevice *)0x3ff0c0
 */

#include "../h/param.h"

#ifndef	PARALLAX
putparallax(c){}				/* stub */
#else	PARALLAX

#define XMAX_600	639			/* Parallax 600 */
#define YMAX_600	479			/* Parallax 600 */
#define XMAX_1000	1023			/* Parallax 1000 */
#define YMAX_1000	767			/* Parallax 1000 */
static short xmax = XMAX_600, ymax = YMAX_600;

#define XXX_600		16
#define YYY_600		20			/* >= CHAR_HEIGHT + DECENDER */
#define XXX_1000	30
#define YYY_1000	30			/* >= CHAR_HEIGHT + DECENDER */
static short xxx = XXX_600, yyy = YYY_600;

#define	COLOR_SCREEN	1			/* red */
#define	COLOR_LETTER	7			/* white */
#define CHAR_HEIGHT	16			/* height of character */
#define CHAR_LENGTH	8			/* length of char */
#define DECENDER	2			/* 1000 has decenders !! */

#define S_DELAY_600	30000			/* 30000 ok */
#define S_DELAY_1000	60000			/* 6 99000 ok */
#define B_DELAY_600	1000			/* 1000 ok */
#define B_DELAY_1000	2000			/* 3000 ok */
#define T_DELAY_600	500			/* 500 ok */
#define T_DELAY_1000	1000			/* 500 ok */
#define INIT_DELAY	50000			/* 50000 ok */
#define TAP_DELAY	100			/* 100 ok */
unsigned int scroll_delay = S_DELAY_600;
unsigned int blank_delay = B_DELAY_600;
unsigned int text_delay = T_DELAY_600;

struct pdevice {
	unsigned short csr;
	unsigned short cdr;
};

/* place a character on bottom line of screen */
#define pchar(p,x,c) 						\
	p->cdr = 0x0005;					\
				DELAY(TAP_DELAY);		\
	p->cdr = COLOR_LETTER;					\
				DELAY(TAP_DELAY);		\
	p->cdr = xxx + x;					\
				DELAY(TAP_DELAY);		\
	p->cdr = yyy;						\
				DELAY(TAP_DELAY);		\
	p->cdr = 1;						\
				DELAY(TAP_DELAY);		\
	p->cdr = c | (c << 8);					\
				DELAY(text_delay);

/* delete a character */
#define pdchar(p,x) 						\
	p->cdr = 0x0004;					\
				DELAY(TAP_DELAY);		\
	p->cdr = COLOR_SCREEN;					\
				DELAY(TAP_DELAY);		\
	p->cdr = xxx + x;					\
				DELAY(TAP_DELAY);		\
	p->cdr = yyy - DECENDER;				\
				DELAY(TAP_DELAY);		\
	p->cdr = xxx + x + CHAR_LENGTH - 1;			\
				DELAY(TAP_DELAY);		\
	p->cdr = yyy + CHAR_HEIGHT - 1;				\
				DELAY(blank_delay);

/* scroll screen up one line */
#define pscroll(p)	 					\
	p->cdr = 0x0304;					\
				DELAY(TAP_DELAY);		\
	p->cdr = xxx;						\
				DELAY(TAP_DELAY);		\
	p->cdr = ymax - CHAR_HEIGHT;	/**/			\
				DELAY(TAP_DELAY);		\
	p->cdr = xxx;						\
				DELAY(TAP_DELAY);		\
	p->cdr = ymax;			/**/			\
				DELAY(TAP_DELAY);		\
	p->cdr = xmax;						\
				DELAY(TAP_DELAY);		\
	p->cdr = yyy - DECENDER;				\
				DELAY(scroll_delay);

/* initialize screen */
#define pinit(p)	 					\
	p->csr = 0x8000;					\
				DELAY(INIT_DELAY);		\
	p->cdr = 0x0004;					\
				DELAY(TAP_DELAY);		\
	p->cdr = COLOR_SCREEN;					\
				DELAY(TAP_DELAY);		\
	p->cdr = 0;						\
				DELAY(TAP_DELAY);		\
	p->cdr = 0;						\
				DELAY(TAP_DELAY);		\
	p->cdr = xmax;						\
				DELAY(TAP_DELAY);		\
	p->cdr = ymax;						\
				DELAY(INIT_DELAY);

static int initparallax = 0;

putparallax(c)
register int c;
{
	static int col;
	static struct pdevice *pxaddr; 
	register struct pdevice *p = pxaddr;
	struct pdevice *parallaxinit();
	register int l;

	/* if uninitialized then initialize the device */
	if (!initparallax) {
		initparallax++;
		col = 1;
		p = pxaddr = parallaxinit();
	}

	/* if the controler was not there then return */
	if (p == 0)
		return;

	if (c == '\n') {
		pscroll(p);
		col = 1;
		return;
	} else if (c == '\r')
		return;
	else if (c == '\t') {
		for (l = 8 - ((col/CHAR_LENGTH)&7); l > 0 ; l--) {
			pchar(p, col, ' ');
			col += CHAR_LENGTH;
		}
		return;
	} else if (c == '\b') {
			col -= CHAR_LENGTH;
			if (col < 1)
				col = 1;
			pdchar(p, col);
			return;
	}

	pchar(p, col, c);
	col += CHAR_LENGTH;
	return;
}

struct pdevice *
parallaxinit()
{
	struct pdevice *pxaddr = PARALLAX;
	short x;

	/* if the register does not exist then return null address */
	if (!probe(&pxaddr->csr,&x))
		return 0;
	/* determine if the controler is a 600 or a 1000 */
	pxaddr->cdr = 0x002c;		/* issue SHOW command */
	DELAY(TAP_DELAY);
	if (pxaddr->cdr & 0x1c00) {	/* Hardware modle != 0 => 1000 */
		xmax = XMAX_1000;
		xxx = XXX_1000;
		ymax = YMAX_1000;
		yyy = YYY_1000;
		scroll_delay = S_DELAY_1000;
		blank_delay = B_DELAY_1000;
		text_delay = T_DELAY_1000;
	}
	pinit(pxaddr);
	return pxaddr;
}
#endif	PARALLAX
