
struct lunelem {
	struct scsi_cmnd *l_cmndptr;
	char l_state;
	char l_flags;
	char l_sync_trans;
	char l_identify;
};

/*
 * states. Alterable by the TDMAC.
 */
#define	L_ST_NULL	0
#define	L_ST_PENDING	1

/*
 * flags. Alterable by the MPU. The lowest 3 bits encode the
 * destination ID. If L_FL_CHK_PARITY is used it must be used
 * for all LUNs on the controller card.
 */
#define	L_FL_DESTMASK	0x07
#define	L_FL_SEL_ATN	0x08
#define	L_FL_CHK_PARITY	0x10
#define	L_FL_MANUAL	0x20



#define	LEN_STATUS	2


struct scsi_cmnd {
	struct sc_link sc_datlnk;	/* saved data pointer */
	struct sc_link sc_dat3lnk;	/* after each data transfer phase the
					 * current data pointer gets copied here
					 */
	char *sc_pcmnd;	/* pointer to command bytes */
	char *sc_pstat;	/* pointer to status bytes */
	char sc_ncmnd;	/* number of command bytes */
	char sc_nstat;	/* number of status bytes */
	char sc_finstat;	/* end status */
	char sc_pad;
	struct scsi_cmnd *sc_chain;
	struct lunelem *sc_ptrlun;
		/*
		 * All fields before this point are used by the Openchip.
		 * When the command is passed to scissue(), sc_dat2lnk should
		 * have been set up. scissue() will copy it into sc_datlnk and
		 * sc_dat3lnk each time the command has to be sent (multiple
		 * issuings are the result of a received BUSY response).
		 */
	char sc_status[LEN_STATUS];
	struct sc_link sc_dat2lnk;
	struct scsiproto *sc_proto;
	long sc_cmndlngth;	/* length of data transfer for the command */
	long sc_rqsnslngth;	/* length of data transfer for request sense */
	short sc_flags;
	char sc_retries;	/* maximum number of times to issue command */
	char dbgmsg[80];
};

#define	SET_CMD(cmd,chain,cdb,ncmnd,pstat,finstat,nstat,datptr,datcnt,flags) \
		{ bzero(cmd, sizeof (struct scsi_cmnd));		\
		(cmd)->sc_chain = (struct scsi_cmnd *) chain;		\
		(cmd)->sc_pcmnd = (char *) cdb;				\
		(cmd)->sc_ncmnd = ncmnd;				\
		(cmd)->sc_pstat = (char *) pstat;			\
		(cmd)->sc_finstat = finstat;				\
		(cmd)->sc_nstat = nstat;				\
		(cmd)->sc_datlnk.sl_ptr = (char *) datptr;		\
		(cmd)->sc_datlnk.sl_cnt = datcnt;			\
		(cmd)->sc_flags = flags;				}
/*
 * Note that the values taken by the sc_finstat and sc_flags fields are the
 * same values used by the sp_finstat and sp_flags fields of a scsiproto
 * structure.
 */

/*
 * values of sp_finstat. The Openchip can generate the first four. Others
 * explain why the software decided to try and abort the commands.
 */
#define	SFN_NOT_FINISHED	0
#define	SFN_NORMAL_END		1
#define	SFN_NO_CMND_CMPLT	2
#define	SFN_SLCT_TIMEOUT	3

#define	SFN_ABRT_REJ_MSG	4	/* a message rejection that the software couldn't recover from */
#define	SFN_ABRT_MSG_PRTY	5	/* there was a message parity error for  which the target didn't perform a message out phase */
#define	SFN_ABRT_MDFY_PTRS	6	/* a modify data pointer message moved the pointer back past the start */
#define	SFN_ABRT_BERR	7	/* a bus error occurred during DMA */

#define	SFN_INACTIVE	8	/* command block is inactive */
#define	SFN_STILL_BUSY	9	/* ran out of retries on receiving BUSY status */
#define	SFN_FUNNY_STATUS	10	/* any status other than good, check or busy */
#define	SFN_RQS_SNS_CHK	11	/* request sense command returned check status */
#define SFN_NOINTRFACE	12	/* no attached interface for this command */
#define SFN_TOO_MANY_BUFFERS 13	/* the attached interface didn't have the necessary buffers or other structures to handle this command */
#define SFN_ILL_PHASE	14	/* one of the two illegal phases occured */
#define SFN_STATOVFL	15	/* too many status bytes were sent */
#define	SFN_UNSPEC	16	/* unspecified error */

/*
 * bit positions in sp_flags.
 */
#define	SCF_RQS_SNS	0x0001		/* request sense issued */
#define	SCF_DATA_PRTY	0x0002		/* data transfer parity error */
#define SCF_DATA_OVFL	0x0004		/* data transfer exceeded allowed space */
#define SCF_COMM_OVFL	0x0008		/* command transfer exceeded allowed space */
#define SCF_STATUS_OVFL	0x0010		/* status transfer exceeded allowed space */
#define	SCF_UNSPEC_PHASE	0x0020		/* unspecified phase occurred */

#define SCF_FATAL_COMB	(SCF_DATA_PRTY | SCF_DATA_OVFL | SCF_COMM_OVFL | SCF_STATUS_OVFL | SCF_UNSPEC_PHASE)	/* the fatal flags */

/*
 * status byte values and mask pattern.
 */
#define	SC_STATUS_MASK	0x1e
#define	SCSTAT_GOOD	0x00
#define	SCSTAT_CHK	0x02
#define	SCSTAT_CONDITN	0x04
#define	SCSTAT_BUSY	0x08
#define	SCSTAT_INTERM	0x10
#define	SCSTAT_INTRCOND	0x14
#define	SCSTAT_RSRVCONF	0x18
