/*
 * bit values of the op_system register.
 */
#define	OP_SYS_MSIZE	1
#define	OP_SYS_CODE_MASK	0x1e
#define	OP_SYS_CODE_SHIFT	1	/* no> of right shifts to align code */

/*
 * the bits or'ed into the Openchip interrupt vector for the different sources.
 */
#define	OP_INT_MASK	0x07

#define	OP_INT_VIDEO	0
#define	OP_INT_CLOCK	1
#define	OP_INT_AUDIO	2
#define	OP_INT_KEYBOARD	3
#define	OP_INT_SCSI	4
#define	OP_INT_ETHERNET	5
#define OP_INT_ACFAIL	6
#define	OP_INT_SYSFAIL	7

/*
 * bit values in the op_sccntrl register
 */
#define	OP_SC_INEA	0x01
#define	OP_SC_AUTO	0x02
#define OP_SC_DACT	0x04
#define OP_SC_SELATN	0x08

/*
 * field positions in the op_scstat register
 */
#define	OP_ST_STATEMASK	0xe0
#define	OP_ST_MST_MASK	0x18
#define	OP_ST_PHSMASK	0x07

#define	SC_DISCONNECT	0x00
#define	SC_RESELECTED	0x20
#define	SC_RSLMSGIN	0x40
#define	SC_SELECTING	0x60
#define	SC_SELMSGOUT	0x80
#define	SC_CONNECTED	0xa0

#define MST_NULL	0x00
#define	MST_DISC	0x08
#define	MST_CMPLT	0x10
#define	MST_CMPLT2	0x18

#define	OP_ST_PHS_MSG_IN	7
#define	OP_ST_PHS_MSG_OUT	6
#define OP_ST_PHS_UNS_IN	5
#define OP_ST_PHS_UNS_OUT	4
#define	OP_ST_PHS_STATUS	3
#define	OP_ST_PHS_COMMAND	2
#define	OP_ST_PHS_DATA_IN	1
#define	OP_ST_PHS_DATA_OUT	0

#define	OP_ST_PHS_IO	1
#define	OP_ST_PHS_CD	2
#define	OP_ST_PHS_MSG	4

/*
 * values of the op_scsintr register
 */
#define	SCNT_REASON_MASK	7

#define	SCNT_NULL	0
#define	SCNT_MANUAL	1
#define	SCNT_MANCMND	2
#define	SCNT_MANRESEL	3
#define	SCNT_PROTOCOL	4
#define	SCNT_BUSERROR	5
#define	SCNT_DMA_BUSERROR	6


/*
 * bit positions in the du_rxstat and du_txstat register in op_chan0 and
 * op_chan1. Notice that COC and ERR are resettable whereas ACT and INEA are
 * writable.
 */
#define	OP_DU_ACT	0x08
#define OP_DU_COC	0x04
#define	OP_DU_ERR	0x02
#define	OP_DU_INEA	0x01

/*
 * bit positions in the op_failstat register.
 */
#define	OP_ACSY_ACFL	0x20
#define	OP_ACSY_SYSFL	0x10
#define	OP_ACSY_2OFF	0x08
#define	OP_ACSY_1OFF	0x04
#define	OP_ACSY_AINEA	0x02
#define	OP_ACSY_SINEA	0x01

/*
 * bit positions in the ethernet status registers op_ethrstat and op_ethtstat.
 */
#define	OP_ETH_INEA	1
#define	OP_ETH_ERR	2
#define	OP_ETH_EVNT	4
#define	OP_ETH_ACT	8

/*
 * bit positions in the op_clkstat register.
 */
#define OP_CLK_INEA	1
#define OP_CLK_TICK	2

/* Bit positions in the op_kbdstat register */
#define OP_KB_INEA	1
#define OP_KB_FRM	2
#define OP_KB_OVFL	4
#define OP_KB_RDY	8

/* Bit positions in the op_audstat register */
#define OP_AUD_INEA	0x01
#define OP_AUD_ERR	0x02
#define OP_AUD_FIN	0x04
#define OP_AUD_ACT	0x08
#define OP_AUD_CONT	0x10
#define OP_AUD_TONE	0x20

/* Names for the bits in the sync patterns in the video list */

#define OP_VID_VSYNC           0x01
#define OP_VID_HSYNC           0x02
#define OP_VID_PSYNC           0x04
#define OP_VID_BLANK           0x08
#define OP_VID_DATA            0x10

/* Flags for use with a repeat count of 0 */

#define OP_VIDL_FRM             0x08
#define OP_VIDL_RSTRT           0x10
#define OP_VIDL_PL0             0x20
#define OP_VIDL_PL1             0x40
#define OP_VIDL_PCHNG           0x80

/* poll delay between OpenChip accesses in cached loops */

#define	OC_POLL_DELAY()		{register i; for (i = 15; --i > 0;);}
