
#include "../machine/board.h"
#include <setjmp.h>

char buf[80];
char *day_string[] =  {
	"",
	"Sunday",
	"Monday",
	"Tuesday",
	"Wednesday",
	"Thursday",
	"Friday",
	"Saturday",
};

char *month_string[] = {
	"",
	"January",
	"Feburary",
	"March",
	"April",
	"May",
	"June",
	"July",
	"August",
	"September",
	"October",
	"November",
	"December",
};

int num;
unsigned char year, month, date, day, hour, minute, second;

main()
{
	register unsigned char test;

	printf("\n--- %i Standalone NVRAM Diagnostics ---\n\n");

	while (1) {
		printf("\nCommands available:\n");
		printf("  a) Set date\n");
		printf("  b) Display date\n");
		printf("  c) Set reset counter\n");
		printf("  d) Display reset counter\n");
		printf("  e) Set autoboot argument\n");
		printf("  f) Display autoboot argument\n");
		printf("  g) Stop the oscillator\n");
		printf("  x) eXit\n");

		printf("\nEnter letter of desired command: ");
		test = wgetlocal();
		test = (test >= 'A' && test <= 'Z') ? test +0x20: test;
		if (test == 'a')
			setdate();
		else if (test == 'b')
			dispdate();
		else if (test == 'c')
			setcounter();
		else if (test == 'd')
			dispcounter();
		else if (test == 'e')
			setbootarg();
		else if (test == 'f')
			dispbootarg();
		else if (test == 'g')
			oscstop();
		else if (test == 'x')
			exit();

	}
}

setdate()
{
	while (1) {
		printf("  Enter year(00-99): ");
		num = getdec();
		if (num <= 99) {
			year = binary_to_bcd(num);
			break;
		}
		printf("  Invalid year\n");
	}

	while (1) {
		printf("  Enter month(01-12): ");
		num = getdec();
		if (num >= 1 && num <= 12) {
			month = binary_to_bcd(num);
			break;
		}
		printf("  Invalid month\n");
	}

	while (1) {
		printf("  Enter date(01-31): ");
		num = getdec();
		if (num >= 1 && num <= 31) {
			date = binary_to_bcd(num);
			break;
		}
		printf("  Invalid date\n");
	}

	while (1) {
		printf("  Enter day(01-07): ");
		num = getdec();
		if (num >= 1 && num <= 7) {
			day = binary_to_bcd(num);
			break;
		}
		printf("  Invalid day\n");
	}

	while (1) {
		printf("  Enter hour(00-23): ");
		num = getdec();
		if (hour <= 23) {
			hour = binary_to_bcd(num);
			break;
		}
		printf("  Invalid hour\n");
	}

	while (1) {
		printf("  Enter minute(00-59): ");
		num = getdec();
		if (num <= 59) {
			minute = binary_to_bcd(num);
			break;
		}
		printf("  Invalid minute\n");
	}

	while (1) {
		printf("  Enter second(00-59): ");
		num = getdec();
		if (num <= 59){
			second = binary_to_bcd(num);
			break;
		}
		printf("  Invalid second\n");
	}
	
	afcwb(NVRAM_CONTROL, NVRAM_WRITE);
	afcwb(NVRAM_SECOND, 0x00);
	afcwb(NVRAM_HOUR, 0x80);
	afcwb(NVRAM_CONTROL, 0);
	DELAY(300000);
	afcwb(NVRAM_CONTROL, NVRAM_WRITE);
	afcwb(NVRAM_HOUR, 0x00);
	afcwb(NVRAM_YEAR, year);
	afcwb(NVRAM_MONTH, month);
	afcwb(NVRAM_DATE, date);
	afcwb(NVRAM_DAY, day);
	afcwb(NVRAM_HOUR, hour);
	afcwb(NVRAM_MINUTE, minute);
	afcwb(NVRAM_SECOND, second);
	afcwb(NVRAM_CONTROL, 0);
}


dispdate()
{
	afcwb(NVRAM_CONTROL, NVRAM_READ);
	year = bcd_to_binary(afcrb(NVRAM_YEAR));
	month = bcd_to_binary(afcrb(NVRAM_MONTH));
	date = bcd_to_binary(afcrb(NVRAM_DATE));
	day = bcd_to_binary(afcrb(NVRAM_DAY));
	hour = bcd_to_binary(afcrb(NVRAM_HOUR));
	minute = bcd_to_binary(afcrb(NVRAM_MINUTE));
	second = bcd_to_binary(afcrb(NVRAM_SECOND));
	afcwb(NVRAM_CONTROL, 0);
	printf("  %s %s %d %d   %d:%d:%d\n",
		day_string[day],
		month_string[month],
		date, year, hour, minute, second);
}


setcounter()
{
	printf("  Reset counter = ");
	num = getdec();
	afcwl(NVRAM_RESET_COUNTER, num);
}

dispcounter()
{
	num = afcrl(NVRAM_RESET_COUNTER);
	printf("  Reset counter = %d\n", num);
}

setbootarg()
{
	register i;

	printf("  Boot arg = ");
	stripwhite(gets(buf));
	for (i = 0 ; i < (NVRAM_BOOT_ARGSIZE - 1) && buf[i] ; i++)
		afcwb(NVRAM_BOOT_ARG + i, buf[i]);
		
	afcwb(NVRAM_BOOT_ARG + i, 0);
}

dispbootarg()
{
	register i;
	char c;

	printf("  Boot arg = ");
	i = NVRAM_BOOT_ARG;
	do {
		c = afcrb(i++);
		printf("%c", c);
	} while(c);
	printf("\n");
}

binary_to_bcd(i)
{
	return((i / 10) << 4 | (i % 10));
}
	
bcd_to_binary(i)
unsigned char i;
{
	return((i >> 4) * 10 + (i & 0x0f));
}
	
oscstop()
{
	afcwb(NVRAM_SECOND, 0x80);
}

getdec()
{
	stripwhite(gets(buf));
	return(atol(buf));
}

