/* This file contains the bulk of the VQX only code for boot.c.
 * The object is: modifications made here will not effect the rest
 * of the standalone environment. 
 *
 * This file is included into boot at compile time.
 */
#include "nvram.QX.h"

nvram(cp)
	register char *cp;
{
	register int c, n, num, k, count;
	register unsigned char loc;
	static unsigned char nv_array[sizeof(struct nv_ram)];
	struct nv_ram	*nv_ram = nv_array;

	if (*cp == 's') {
		getram(nv_array);
		printf("ethernet address: %x:%x:%x:%x:%x:%x	(offset 0-5)\n",
		    nv_ram->enet_addr[0],
		    nv_ram->enet_addr[1],
		    nv_ram->enet_addr[2],
		    nv_ram->enet_addr[3],
		    nv_ram->enet_addr[4],
		    nv_ram->enet_addr[5]);
		printf("port 0 config:    0x%x		(offset 6)\n",
		    nv_ram->sio[0]);
		printf("port 1 config:    0x%x		(offset 8)\n",
		    nv_ram->sio[1]);
		printf("cpu number:       %d		(offset %2d)\n",
		    nv_ram->cpu_num, (int)&nv_ram->cpu_num-(int)nv_ram);
		printf("checksum:         0x%x		(offset %2d)\n",
		    nv_ram->chksum, (int)&nv_ram->chksum-(int)nv_ram);
		return;
	}
	if ((num = gethex(cp)) == -1) {
		printf("invalid address\n");
		return;
	}
	loc = num;
	while (*cp)
		cp++;
	count = 0;
	cp++;
	if (*cp) {
		if ((n = gethex(cp)) == -1) {
			printf("invalid value\n");
			return;
		}
		count = 1;
		c = '\r';
	}

	getram(nv_array);
	while (1) {
	    DELAY(3000);		/* wait for GIP to scroll */
	    if (count == 0) {
		getram(nv_array);
		printf("%x| %x  ", loc, nv_array[loc]);
		n = count = 0;
		while (c = getchar())
			if ((k = ctoh(c)) == -1)
				break;
			else {
				count++;
				n = n * 16 + k;
			}
	    }
	    if (c == '\r' || c == '\n' || c == '\\') {
		if (count) {
			nv_array[loc] = n;
			modram(nv_array, loc, n);
		}
		if (c == '\r')
			return;
		else if (c == '\\') {
			printf("\n");
			loc = (loc > 0 ? loc-1 : 0);
		} else
			loc = (loc >= sizeof(nv_array)-1 ?
			    sizeof(nv_array)-1 : loc+1);
	    } else
		printf("bad value\n");
	    count = 0;
	}
}

modram(nv_array, i, n)
	unsigned char	*nv_array;
	int             i;
	unsigned char   n;
{
	unsigned char   cksum;

	nv_array[i] = n;
	cksum = 0;
	for (i = 0; i < sizeof(struct nv_ram)-1; ++i)
		cksum += nv_array[i];
	nv_array[sizeof(struct nv_ram)-1] = cksum;
	putram(nv_array);
}
