/* This file contains the bulk of the V30 only code for boot.c.
 * The object is: modifications made here will not effect the rest
 * of the standalone environment. 
 *
 * This file is included into boot at compile time.
 */

/* use the auto boot parameters from the NVRAM if there is a good one
 * otherwise return, this then causes the normal search of devsw for
 * a useable or bootable file.
 */
nvram_boot()
{
	register int i, start;
	register char *p;
	register char *line = (char *) LINEBUF;
#ifdef	VBUS
	char		*vbarg = "VBNUM=0";
#endif
	vbarg[6] += vbnum;
	i = NVRAM_BOOT_ARG;
	p = line;
	while( *p++ = afcrb(i++));
	printf("%s",line);
	autoboot = 1;
	if ((start = copyunix(line))) {
#ifdef	VBUS
		addarg(vbarg);
#endif	VBUS
		booty(start);
	}
	autoboot = 0;
	for(p=line; *p;p++) printf("\b \b");
	return(0);
}

/* nvram utilities */
#include "../machine/board.h"

static int name_rng[][2] = {
	{0,99}, {1,12}, {1,31}, {1,7}, {0,23}, {0,59}, {0,59}
};

static char *name[] = { "year","month","date","day","hours","minutes","seconds" };

static char *day_string[] =  {
	"",	"Sun",	"Mon",	"Tue",	"Wed",	"Thur",	"Fri",	"Sat" 
};

/*char *month_string[] = { 
	"","01","02","03","04","05","06","07","08","09","10","11","12"};
 */
static u_char value[] = {0,0,0,0,0,0,0};

static u_char EOF = -1;

nvram()
{
	register unsigned char test;

/*	printf("\n--- nvram utility ---\n\n");
 */

	while (1) {
		printf("\n nvram commands available:\n");
		printf("  a) Set date\n");
		printf("  b) Display date\n");
		printf("  c) Set reset counter\n");
		printf("  d) Display reset counter\n");
		printf("  e) Set (space clears) autoboot argument\n");
		printf("  f) Display autoboot argument\n");
		printf("  g) Stop the oscillator\n");
		printf("  h) Display board Rev. and functionality\n");
		printf("  x) eXit\n");

		printf("\nEnter letter of desired command: ");
		while(! (test = getlocal()) );
		test = (test >= 'A' && test <= 'Z') ? test +0x20: test;
		if (test == 'a')
			setdate();
		else if (test == 'b')
			dispdate();
		else if (test == 'c')
			setcounter();
		else if (test == 'd')
			dispcounter();
		else if (test == 'e')
			setbootarg();
		else if (test == 'f')
			dispbootarg();
		else if (test == 'g')
			oscstop();
		else if (test == 'h')
			bd_rev_level();
		else if (test == 'x' || test == '@') 
			{ putchar('\n'); return(test); }
	}
}

setdate()
{
	register int i, num;
	
	for(i=0;i < 7; i++) {
		while (1) {
			say_enter(name[i],name_rng[i][0],name_rng[i][1]);
			num = getdec();
			if( num == EOF) {
				value[i] = EOF;
				break;
			}
			else if (num >= name_rng[i][0] && num <= name_rng[i][1]) {
				value[i] = (u_char) ((num / 10) << 4 | (num % 10));
				break;
			}
			else say_invalid(name[i]);
		}
	}
	afcwb(NVRAM_CONTROL, NVRAM_WRITE);
	if (value[0] != EOF) afcwb(NVRAM_YEAR, value[0]);
	if (value[1] != EOF) afcwb(NVRAM_MONTH, value[1]);
	if (value[2] != EOF) afcwb(NVRAM_DATE, value[2]);
	if (value[3] != EOF) afcwb(NVRAM_DAY, value[3]);
	if (value[4] != EOF) afcwb(NVRAM_HOUR, value[4]);
	if (value[5] != EOF) afcwb(NVRAM_MINUTE, value[5]);
	if (value[6] != EOF) afcwb(NVRAM_SECOND, value[6]);
	afcwb(NVRAM_CONTROL, 0);
}


dispdate()
{
	afcwb(NVRAM_CONTROL, NVRAM_READ);
	value[0] = bcd_to_binary(afcrb(NVRAM_YEAR));
	value[1] = bcd_to_binary(afcrb(NVRAM_MONTH));
	value[2] = bcd_to_binary(afcrb(NVRAM_DATE));
	value[3] = bcd_to_binary(afcrb(NVRAM_DAY));
	value[4] = bcd_to_binary(afcrb(NVRAM_HOUR));
	value[5] = bcd_to_binary(afcrb(NVRAM_MINUTE));
	value[6] = bcd_to_binary(afcrb(NVRAM_SECOND));
	afcwb(NVRAM_CONTROL, 0);
	printf("  %s %2d/%c%d/%c%d   %2d:%c%d:%c%d\n",
		day_string[value[3]],
		value[1], (value[2] < 10)? '0' :'\0', value[2], 
				  (value[0] < 10)? '0' :'\0', value[0],
		value[4], (value[5] < 10)? '0' :'\0', value[5],
				  (value[6] < 10)? '0' :'\0', value[6]);
}

setcounter()
{
	register int num;

	printf("  Reset counter = ");
	if((num = getdec()) != EOF)	afcwl(NVRAM_RESET_COUNTER, num);
}

dispcounter()
{
	register int num;

	num = afcrl(NVRAM_RESET_COUNTER);
	printf("  Reset counter = %d\n", num);
}

setbootarg()
{
	register i;
	register char *buf = (char *)LINEBUF;

	printf("  Boot arg = ");
	gets(buf);
	if(buf[0]) {
 		stripwhite(buf);
		for (i = 0 ; i < (NVRAM_BOOT_ARGSIZE - 1) && buf[i] ; i++)
			afcwb(NVRAM_BOOT_ARG + i, buf[i]);
	}
	afcwb(NVRAM_BOOT_ARG + i, 0);
}

dispbootarg()
{

	register i;
	register char *p;
	register char *line = (char *) LINEBUF;

	i = NVRAM_BOOT_ARG;
	p = line;
	while( *p++ = afcrb(i++));
	printf("  Boot arg = %s\n",line);
}

bd_rev_level()
{
	printf("Board REV: %X%s%s%s\n", afcrb(BD_HW_VER), 
		((afcrb(BD_FUNC_LEV) & BD_FUNC_16MHZ) ?", 16 Mhz" :", 25 Mhz"),
		((afcrb(BD_FUNC_LEV) & BD_FUNC_VSB) ?", VSB" :", PVSB"),
		((afcrb(BD_FUNC_LEV) & BD_FUNC_CACHE_BURST) ?", cache burst" :"")
	);
}

oscstop()
{
	afcwb(NVRAM_SECOND, 0x80);
}
	
getdec()
{
	register char *buf = (char *)LINEBUF;

	stripwhite(gets(buf));
	if(buf[0] == '\0') return(EOF);
	return(atol(buf));
}

say_invalid(name)
char	*name;
{
		printf("  Invalid %s\n",name);
}

say_enter(name, low, hi)
char 	*name;
int		low,hi;
{
		printf("  Enter %s(%02d-%02d): ",name,low,hi);
}

/*****************/
bcd_to_binary(i)
register unsigned char i;
{
	return((i >> 4) * 10 + (i & 0x0f));
}

