#include "saio.h"
#include "sais68k.h"
#include "saboot.h"

extern char *arguments;
extern int	autoboot;
u_char broaddr[6] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

netopen(send, io, bpx, bpr, pkidp, myaddr, hostaddr)
	int (*send)();
	register struct iob *io;
	register struct boot_packet *bpx, *bpr;
	int *pkidp;
	char *myaddr, *hostaddr;
{
	register char *p0;

	io->i_flgs |= F_REMOTE;
	if ((p0 = arguments) == (char *)0)
		goto bad;
	if (*arguments == '?') {
		printf("Ethernet Address: %e\n", myaddr);
		return -1;
	} else if (*arguments == '@') {
		bzero(bpx, sizeof(struct boot_packet));
		bcopy(broaddr, bpx->bp_eh.ether_dhost, 6);
		bcopy(myaddr, bpx->bp_eh.ether_shost, 6);
		bpx->bp_eh.ether_type = ETHERTYPE_ISIBOOT;
		bpx->bp_cmd = BOOT_AUTOBOOT;
		bpx->bp_pkid = *pkidp;
		if ((*send)(io, bpx, bpr, pkidp) == 0)
			return -1;
		sprintf(arguments, "(%e)-> %s", bpr->bp_eh.ether_shost, 
			macroexpand(bpr->bp_data));
		if (autoboot) {
			autoboot = 0;
			printf("\b%s",arguments);
			autoboot = 1;
		} else
			printf("\b%s\n",arguments);
		while (*p0++ != '>')
			;
		p0++;
		arguments = p0;
	}
	while (*p0 != ':') {
		if (*p0++ == '\0') {
bad:			printf("no host specified\n");
			return -1;
		}
	}

	/* broadcast a host connect packet */
	bzero(bpx, sizeof(struct boot_packet));
	bcopy(broaddr, bpx->bp_eh.ether_dhost, 6);
	bcopy(myaddr, bpx->bp_eh.ether_shost, 6);
	bpx->bp_eh.ether_type = ETHERTYPE_ISIBOOT;
	bpx->bp_cmd = BOOT_CONNECT;
	bpx->bp_pkid = *pkidp;
	p0 = &bpx->bp_data[0];
	while((*arguments != ':') &&  (*p0++ = *arguments++))
		*p0 = 0;
	if (*arguments == ':')
		arguments += 1;
	if ((*send)(io, bpx, bpr, pkidp) == 0)
		return -1;

	/* get server's address from response to connect packet */
	bcopy(bpr->bp_eh.ether_shost, hostaddr, 6);

	/* open up the file */
	bzero(bpx, sizeof(struct boot_packet));
	bcopy(hostaddr, bpx->bp_eh.ether_dhost, 6);
	bcopy(myaddr, bpx->bp_eh.ether_shost, 6);
	bpx->bp_eh.ether_type = ETHERTYPE_ISIBOOT;
	bpx->bp_cmd = BOOT_OPEN;
	bpx->bp_pkid = *pkidp;
	p0 = &bpx->bp_data[0];
	while ((*arguments != '(') && (*arguments != ' ') && 
	    (*arguments != '\t') && (*p0++ = *arguments++))
		*p0 = 0;
	if (*arguments != '(')
		arguments = NULL;

	if ((*send)(io, bpx, bpr, pkidp) == 0)
		return -1;
	if (bpr->bp_cmd == BOOT_OPEN)
		return 0;
	printf("file not found\n");
	return -1;
}

netclose(send, io, bpx, bpr, pkidp, myaddr, hostaddr)
	int (*send)();
	register struct iob *io;
	register struct boot_packet *bpx, *bpr;
	int *pkidp;
	char *myaddr, *hostaddr;
{
	bzero(bpx, sizeof(struct boot_packet));
	bcopy(hostaddr, bpx->bp_eh.ether_dhost, 6);
	bcopy(myaddr, bpx->bp_eh.ether_shost, 6);
	bpx->bp_eh.ether_type = ETHERTYPE_ISIBOOT;
	bpx->bp_cmd = BOOT_CLOSE;
	bpx->bp_pkid = *pkidp;
	if ((*send)(io, bpx, bpr, pkidp) == 0)
		return (-1);
	return(0);
}

netstrategy(send, io, func, bpx, bpr, pkidp, myaddr, hostaddr)
	int (*send)();
	register struct iob *io;
	register struct boot_packet *bpx, *bpr;
	int *pkidp;
	char *myaddr, *hostaddr;
{
	register int count = io->i_cc;
	register int offset = io->i_offset;
	register int len;

	while (count > 0) {
		len = count < BOOT_DATACNT ? count : BOOT_DATACNT;
		bzero(bpx, sizeof(struct boot_packet));
		bcopy(hostaddr, bpx->bp_eh.ether_dhost, 6);
		bcopy(myaddr, bpx->bp_eh.ether_shost, 6);
		bpx->bp_eh.ether_type = ETHERTYPE_ISIBOOT;
		bpx->bp_pkid = *pkidp;
		bpx->bp_offset = offset;
		bpx->bp_len = len;
		if (func == READ)
			bpx->bp_cmd = BOOT_READ;
		else {
			bpx->bp_cmd = BOOT_WRITE;
			bcopy(io->i_ma, bpx->bp_data, len);
		}
		if ((*send)(io, bpx, bpr, pkidp) == 0)
			return -1;
		if (func == READ)
			bcopy(bpr->bp_data, io->i_ma, bpr->bp_len);
		offset += bpr->bp_len;
		io->i_ma += bpr->bp_len;
		count -= bpr->bp_len;
		if (bpr->bp_len != len)
			break;
	}
	return(io->i_cc - count);
}
