
/* mem.c */

#include	"../h/types.h"
#include "../machine/board.h"
#include	<setjmp.h>

jmp_buf	memtest;
extern	int (*user_exit)();

#define	DEFAULT_SIZE	((sizeof(char) | sizeof(short) | sizeof(long)))
#define	BLK_SIZE	0x1000
#define	LEN	66

char buf[80];
int lerrs, terrs, toterrs, tsize = DEFAULT_SIZE;

int verbose = 1, stop_on_errors = 1;
static int scale_value = 0, scale_trig = 0;

#ifdef	M68030
	extern long memsize;
#	define	topmem	memsize
	int	cpu_time = 100;
#else	M68030
	extern long topmem;
#	ifdef V20
		int	cpu_time = 329;
#	endif
#	ifdef V25
		int	cpu_time = 296;
#	endif
#	ifdef	VQX
		int	cpu_time = 358;
#	endif
#endif	M68030
extern short end;
unsigned long *start, *top, *stop;
int lapcnt, abort, start_time, parity, *q, mem_escape();
char *dsize;

/********************************************************/

#ifdef	PROMDIAG
	p_mem()
#else
	main()
#endif 	PROMDIAG

{
	long nbanks, repeat, forever;
	char c, test;
	long time;

	printf("\n--- %i Standalone Memory Diagnostics ---\n\n");

#ifdef	M68020
	onetoone(0);
#endif	M68020
	/* set up default memory sizes first */	
	start = (u_long *)&end;
	top = (u_long *)(topmem - 1);
	stop = (u_long *)(topmem - 1);

	lerrs = terrs = toterrs = repeat = 0;
	parity = 1;
	_parityon();
	
	if((c = setjmp(memtest)) == '') { 
	  /* prepare to return here on ^C */
		printf("*** Mem test aborted ***");
		user_exit = 0;
		return(1);
	}
	user_exit = mem_escape;

top_menu:
	print_top_menu();
	while(1) {
		printf("\nSelect options of choice: ");
		c = getans();
		if( c >= 'a' && c <= 'i') { test = c; goto run_test;}
set_up:
		switch(c) {
			case '1':
				case_1:	
					printf(" Memory from 0 to 0x%a reserved\n",&end);
					printf("  Enter hex start address (default = 0x%a): ",
						start);
					stripwhite(gets(buf));
					start = (buf[0] == '\0') ? start : (u_long *)gethex(buf);
					if((unsigned) start<(unsigned) (long *)&end) goto case_1;
					printf("  Enter hex stop address  (default = 0x%a): ",
						stop);
					stripwhite(gets(buf));
					stop = (buf[0] == '\0') ? stop : (u_long *)gethex(buf);
					if ((unsigned) stop <= (unsigned) start) {
						printf("stop <= start\n");
						goto case_1;
					}
					break;
			case '2':
				printf(" Repeat count in decimal (0 means forever): ");
					stripwhite(gets(buf));
					repeat = (buf[0] == '\0') ? repeat : atol(buf);
					break;
			case '3':
					verbose = (verbose)? 0 : 1;
					printf(" (Verbose set %s)\n",	(verbose)? "on": "off");
					break;
			case '4':
					stop_on_errors = (stop_on_errors) ? 0 : 1;
					printf(" (set to %sstop on errors)\n", 
							(stop_on_errors)? "": "not ");
					break;
			case '5':
					if (parity){ parity = 0; _parityoff();}
					else {parity = 1; _parityon();}
					printf(" (Parity set %s)\n",	(parity)? "on": "off");
					break;
			case '6':
				size_err:
				printf(" Enter data size, (a)ll, (b)yte, (w)ord or (l)ong: ");
				if((c = getans()) == 'a') tsize = DEFAULT_SIZE;
				else if(c == 'b') tsize = sizeof(char);
				else if(c == 'w') tsize = sizeof(short);
				else if(c == 'l') tsize = sizeof(long);
				else { putchar(''); goto size_err;}
				break;
			case '':
			case '7':
					goto bottom_menu;
			case 'x':
				 	return(0);
			default:
				printf("\nInvalid choice, try again.\n");
				goto top_menu;
		} /* end top menu case */
	} /* end top while */

bottom_menu:
	dsize = (tsize == sizeof(short)) ? "word" : 
			(tsize == sizeof(char)) ? "byte" : 
			(tsize == sizeof(long)) ? "long" : "b/w/l";

	print_bot_menu();
	while (1) {
		printf("\nEnter letter of desired option: ");
		test = getans();
		if (test >= '1' && test <= '6') {
			c = test; goto set_up;}
		if (test == 'j' || test == '') {
			printf("\n"); goto top_menu;}
		else if (test == 'x')
			return;
		else if (test < 'a' || test > 'i') {
			printf("  No such test\n");	goto bottom_menu; }
run_test:
		forever = (repeat == 0 ? 1 : 0);
		printf("\nPressing any key will terminate test.\n");

		/* THE BIG LOOP */
		for (lapcnt = 0; (forever || repeat-- > 0); ) {
			lapcnt++;
			if (abort = mgetlocal()) {break;}
			if (verbose) {
				printf("Lap %d memory (0x%x - 0x%x (%mM))",
					 lapcnt, start, stop, (int)stop - (int)start);
#ifdef	V30
				printf(", Started at ");
				print_time(start_time = read_time());
				putchar('\n');
#endif	V30
			}
			switch (test) {
			  case 'a':
				abort = bd_trace(start, stop); break;
			  case 'b':
				abort = address(start, stop); break;
			  case 'c':
				estimate(start, stop, (tsize == DEFAULT_SIZE)? 136: 48);
				abort = patt(start, stop, 1); break;
			  case 'd':
				estimate(start, stop, 9592);
				abort = walk(start, stop); break;
			  case 'e':
				estimate(start, stop, 2117);
				abort = ping(start, stop); break;
			  case 'f':
				abort = exec(start, stop); break;
			  case 'g':
				estimate(start, stop, 15);
				abort = uniq(start, stop); break;
			  case 'h':
			  case 'i':
				estimate(start, stop, (test == 'h')? 37:13337);
				if (abort = bd_trace(start, stop))
					break;
				if (abort = address(start, stop))
					break;
				if (abort = patt(start, stop, (test == 'h')? 0:1))
					break;
				if (test == 'i') if (abort = walk(start, stop))
					break;
				if (test == 'i') if (abort = ping(start, stop))
					break;
				if (abort = exec(start, stop))
					break;
				abort = uniq(start, stop);
				break;
			} /* end case */
			if((stop_on_errors && lerrs) || abort) break;
			if(verbose) {
				printf("  %d errors this lap.", lerrs);
#ifdef	V30
				printf("  Elapsed time: ");
				print_time(read_time() - start_time);
#endif	V30
				putchar('\n');
			}
			lerrs = 0;

		} /* end for loop */

		if (abort) {
			printf("\n Test aborted");
			abort = 0;
		} else
			if(verbose) printf("Test completed");
		if (verbose) 
		 printf(" %d lap(s) with %d errors on last test, %d total errors\n\n",
				lapcnt, terrs, toterrs);
		terrs = 0;

	} /* end while */

} /* end main */

/**************************************/
/**************************************/
print_top_menu()
{
	printf("\n       ----- TOP MENU ----\n");
	printf("Define test region (0x%a - 0x%a) (%mM) and test options:\n",
										&end, top, (int)top - (int)&end);
	printf("1 - Test memory range (defaults to 0x%a - 0x%a (%mM))\n",
									start, stop, (int)stop - (int)start);
	printf("2 - Repeat count in decimal (default '0' means forever)\n");
	printf("3 - Toggle verbose mode (now %s)\n",
										(verbose)? "on": "off");
	printf("4 - Toggle stop on errors (now %s)\n",
										(stop_on_errors)? "yes": "no" );
	printf("5 - Toggle parity (now %s)\n",
										(parity)? "on": "off" );
	printf("6 - Set \"test data size\" to byte/word/long or ALL\n");
	printf("7 - Test menu\n");
	printf("? - HELP\n");
	printf("x - eXit\n");
}

print_bot_menu()
{
	printf("\n  --- Tests Menu ---\n");
	printf("\n  a) Data Trace(long)");
	printf("\n  b) Address Test(%s)",dsize);
	printf("\n  c) Patterns(%s)",dsize);
	printf("\n  d) Walk(short)");
	printf("\n  e) Ping-pong(short)");
	printf("\n  f) Exec(-)");
	printf("\n  g) Uniqueness(long)");
	printf("\n  h) Quick test(a, b, c, f, g)");
	printf("\n  i) All tests");
	printf("\n  j) Goto top menu");
	printf("\n  ?) HELP");
	printf("\n  x) eXit\n\n");
}

bd_trace(start, stop)
unsigned long *start;
unsigned long *stop;
{
	register long *addr;
	register i, rpatt;

	if(verbose) printf("  Data Trace Test:     ");

	/* use a zero pattern, float a "1" through */
	for(i = 1,addr = (long *) start; i != 0 && addr <= (long *) stop;
                                                 i <<= 1, addr++)
		 *addr = i;  
	for(i = 1,addr = (long *) start; i != 0 && addr <= (long *) stop;
                                                 i <<= 1, addr++) {
		 rpatt = *addr;
		if((rpatt != i) && error(addr, i, rpatt)) return 1;
	}
	/* use a complimented pattern, float zero through */
	for(i = 1,addr = (long *) start; i != 0 && addr <= (long *) stop;
 													 i <<= 1, addr++)
		 *addr = ~i;  
	for(i = 1,addr = (long *) start; i != 0 && addr <= (long *) stop; 
													i <<= 1, addr++) {
		 rpatt = *addr;
		if((rpatt != ~i) && error(addr, ~i, rpatt)) return 1;
	}
	if(verbose) putchar('\n');
	return 0;
}

address(start, stop)
unsigned char *start, *stop;
{
	if (tsize & sizeof(char))
		if(addressb(start, stop)) return 1;
	if (tsize & sizeof(short))
		if(addressw(((int)start) & (~1), ((int)stop) & (~1))) return 1;
	if (tsize & sizeof(long))
		if(addressl(((int)start) & (~3), ((int)stop) & (~3))) return 1;

}

addressb(start, stop)
unsigned char *start, *stop;
{
	register unsigned char *addr;
	register unsigned char  rpatt;

	if(verbose) {
		 printf("  Byte Address Test: \n");
		 printf("    Writing ");
	}
	for (addr = start; addr <= stop; addr++) *addr = (char)addr;
	if(mgetlocal()) return 1;
	if (verbose) printf("- Verifying ");
	for (addr = start; addr <= stop; addr++) {
		rpatt = *addr;
		if (rpatt != (char)addr && error(addr, (char)addr, rpatt)) return 1;
	}
	if (verbose)erase_line(LEN);
	return 0;
}

addressw(start, stop)
unsigned short *start, *stop;
{
	register unsigned short *addr;
	register unsigned short rpatt;

	if(verbose) {
		printf("  Word Address Test: \n");
		printf("    Writing ");
	}
	for (addr = start; addr <= stop; addr++) *addr = (short)addr;
	if(mgetlocal()) return 1;
	if (verbose) printf("- Verifying ");
	for (addr = start; addr <= stop; addr++) {
		rpatt = *addr;
		if (rpatt != (short)addr && error(addr, (short)addr, rpatt)) return 1;
	}
	if (verbose)erase_line(LEN);
	return 0;
}

addressl(start, stop)
unsigned long *start, *stop;
{
	register unsigned long *addr;
	register unsigned long rpatt;

	if(verbose) {
		printf("  Long Address Test: \n");
		printf("    Writing ");
	}
	for (addr = start; addr <= stop; addr++) *addr = (long)addr;
	if(mgetlocal()) return 1;
	if (verbose) printf("- Verifying ");
	for (addr = start; addr <= stop; addr++) {
		rpatt = *addr;
		if (rpatt != (long)addr && error(addr, (long)addr, rpatt)) return 1;
	}
	if (verbose)erase_line(LEN);
	return 0;
}



# define NPATT 4
# define BNPATT2 20
char bspatt[BNPATT2] = {0, 0xff, 0x55, 0xaa,
		0x1, 0x2, 0x4, 0x8,
		0x10, 0x20, 0x40, 0x80,
		~0x1, ~0x2, ~0x4, ~0x8,
		~0x10, ~0x20, ~0x40, ~0x80};
# define WNPATT2 36
short wspatt[WNPATT2] = {0, 0xffff, 0x5555, 0xaaaa,
		0x1, 0x2, 0x4, 0x8,
		0x10, 0x20, 0x40, 0x80,
		0x100, 0x200, 0x400, 0x800,
		0x1000, 0x2000, 0x4000, 0x8000,
		~0x1, ~0x2, ~0x4, ~0x8,
		~0x10, ~0x20, ~0x40, ~0x80,
		~0x100, ~0x200, ~0x400, ~0x800,
		~0x1000, ~0x2000, ~0x4000, ~0x8000};
# define LNPATT2 68
long lspatt[LNPATT2] = {0, 0xffffffff, 0x55555555, 0xaaaaaaaa,
		0x1, 0x2, 0x4, 0x8,
		0x10, 0x20, 0x40, 0x80,
		0x100, 0x200, 0x400, 0x800,
		0x1000, 0x2000, 0x4000, 0x8000,
		0x10000, 0x20000, 0x40000, 0x80000,
		0x100000, 0x200000, 0x400000, 0x800000,
		0x1000000, 0x2000000, 0x4000000, 0x8000000,
		0x10000000, 0x20000000, 0x40000000, 0x80000000,
		~0x1, ~0x2, ~0x4, ~0x8,
		~0x10, ~0x20, ~0x40, ~0x80,
		~0x100, ~0x200, ~0x400, ~0x800,
		~0x1000, ~0x2000, ~0x4000, ~0x8000,
		~0x10000, ~0x20000, ~0x40000, ~0x80000,
		~0x100000, ~0x200000, ~0x400000, ~0x800000,
		~0x1000000, ~0x2000000, ~0x4000000, ~0x8000000,
		~0x10000000, ~0x20000000, ~0x40000000, ~0x80000000};

leng(start)
unsigned short *start;
{
	unsigned char *cp = (unsigned char *)start;
	unsigned short *sp = (unsigned short *)start;
	unsigned long *lp = (unsigned long *)start;
	register int i;
}

patt(start, stop, pattn)
unsigned char *start;
unsigned char *stop;
int	pattn;
{
	if (tsize & sizeof(char))
		if(pattb(start, stop, pattn)) return 1;
	if (tsize & sizeof(short))
		if(pattw(((int)start) & (~1), ((int)stop) & (~1), pattn)) return 1;
	if (tsize & sizeof(long))
		if(pattl(((int)start) & (~3), ((int)stop) & (~3), pattn)) return 1;
}

pattb(start, stop, pattn)
unsigned char *start;
register unsigned char *stop;
int	pattn;
{
	register unsigned char *addr;
	register unsigned char cpatt, rpatt;
	char n;
	int patt_num;
	
	patt_num = (pattn) ? BNPATT2 : NPATT;
	if(verbose) printf("  Byte Pattern Test: \n");
	for (n = 0; n < patt_num; n++) {
		cpatt = bspatt[n];
		if (verbose) printf("\r    Writing   %2x:    ", cpatt);
		for (addr = start; addr <= stop; addr++) *addr = cpatt;
		if(mgetlocal()) return 1;
		if (verbose) printf("\r    Verifying %2x:    ", cpatt);
		for (addr = start; addr <= stop; addr++) {
			rpatt = *addr;
			if (rpatt != cpatt && error(addr, cpatt, rpatt)) return 1;
			if ( ((int)addr & 0xFFFF) == 0 )if (mgetlocal())	return 1;
		}
	}
	if (verbose) erase_line(LEN);
	return 0;
}

pattw(start, stop, pattn)
unsigned short *start;
register unsigned short *stop;
int	pattn;
{
	register unsigned short *addr;
	register unsigned short cpatt, rpatt;
	short n;
	int patt_num;

	patt_num = (pattn) ? WNPATT2 : NPATT;
	if(verbose) printf("  Word Pattern Test: \n");
	for (n = 0; n < patt_num; n++) {
		cpatt = wspatt[n];
		if (verbose) printf("\r    Writing   %4x:    ", cpatt);
		for (addr = start; addr <= stop; addr++) *addr = cpatt;
		if(mgetlocal()) return 1;
		if (verbose) printf("\r    Verifying %4x:    ", cpatt);
		for (addr = start; addr <= stop; addr++) {
			rpatt = *addr;
			if (rpatt != cpatt && error(addr, cpatt, rpatt)) return 1;
			if ( ((int)addr & 0xFFFF) == 0 )if (mgetlocal())	return 1;
		}
	}
	if (verbose) erase_line(LEN);
	return 0;
}

pattl(start, stop, pattn)
unsigned long *start;
register unsigned long *stop;
int	pattn;
{
	register unsigned long *addr;
	register unsigned long cpatt, rpatt;
	long n;
	int	patt_num;

	patt_num = (pattn) ? LNPATT2 : NPATT;
	if(verbose) printf("  Long Pattern Test: \n");
	for (n = 0; n < patt_num; n++) {
		cpatt = lspatt[n];
		if (verbose) printf("\r    Writing   %8x:    ", cpatt);
		for (addr = start; addr <= stop; addr++) *addr = cpatt;
		if(mgetlocal()) return 1;
		if (verbose) printf("\r    Verifying %8x:    ", cpatt);
		for (addr = start; addr <= stop; addr++) {
			rpatt = *addr;
			if (rpatt != cpatt && error(addr, cpatt, rpatt)) return 1;
			if ( ((int)addr & 0xFFFF) == 0 )if (mgetlocal())	return 1;
		}
	}
	if (verbose) erase_line(LEN);
	return 0;
}

/*
**	Should I modify this to accept the function to call as an argument?
*/
walk(start, stop)
unsigned short *start;
unsigned short *stop;
{
	register unsigned short *rstart, *rstop, *addr1, *addr2;
	register unsigned short cpatt, pattc;
	short n;

	if(verbose) printf("  Walk Test: \n");
	for (n = 0; n < NPATT; n++) {
		cpatt = wspatt[n];
		pattc = ~cpatt;
		for (rstart = start; rstart < stop; rstart += BLK_SIZE) {
			if(verbose) printf("\r    Writing   %4x:    ", cpatt);
			for (addr1 = start; addr1 <= stop; addr1++)	*addr1 = cpatt;
			rstop = rstart + (BLK_SIZE -1);		/* note auto conversion */
			rstop = (rstop <= stop) ? rstop : stop;
			if(verbose) printf("\r    Walking (0x%x - 0x%x)  %4x:    ",
				rstart, rstop, pattc);
			if (walk1(rstart, rstop, cpatt)) return 1;
			if(verbose) erase_line(LEN);
			if(verbose) printf(" Test Boundaries", cpatt);  
			for (addr1 = start; addr1 < stop; addr1++) {
				if (*addr1 != cpatt && error(addr1, cpatt, *addr1)) return 1;
				if ( ((int)addr1 & 0xFFFF) == 0 )if (mgetlocal())	return 1;
			}
		}
	}
	if(verbose) erase_line(LEN);
	return 0;
}

walk1(start, stop, cpatt)
unsigned short *start;
register unsigned short *stop, cpatt;
{
	register unsigned short *addr, *addr2;
	register unsigned short pattc, rpatt;
	int	len = 60;

	pattc = ~cpatt;
	if (verbose) scale_init( (int)start, (int)stop, 10) ;
	for (addr = start; addr <= stop; addr++) {
		*addr = pattc;
		for (addr2 = start; addr2 <= stop; addr2++) {
			rpatt = *addr2;
			if (rpatt != cpatt && addr2 != addr
			   && error(addr2, cpatt, rpatt)) return(1);
		}
  		rpatt = *addr;
		if (rpatt != pattc && error(addr, pattc, rpatt)) return(1);
		*addr = cpatt;
		if ( ((int)addr & 0xFFF) == 0 )if (mgetlocal())	return 1;
		if (verbose && (addr >= (u_short*)scale_trig)) scale();
	}
	if(verbose) erase_line(LEN);
	return 0;
}

ping(start, stop)
unsigned short *start;
register unsigned short *stop;
{
	register unsigned short *rstart, *rstop, *addr1;

	if(verbose) printf("  Ping-pong Test: \n");
	for (addr1 = start; addr1 <= stop; addr1++) *addr1 = 0;
	for (rstart = start; rstart < stop; rstart += BLK_SIZE) {
		rstop = rstart + (BLK_SIZE - 1); /* note auto conversion */
		rstop = (rstop <= stop ? rstop : stop);
		if(verbose) printf("\r    ping-pong 0x%x to 0x%x  ",
			(int)rstart, (int)rstop);
		if(ping1(rstart, rstop)) return 1;
		if(verbose) printf("  Boundary checking ");
		for (addr1 = start; addr1 < rstart; addr1++) {
			if (*addr1 != 0 && error(addr1, 0, *addr1)) return 1;
			if ( ((int)addr1 & 0xFFFF) == 0 )if (mgetlocal()) return 1;
		}
		for (addr1 = rstop + 1; addr1 < stop; addr1++) {
			if (*addr1 != 0 && error(addr1, 0, *addr1)) return 1;
			if ( ((int)addr1 & 0xFFFF) == 0 )if (mgetlocal()) return 1;
		}
		if(verbose) erase_line(LEN);
	}
	if(verbose) erase_line(LEN);
	return 0;
}

ping1(start, stop)
unsigned short *start, *stop;
{
	register unsigned short *addr1, *addr2, *addr3, *addr4;
	register unsigned short caddr1, caddr2, caddr3, caddr4;
	short n;

	for (addr1 = start; addr1 <= stop; addr1++) *addr1 = 0;
	if (verbose) scale_init( (int)start, (int)stop, 10) ;
	for (addr1 = start, addr2 = stop; addr1 < addr2; addr1++, addr2--) {
		*addr1 = 0xffff;
		*addr2 = 0xffff;
		for (addr3=start, addr4=stop; addr3 <= addr1; addr3++, addr4--) {
			if (*addr3 != 0xffff && error(addr3, 0xffff, *addr3)) return 1;
			if (*addr4 != 0xffff && error(addr4, 0xffff, *addr4)) return 1;
		}
		if ( ((int)addr1 & 0xFF) == 0 )if (mgetlocal())	return 1;
		for (addr3 = addr1+1, addr4 = addr2-1; addr3 <= addr4;
			addr3++, addr4--) {
			if (*addr3 != 0 && error(addr3, 0, *addr3)) return 1;
			if (*addr4 != 0 && error(addr4, 0, *addr4))	return 1;
		}
		if ( ((int)addr1 & 0xFF) == 0 )if (mgetlocal())	return 1;
		if (verbose && (addr1 >= (u_short*)scale_trig)) scale();
	}
	for ( --addr1, ++addr2; addr1 >= start; addr1--, addr2++) {
		*addr1 = 0;
		*addr2 = 0;
		for (addr3=start, addr4=stop; addr3 < addr1; addr3++, addr4--) {
			if (*addr3 != 0xffff && error(addr3, 0xffff, *addr3)) return 1;
			if (*addr4 != 0xffff && error(addr4, 0xffff, *addr4)) return 1;
		}
		if ( ((int)addr1 & 0xFF) == 0 )if (mgetlocal())	return 1;
		for (addr3 = addr1, addr4 = addr2; addr3 <= addr4;
			addr3++, addr4--) {
			if (*addr3 != 0 && error(addr3, 0, *addr3))	return 1;
			if (*addr4 != 0 && error(addr4, 0, *addr4))	return 1;
		}
		if ( ((int)addr1 & 0xFF) == 0 )if (mgetlocal())	return 1;
		if (verbose && (addr2 >= (u_short*)scale_trig)) scale();
	}
	return 0;
	
}


error(addr, wrote, read)
register unsigned short *addr, wrote, read;
{
	int i;

	i = 1;
    if(verbose)
		i = perror("\nError at 0x%a: wrote %x, read %x\n",
			(int)addr, wrote, read);
	lerrs++;
	terrs++;
	toterrs++;
	*addr = wrote;			/* try to reset to correct value */
	if(stop_on_errors) return i;
	else	return(0);
}


/*
**	This test should be replaced by one that would, say, have
**	an addq	in every location but the first few and would return
**	a value that could be tested.
*/
exec(start, stop)
unsigned short *start, *stop;
{
	register unsigned short *addr;
	if(verbose) {
		printf("  Exec Test: \n");
		printf("  Loading test area\r");
	}
	stop = (u_short *)((int)stop & -2);	/* round off for word addressing */
	for (addr = start; addr < stop-1; addr++)
		*addr = 0x4e71; 	/* nop */
			/* The rts can't be at stop because of instruction prefetching */
	*(stop-1) = 0x4e75;		/* rts */
	*(start) = 0x4280;		/* clr D0 */
	if (verbose) printf(" Jumping to test area\r");
	((int (*)())start)();
	if(verbose) erase_line(LEN);
	return (0);
}

# define ADDRLEN 32

uniq(start, stop)
unsigned long *start;
register unsigned long *stop;
{
	register unsigned long *addr;
	register unsigned long raddr, saddr;
	short n;

	if(verbose) printf("  Uniqueness test: \n");
	for (n = 0; n < ADDRLEN; n++) {
		if(verbose) printf("\r    Seed = %d (0x%2x) of %d   ",n,n,ADDRLEN);
		saddr = (((unsigned long)addr >> n)
		  | ((unsigned long)addr << (ADDRLEN-n)));
		for (addr = start; addr <= stop; addr++) *addr = saddr;
		for (addr = start; addr <= stop; addr++) {
			raddr = *addr;
			if (raddr != saddr && error(addr, saddr, raddr)) return 1;
		}
		if (mgetlocal())	return 1;
	}
	if(verbose) erase_line(LEN);
	return (0);
}

getans()
{
	char	c;
	int	i;

top:
	putchar(c= wgetlocal());
	if((c == '' || c == '') && user_exit){
		longjmp(memtest,c);
	}

	if(c == 'H' || c == '?') {
		printf("\n\nHELP:\n\
     The <ESC> key can be used to exit the current menu and go to the next\n\
     menu.   Carriage returns are not required for single character\n\
     input answers to menu queries.   Access can be made directly to \n\
     either menu item by pressing the desired command character.  When\n\
     a test is running, pressing any character will cause the test to\n\
     terminate and return to the Test Menu.  <^D> will exit the current\n\
     test and <^C> will return to the monitor.\n\
\nEnter letter of desired option: ");
		goto top;
	}
	putchar('\n');
	return(c);
}

erase_line(len)
register int len;
{
	register int i;
	putchar('\r');
	for(i = 0; i < len; i++) putchar(' ');
	return(putchar('\r'));
}

scale_init(start,stop,size)
register int start, stop, size;
{
	printf("S..........F\b\b\b\b\b\b\b\b\b\b\b");
	scale_value = (stop - start) / size;
	scale_trig = start + scale_value;
}

scale()
{
	scale_trig += scale_value;
	putchar('#');
}

estimate(start,stop,k)
register int start, stop, k;
{
	double time;

	if (verbose){
		time = (((stop - start)/ 0x4000) * k * cpu_time) /6400;
		if (time > 15) {
			printf(" (estimated time = ");
			print_time((int)time); putchar(')');
			putchar('\n');
		}
	}
}

mem_escape(buf)
char *buf;
{
	register char c;

	c = buf[strlen(buf)-1];
	longjmp(memtest,c);
}

mgetlocal()
{
	char	c;

	c = getlocal();
	if((c == '' || c == '') && user_exit){
		longjmp(memtest,c);
	}
	return(c);
}


#ifndef	PROMDIAG

print_time(time)
register int	time;
{
	int min, sec;

	if(time < 0) time = ~time + (24 * 3600);
	min = (time%3600)/60;
	sec = time%60;
	printf("%d:%c%d:%c%d", time/3600, (min > 9)? '\0':'0', min,
						  			   (sec > 9)? '\0':'0', sec);
}

#ifdef	V30
read_time()
{
	int	hour,minute,second;

	afcwb(NVRAM_CONTROL, NVRAM_READ);
	hour = bcd_to_binary(afcrb(NVRAM_HOUR));
	minute = bcd_to_binary(afcrb(NVRAM_MINUTE));
	second = bcd_to_binary(afcrb(NVRAM_SECOND));
	afcwb(NVRAM_CONTROL, 0);
	return((hour*3600)+(minute*60)+second);
}

bcd_to_binary(i)
register unsigned char i;
{
	return((i >> 4) * 10 + (i & 0x0f));
}
#endif	V30
#endif	PROMDIAG
