#include "saio.h"
#include "sais68k.h"

struct medevice {
	char           *mebase;
};

#define	NME	3
#define	MESIZE	(512 * 1024)	/* SRAM-2 == 512kb */
struct medevice *mestd[] = {
			    (struct medevice *) & vme_stdio[0x900000],
			    (struct medevice *) & vme_stdio[0xD00000],
			    (struct medevice *) & vme_stdio[0xF00000],
};

char           *me_base = 0;

meopen(io)
	register struct iob *io;
{
	int             i;

	if(io->i_boff != 0) {
		me_base = (struct medevice *) & vme_stdio[io->i_boff];
		io->i_boff = 0;
		io->i_fpart = 0;
	} else 
		me_base = mestd[io->i_unit];
	if (io->i_unit >= NME || !probe(me_base, &i)) {
		printf("me: controller not present\n");
		return (-1);
	}

	io->i_st.nbsec = 1024;
	io->i_st.nsect = 1;
	io->i_st.ntpc = 1;
	io->i_st.nspc = 1;
	io->i_st.ncyl = MESIZE / io->i_st.nbsec;
	io->i_st.off = NULL;
	if ((io->i_boff = diskpart(io)) < 0) {
		printf("me: bad offset\n");
		return (-1);
	}
	return (0);
}

mestrategy(io, func)
	register struct iob *io;
{
	int             me_offset;

/*	printf("bn=%d cc=%d ma=0x%x\n", io->i_bn, io->i_cc, io->i_ma);	/**/
	me_offset = io->i_bn * io->i_st.nbsec;
	switch (func) {
	case READ:
		me_bcopy(&me_base[me_offset], io->i_ma, io->i_cc);
		break;
	case WRITE:
		me_bcopy(io->i_ma, &me_base[me_offset], io->i_cc);
		break;
	default:
		printf("me: bad func (0x%x)\n", func);
		return (-1);
	}
	return (io->i_cc);
}

me_bcopy(src, dst, n)
	char           *src, *dst;
	int		n;
{
/*	printf("copying %d bytes from 0x%x to 0x%x\n", n, src, dst);	/**/
	while (n--)
		*dst++ = *src++;
}
