#include 	"saio.h"
#include 	"sais68k.h"
#include	<setjmp.h>
#include	"../machine/psl.h"
#include	"../machine/m68k.h"
#include	"../machine/trap.h"
#ifdef	QX
#include	"nvram.QX.h"
#endif	QX

extern int autoboot;
extern int hadint;
extern int dorte;
extern int ignore_intr;

#define 	MEMTRAP		*(int *)(0x08+getvbr())
#define 	ADRTRAP		*(int *)(0x0C+getvbr())

static jmp_buf	env;
static int	interrupt_on;

static 
probetrp()
{
	longjmp(env,1);
}

probe(addr,val)
	register short *addr, *val;
{
	register int 	ret = 1;
	register int	savmtrap = MEMTRAP;
	register int	savatrap = ADRTRAP;

	MEMTRAP = (int)probetrp;
	ADRTRAP = (int)probetrp;

	if ( !setjmp(env) ) {
		register int zzz = *addr;

		if (*val)
			;
		*val = zzz;
	} else
		ret = 0;
		
	MEMTRAP = savmtrap;
	ADRTRAP = savatrap;
	return (ret);
}

probeb(addr,val)
	register char *addr, *val;
{
	register int 	ret = 1;
	register int	savtrap = MEMTRAP;

	MEMTRAP = (int)probetrp;

	if ( !setjmp(env) )
		*val = *addr;
	else
		ret = 0;
		
	MEMTRAP = savtrap;
	return (ret);
}

probel(addr,val)
	register int *addr, *val;
{
	register int 	ret = 1;
	register int	savtrap = MEMTRAP;

	MEMTRAP = (int)probetrp;

	if ( !setjmp(env) )
		*val = *addr;
	else
		ret = 0;
		
	MEMTRAP = savtrap;
	return (ret);
}

probelw(addr,val)
	register int *addr, val;
{
	register int 	ret = 1;
	register int	savtrap = MEMTRAP;

	MEMTRAP = (int)probetrp;

	if ( !setjmp(env) )
		*addr = val;
	else
		ret = 0;
		
	MEMTRAP = savtrap;
	return (ret);
}

traperr(x)
	int x;
{
	register union esf *esf = (union esf *)(((int *)&x)+4);

#ifdef	VBUS
#ifdef	M68010
	if (interrupt_on  &&  esf->f0.esf_vec == 96) {
		turnoffint();			/* take away interrupt req */
		return;
	}
#endif	M68010
#endif	VBUS
	if (ignore_intr) {
		ignore_intr = 0;
		dorte = 1;
		return;
	}
	autoboot = 0;
	hadint = 1;
	printf("Trap: pc=%x,%x sw=%b vec=%x format=%x\n", 
		esf->f0.esf_pc, paddr(esf->f0.esf_pc), esf->f0.esf_sw, PSL_BITS,
		(esf->f0.esf_vec&ESF_VECMSK) >> ESF_VECSHIFT,
		(esf->f0.esf_vec&ESF_FMTMSK) >> ESF_FMTSHIFT );
	if ((esf->f0.esf_vec&ESF_FMTMSK) == ESF_FMT8 ||
	    (esf->f0.esf_vec&ESF_FMTMSK) == ESF_FMTA ||
	    (esf->f0.esf_vec&ESF_FMTMSK) == ESF_FMTB   ) {
#ifdef	M68010
		printf("  adr=%x,%x ssw=%x\n", esf->f8.esf_faddr_10, 
			paddr(esf->f8.esf_faddr_10), esf->f8.esf_ssw_10,
			ESF_SSW_10_BITS);
#else	M68010
		printf("  adr=%x,%x ssw=%b", esf->fa.esf_faddr_20, 
			paddr(esf->fa.esf_faddr_20), esf->fa.esf_ssw_20,
			ESF_SSW_20_BITS);
#if	defined(QX) || defined(M68030)
		printf("\n");
#else	QX
		printf(" esr=%b\n", *ESR, ESR_BERBITS);
#endif	QX
#endif	M68010
	}
}

paddr(x)
	register long x;
{
	register long ret = x;

# ifdef	QX
	ret = x;
# else	QX
#  ifdef	M68030
	return (ret & 0x0fffffff);
#  else	M68030
#  ifdef	M68020
	ret = x & NONT_MASK;
#  else	M68020
	ret=((((long)((*(short *)(((x&0x7FF000)>>11)|PAGREGBASE))&0xFFF))<<12)
		|(x&0xFFF));
#  endif	M68020
#  endif	M68020
# endif	QX
	return (ret);
}

onetoone(cache)
{
#ifndef	QX
#ifdef	M68020
	register int i, *p;
	
	p = (int *)TBUF_BASE_SYS;
	for (i = 0; i < NTBUFS ; i++) {
		*p = TBUF_VALID|PG_V|PG_R|PG_M|cache|i; /* system valid 1:1 */
		p += (TBUF_INCR/sizeof( int));
	}
	p = (int *)TBUF_BASE_USR;
	for (i = 0; i < NTBUFS ; i++) {
		*p = TBUF_VALID|PG_V|PG_R|PG_M|cache|i; /* user valid 1:1 */
		p += (TBUF_INCR/sizeof( int));
	}
#endif	QX
#endif	M68020
}

cpux()				/* return cluster node number */
{
	register int n = 0;
#ifdef	QX
	static struct nv_ram	nv_ram;

	if (getram(&nv_ram)) {
		printf("non-volatile ram error:  can't get cpu number\n");
		return(-1);
	}
	return(nv_ram.cpu_num);
#else	QX
#ifdef	M68020
	n = (~(*BSR))&BSR_CNODE;

	if (n == BSR_CNODE)
		n = 0;
#endif	M68020
#ifdef	VBUS
#ifdef	M68010
	register int i;
	int savedorte = dorte;

	dorte = 1;
	turnonint();
	for (i = 7;  i >= 0;  i -= 1) {
		_splx(0x2000 + (i << 8));
		DELAY(1000);
		_splx(0x2700);
		if (!interrupt_on) {
			dorte = savedorte;
			return i + 1;
		}
	}
	turnoffint();
	dorte = savedorte;
	n = 0;
#endif	M68010
#endif	VBUS
#endif	QX
	return n;
}

#ifdef	VBUS
#ifdef	M68010
mapin(vaddr, paddr, len)
	register unsigned long vaddr, paddr;
	register int len;
{
	do {
		*(short *)(((vaddr >> 11) | PAGREGBASE) & ~1) = paddr >> 12;
		vaddr += NBPG;
		paddr += NBPG;
	} while ((len -= NBPG) > 0);
}

turnonint()
{
	short s = *(short *)0xC1E000;

	interrupt_on = 1;
	return s;
}

turnoffint()
{
	short s = *(short *)0xC1A000;

	interrupt_on = 0;
	return s;
}
#endif	M68010
#endif	VBUS

#ifdef	QX
#include "qxoutport.h"
#include "../dev/sioreg.h"

#define	RAM_SEL_DELAY	10
#define RAM_LOW_DELAY	10
#define RAM_HIGH_DELAY	10

#define	SETSTROBE	(Q_OP_PORT2 = OP2_SET_STROBE)
#define	RESETSTROBE	(Q_OP_PORT2 = OP2_RES_STROBE)
#define	SETDATAOUT	(Q_OP_PORT2 = OP2_SET_DATOUT)
#define	RESETDATAOUT	(Q_OP_PORT2 = OP2_RES_DATOUT)


/*
 * Read all 16x16 bits of the non-volatile ram into memory at p.
 */
getram(p)
unsigned char *p;
{
	int	i;
	unsigned short *q;

	/*
	 * send an RCL instruction to the non-volatile RAM chip.
	 * The chip may not then be accessed again for 2.5 microseconds. 
	 */
	ramselect();
	shiftout(8, 0x85, RAM_LOW_DELAY, RAM_HIGH_DELAY);
	ramdeselect();
	DELAY(10);
	q = (short *)p;
	for (i=0;i<16;++i)
		*q++ = nv_readw(i);
	return(chkram(p));
}


/*
 * Write all 16x16 bits of memory at p into the non-volatile ram.
 */
putram(p)
unsigned char *p;
{
	int	i;
	unsigned short *q;

	q = (short *)p;
	for (i=0;i<16;++i)
		nv_writew(i, *q++);
	/*
	 * send an STO instruction to the ram.
	 */
	ramselect();
	shiftout(8, 0x81, RAM_LOW_DELAY, RAM_HIGH_DELAY);
	ramdeselect();
}

chkram(p)
unsigned char	*p;
{
	int             i;
	unsigned char	cksum;

	cksum = 0;
	for (i = 0; i < 31; ++i)
		cksum += *p++;
	if (*p == cksum)
		return (0);
	else
		return (-1);
}

/*
 * set the write enable latch so that writes are enabled. 
 */
nv_writew(ind, data)
{
	ramselect();
	shiftout(8, 0x84, RAM_LOW_DELAY, RAM_HIGH_DELAY);
	ramdeselect();
	/*
	 * Output the byte 1AAAA011 where the A's give the address. Then
	 * write the 16 bits of data. 
	 */
	ramselect();
	shiftout(8, 0x83 | (ind << 3), RAM_LOW_DELAY, RAM_HIGH_DELAY);
	shiftout(16, data, RAM_LOW_DELAY, RAM_HIGH_DELAY);
	ramdeselect();

	return (0);
}

/*
 * Output the byte 1AAAA11X where the A's give the address. The X value
 * should be a 1 for the QX. Then read 16 bits of data. 
 */
nv_readw(ind)
{
	unsigned short  res;

	ramselect();
	shiftout(8, 0x87 | (ind << 3), RAM_LOW_DELAY, RAM_HIGH_DELAY);
	res = shiftin(16, RAM_LOW_DELAY, RAM_HIGH_DELAY);
	ramdeselect();
	return res;
}

ramselect()
{
	SETDATAOUT;		/* Always have DATAOUT at logic 1, except for
				 * reading */
	Q_OP_PORT2 = OP2_SET_RAMSEL;	/* enable RAM */
	delaycycles(RAM_SEL_DELAY);
}

ramdeselect()
{
	Q_OP_PORT2 = OP2_RES_RAMSEL;	/* disable RAM */
}

/*
 * write a number of bits to the serial RAM or clock chip. Data is written
 * most signiicant bit first. Data is clocked on the positive going edge. 
 */
shiftout(nbits, shftreg, clklowdelay, clkhighdelay)
	register        nbits;
	register unsigned shftreg;
{
	register unsigned mask;

	for (mask = 1 << (nbits - 1); nbits-- > 0; mask >>= 1) {
		if (shftreg & mask) {
			SETDATAOUT;
		} else {
			RESETDATAOUT;
		}
		delaycycles(clklowdelay);
		SETSTROBE;
		delaycycles(clkhighdelay);
		RESETSTROBE;
	}
	SETDATAOUT;		/* Always leave DATAOUT set */
}


/*
 * read a number of bits from the serial RAM or clock chip. Data is read most
 * significant bit first. Data is read on the negative going edge. 
 */
shiftin(nbits, clklowdel, clkhighdel)
{
	register int    shftreg;

	for (shftreg = 0; nbits-- > 0;) {
		shftreg <<= 1;
		delaycycles(clklowdel);
		if (DATIN)
			shftreg++;
		SETSTROBE;
		delaycycles(clkhighdel);
		RESETSTROBE;
	}
	return (shftreg);
}

/*
 * read a number of bits from the serial RAM or clock chip. Data is read on
 * the negative going edge. This routine differs from that above in that data
 * is read least significant bit first. 
 */
lshiftin(nbits, clklowdel, clkhighdel)
{
	register        shftreg;
	register        mask;

	shftreg = 0;
	for (mask = 1; nbits-- > 0; mask <<= 1) {
		delaycycles(clklowdel);
		if (DATIN)
			shftreg |= mask;
		SETSTROBE;
		delaycycles(clkhighdel);
		RESETSTROBE;
	}
	return shftreg;
}

delaycycles(del)
	register short  del;
{
	del /= 3;		/* Assuming best case, cached DBRA in loop */
	if (del > 1) {
		del--;
		do {
		} while (--del != -1);
	}
}

#endif	QX

